/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectSwingSessionImpl;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.architect.swingui.Relationship;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.swingui.ChangeListeningDataEntryPanel;
import ca.sqlpower.swingui.ColorCellRenderer;
import ca.sqlpower.swingui.DataEntryPanelChangeUtil;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class RelationshipEditPanel
extends ChangeListeningDataEntryPanel
implements SPListener {
    private static final Logger logger = Logger.getLogger(RelationshipEditPanel.class);
    private final JPanel panel;
    private SQLRelationship relationship;
    private JDialog editDialog;
    private JTextField relationshipName;
    private JTextField pkLabelTextField;
    private JTextField fkLabelTextField;
    private ButtonGroup identifyingGroup;
    private JRadioButton identifyingButton;
    private JRadioButton nonIdentifyingButton;
    private JLabel pkTableName;
    private ButtonGroup pkTypeGroup;
    private JRadioButton pkTypeZeroToMany;
    private JRadioButton pkTypeOneToMany;
    private JRadioButton pkTypeZeroOne;
    private JRadioButton pkTypeOne;
    private JLabel fkTableName;
    private ButtonGroup fkTypeGroup;
    private JRadioButton fkTypeZeroToMany;
    private JRadioButton fkTypeOneToMany;
    private JRadioButton fkTypeZeroOne;
    private ButtonGroup deferrabilityGroup;
    private JRadioButton notDeferrable;
    private JRadioButton initiallyDeferred;
    private JRadioButton initiallyImmediate;
    private ButtonGroup updateRuleGroup;
    private JRadioButton updateCascade;
    private JRadioButton updateRestrict;
    private JRadioButton updateSetNull;
    private JRadioButton updateNoAction;
    private JRadioButton updateSetDefault;
    private ButtonGroup deleteRuleGroup;
    private JRadioButton deleteCascade;
    private JRadioButton deleteRestrict;
    private JRadioButton deleteSetNull;
    private JRadioButton deleteNoAction;
    private JRadioButton deleteSetDefault;
    private Relationship relationshipLine;
    private JComboBox relationLineColor;
    private Color color;
    Action customColour = new AbstractAction("Custom..."){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Color colour = ArchitectSwingSessionImpl.getCustomColour(RelationshipEditPanel.this.relationshipLine.getForegroundColor(), RelationshipEditPanel.this.panel);
            if (colour != null) {
                if (!RelationshipEditPanel.this.containsColor(Relationship.SUGGESTED_COLOURS, colour)) {
                    RelationshipEditPanel.this.relationLineColor.addItem(colour);
                }
                RelationshipEditPanel.this.relationLineColor.setSelectedItem(colour);
            }
        }
    };
    Action swapLabelText = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String parentText = RelationshipEditPanel.this.pkLabelTextField.getText();
            String childText = RelationshipEditPanel.this.fkLabelTextField.getText();
            RelationshipEditPanel.this.pkLabelTextField.setText(childText);
            RelationshipEditPanel.this.fkLabelTextField.setText(parentText);
        }
    };

    public RelationshipEditPanel(Relationship r) {
        this.relationshipLine = r;
        this.color = this.relationshipLine.getForegroundColor();
        FormLayout layout = new FormLayout("pref, 4dlu, pref:grow, 4dlu, pref, 4dlu, pref:grow, 4dlu, pref");
        layout.setColumnGroups((int[][])new int[][]{{3, 7}});
        DefaultFormBuilder fb = new DefaultFormBuilder(layout, (JPanel)(logger.isDebugEnabled() ? new FormDebugPanel() : new JPanel()));
        this.relationshipName = new JTextField();
        fb.append(Messages.getString("RelationshipEditPanel.name"), (Component)this.relationshipName, 7);
        fb.nextLine();
        this.relationLineColor = new JComboBox<Color>(Relationship.SUGGESTED_COLOURS);
        fb.append(Messages.getString("RelationshipEditPanel.lineColour"), this.relationLineColor);
        ColorCellRenderer renderer = new ColorCellRenderer(40, 20);
        this.relationLineColor.setRenderer(renderer);
        if (!this.containsColor(Relationship.SUGGESTED_COLOURS, this.color)) {
            this.relationLineColor.addItem(this.color);
            this.relationLineColor.setSelectedItem(this.color);
        }
        fb.append((Component)new JButton(this.customColour));
        fb.nextLine();
        this.pkLabelTextField = new JTextField();
        fb.append(Messages.getString("RelationshipEditPanel.pkLabel"), (Component)this.pkLabelTextField);
        this.fkLabelTextField = new JTextField();
        fb.append(Messages.getString("RelationshipEditPanel.fkLabel"), (Component)this.fkLabelTextField);
        JButton swapButton = new JButton(this.swapLabelText);
        swapButton.setIcon(SPSUtils.createIcon((String)"arrow_refresh", (String)"Swap Labels", (int)16));
        swapButton.setToolTipText("Swap Label Texts");
        fb.append((Component)swapButton);
        fb.nextLine();
        this.identifyingGroup = new ButtonGroup();
        this.identifyingButton = new JRadioButton(Messages.getString("RelationshipEditPanel.identifying"));
        fb.append(Messages.getString("RelationshipEditPanel.type"), (Component)this.identifyingButton, 7);
        this.identifyingGroup.add(this.identifyingButton);
        this.nonIdentifyingButton = new JRadioButton(Messages.getString("RelationshipEditPanel.nonIdentifying"));
        fb.append("", (Component)this.nonIdentifyingButton, 7);
        this.identifyingGroup.add(this.nonIdentifyingButton);
        fb.nextLine();
        fb.appendUnrelatedComponentsGapRow();
        this.pkTypeGroup = new ButtonGroup();
        this.fkTypeGroup = new ButtonGroup();
        fb.nextLine();
        this.pkTableName = new JLabel("PK Table: Unknown");
        fb.append(Messages.getString("RelationshipEditPanel.cardinality"), (Component)this.pkTableName);
        this.fkTableName = new JLabel("FK Table: Unknown");
        fb.append("", (Component)this.fkTableName);
        fb.nextLine();
        this.pkTypeZeroToMany = new JRadioButton(Messages.getString("RelationshipEditPanel.zeroOrMore"));
        fb.append("", (Component)this.pkTypeZeroToMany);
        this.pkTypeGroup.add(this.pkTypeZeroToMany);
        this.fkTypeZeroToMany = new JRadioButton(Messages.getString("RelationshipEditPanel.zeroOrMore"));
        fb.append("", (Component)this.fkTypeZeroToMany);
        this.fkTypeGroup.add(this.fkTypeZeroToMany);
        fb.nextLine();
        this.pkTypeOneToMany = new JRadioButton(Messages.getString("RelationshipEditPanel.oneOrMore"));
        fb.append("", (Component)this.pkTypeOneToMany);
        this.pkTypeGroup.add(this.pkTypeOneToMany);
        this.fkTypeOneToMany = new JRadioButton(Messages.getString("RelationshipEditPanel.oneOrMore"));
        fb.append("", (Component)this.fkTypeOneToMany);
        this.fkTypeGroup.add(this.fkTypeOneToMany);
        fb.nextLine();
        this.pkTypeZeroOne = new JRadioButton(Messages.getString("RelationshipEditPanel.zeroOrOne"));
        fb.append("", (Component)this.pkTypeZeroOne);
        this.pkTypeGroup.add(this.pkTypeZeroOne);
        this.fkTypeZeroOne = new JRadioButton(Messages.getString("RelationshipEditPanel.zeroOrOne"));
        fb.append("", (Component)this.fkTypeZeroOne);
        this.fkTypeGroup.add(this.fkTypeZeroOne);
        fb.nextLine();
        this.pkTypeOne = new JRadioButton(Messages.getString("RelationshipEditPanel.exactlyOne"));
        fb.append("", (Component)this.pkTypeOne);
        this.pkTypeGroup.add(this.pkTypeOne);
        fb.nextLine();
        fb.appendUnrelatedComponentsGapRow();
        fb.nextLine();
        this.deferrabilityGroup = new ButtonGroup();
        this.notDeferrable = new JRadioButton(Messages.getString("RelationshipEditPanel.notDeferrable"));
        fb.append(Messages.getString("RelationshipEditPanel.deferrability"), (Component)this.notDeferrable, 7);
        this.deferrabilityGroup.add(this.notDeferrable);
        this.initiallyDeferred = new JRadioButton(Messages.getString("RelationshipEditPanel.initiallyDeferred"));
        fb.append("", (Component)this.initiallyDeferred, 7);
        this.deferrabilityGroup.add(this.initiallyDeferred);
        this.initiallyImmediate = new JRadioButton(Messages.getString("RelationshipEditPanel.initiallyImmediate"));
        fb.append("", (Component)this.initiallyImmediate, 7);
        this.deferrabilityGroup.add(this.initiallyImmediate);
        fb.nextLine();
        fb.appendUnrelatedComponentsGapRow();
        this.updateRuleGroup = new ButtonGroup();
        this.deleteRuleGroup = new ButtonGroup();
        fb.nextLine();
        this.updateCascade = new JRadioButton(Messages.getString("RelationshipEditPanel.cascade"));
        fb.append(Messages.getString("RelationshipEditPanel.updateRule"), (Component)this.updateCascade);
        this.updateRuleGroup.add(this.updateCascade);
        this.deleteCascade = new JRadioButton(Messages.getString("RelationshipEditPanel.cascade"));
        fb.append(Messages.getString("RelationshipEditPanel.deleteRule"), (Component)this.deleteCascade);
        this.deleteRuleGroup.add(this.deleteCascade);
        fb.nextLine();
        this.updateRestrict = new JRadioButton(Messages.getString("RelationshipEditPanel.restrict"));
        fb.append("", (Component)this.updateRestrict);
        this.updateRuleGroup.add(this.updateRestrict);
        this.deleteRestrict = new JRadioButton(Messages.getString("RelationshipEditPanel.restrict"));
        fb.append("", (Component)this.deleteRestrict);
        this.deleteRuleGroup.add(this.deleteRestrict);
        fb.nextLine();
        this.updateNoAction = new JRadioButton(Messages.getString("RelationshipEditPanel.noAction"));
        fb.append("", (Component)this.updateNoAction);
        this.updateRuleGroup.add(this.updateNoAction);
        this.deleteNoAction = new JRadioButton(Messages.getString("RelationshipEditPanel.noAction"));
        fb.append("", (Component)this.deleteNoAction);
        this.deleteRuleGroup.add(this.deleteNoAction);
        fb.nextLine();
        this.updateSetNull = new JRadioButton(Messages.getString("RelationshipEditPanel.setNull"));
        fb.append("", (Component)this.updateSetNull);
        this.updateRuleGroup.add(this.updateSetNull);
        this.deleteSetNull = new JRadioButton(Messages.getString("RelationshipEditPanel.setNull"));
        fb.append("", (Component)this.deleteSetNull);
        this.deleteRuleGroup.add(this.deleteSetNull);
        fb.nextLine();
        this.updateSetDefault = new JRadioButton(Messages.getString("RelationshipEditPanel.setDefault"));
        fb.append("", (Component)this.updateSetDefault);
        this.updateRuleGroup.add(this.updateSetDefault);
        this.deleteSetDefault = new JRadioButton(Messages.getString("RelationshipEditPanel.setDefault"));
        fb.append("", (Component)this.deleteSetDefault);
        this.deleteRuleGroup.add(this.deleteSetDefault);
        fb.nextLine();
        this.setRelationship(r.getModel());
        this.relationshipName.selectAll();
        fb.setDefaultDialogBorder();
        this.panel = fb.getPanel();
    }

    private void setRelationship(SQLRelationship r) {
        this.relationship = r;
        this.relationshipName.setText(r.getName());
        this.pkLabelTextField.setText(r.getTextForParentLabel());
        this.fkLabelTextField.setText(r.getTextForChildLabel());
        this.relationLineColor.setSelectedItem(this.color);
        this.pkTableName.setText(Messages.getString("RelationshipEditPanel.pkTable", this.relationship.getPkTable().getName()));
        this.fkTableName.setText(Messages.getString("RelationshipEditPanel.fkTable", this.relationship.getFkTable().getName()));
        if (r.isIdentifying()) {
            this.identifyingButton.setSelected(true);
        } else {
            this.nonIdentifyingButton.setSelected(true);
        }
        int pkc = r.getPkCardinality();
        if (pkc == 7) {
            this.pkTypeZeroToMany.setSelected(true);
        } else if (pkc == 3) {
            this.pkTypeZeroOne.setSelected(true);
        } else if (pkc == 6) {
            this.pkTypeOneToMany.setSelected(true);
        } else if (pkc == 2) {
            this.pkTypeOne.setSelected(true);
        }
        int fkc = r.getFkCardinality();
        if (fkc == 7) {
            this.fkTypeZeroToMany.setSelected(true);
        } else if (fkc == 3) {
            this.fkTypeZeroOne.setSelected(true);
        } else if (fkc == 6) {
            this.fkTypeOneToMany.setSelected(true);
        }
        if (r.getDeferrability() == SQLRelationship.Deferrability.NOT_DEFERRABLE) {
            this.notDeferrable.setSelected(true);
        } else if (r.getDeferrability() == SQLRelationship.Deferrability.INITIALLY_DEFERRED) {
            this.initiallyDeferred.setSelected(true);
        } else if (r.getDeferrability() == SQLRelationship.Deferrability.INITIALLY_IMMEDIATE) {
            this.initiallyImmediate.setSelected(true);
        }
        if (r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.CASCADE) {
            this.updateCascade.setSelected(true);
        } else if (r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.NO_ACTION) {
            this.updateNoAction.setSelected(true);
        } else if (r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            this.updateRestrict.setSelected(true);
        } else if (r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.SET_DEFAULT) {
            this.updateSetDefault.setSelected(true);
        } else if (r.getUpdateRule() == SQLRelationship.UpdateDeleteRule.SET_NULL) {
            this.updateSetNull.setSelected(true);
        }
        if (r.getDeleteRule() == SQLRelationship.UpdateDeleteRule.CASCADE) {
            this.deleteCascade.setSelected(true);
        } else if (r.getDeleteRule() == SQLRelationship.UpdateDeleteRule.NO_ACTION) {
            this.deleteNoAction.setSelected(true);
        } else if (r.getDeleteRule() == SQLRelationship.UpdateDeleteRule.RESTRICT) {
            this.deleteRestrict.setSelected(true);
        } else if (r.getDeleteRule() == SQLRelationship.UpdateDeleteRule.SET_DEFAULT) {
            this.deleteSetDefault.setSelected(true);
        } else if (r.getDeleteRule() == SQLRelationship.UpdateDeleteRule.SET_NULL) {
            this.deleteSetNull.setSelected(true);
        }
        this.relationshipName.selectAll();
        this.addListeners();
    }

    private void addListeners() {
        SQLPowerUtils.listenToHierarchy((SPObject)this.relationship.getParent(), (SPListener)this);
        this.relationshipLine.addSPListener(this);
    }

    private void removeListeners() {
        SQLPowerUtils.unlistenToHierarchy((SPObject)this.relationship.getParent(), (SPListener)this);
        this.relationshipLine.removeSPListener(this);
    }

    public boolean applyChanges() {
        this.removeListeners();
        try {
            this.relationship.begin(Messages.getString("RelationshipEditPanel.modifyRelationshipProperties"));
            this.relationship.setName(this.relationshipName.getText());
            this.relationship.setPhysicalName(this.relationshipName.getText());
            this.relationship.setTextForParentLabel(this.pkLabelTextField.getText());
            this.relationship.setTextForChildLabel(this.fkLabelTextField.getText());
            try {
                this.relationship.setIdentifying(this.identifyingButton.isSelected());
            }
            catch (SQLObjectException ex) {
                logger.warn((Object)"Call to setIdentifying failed. Continuing with other properties.", (Throwable)ex);
            }
            this.relationshipLine.setForegroundColor((Color)this.relationLineColor.getSelectedItem());
            this.relationship.setPkCardinality(this.getSelectedPKCardinality());
            this.relationship.setFkCardinality(this.getSelectedFKCardinality());
            this.relationship.setDeferrability(this.getSelectedDeferrability());
            this.relationship.setUpdateRule(this.getSelectedUpdateRule());
            this.relationship.setDeleteRule(this.getSelectedDeleteRule());
            this.relationship.commit();
        }
        catch (Exception e) {
            this.relationship.rollback(e.getMessage());
            throw new RuntimeException(e);
        }
        return true;
    }

    public void discardChanges() {
        this.removeListeners();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public void setEditDialog(JDialog editDialog) {
        this.editDialog = editDialog;
    }

    private boolean containsColor(Vector<Color> colorSet, Color color) {
        boolean contains = false;
        for (Color eachColor : colorSet) {
            if (!eachColor.equals(color)) continue;
            contains = true;
        }
        return contains;
    }

    private int getSelectedPKCardinality() {
        if (this.pkTypeZeroOne.isSelected()) {
            return 3;
        }
        if (this.pkTypeZeroToMany.isSelected()) {
            return 7;
        }
        if (this.pkTypeOneToMany.isSelected()) {
            return 6;
        }
        if (this.pkTypeOne.isSelected()) {
            return 2;
        }
        throw new IllegalStateException("No PK cardinality selected");
    }

    private int getSelectedFKCardinality() {
        if (this.fkTypeZeroOne.isSelected()) {
            return 3;
        }
        if (this.fkTypeZeroToMany.isSelected()) {
            return 7;
        }
        if (this.fkTypeOneToMany.isSelected()) {
            return 6;
        }
        throw new IllegalStateException("No FK cardinality selected");
    }

    private SQLRelationship.Deferrability getSelectedDeferrability() {
        if (this.notDeferrable.isSelected()) {
            return SQLRelationship.Deferrability.NOT_DEFERRABLE;
        }
        if (this.initiallyDeferred.isSelected()) {
            return SQLRelationship.Deferrability.INITIALLY_DEFERRED;
        }
        if (this.initiallyImmediate.isSelected()) {
            return SQLRelationship.Deferrability.INITIALLY_IMMEDIATE;
        }
        throw new IllegalStateException("No deferrability selected");
    }

    private SQLRelationship.UpdateDeleteRule getSelectedUpdateRule() {
        if (this.updateCascade.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.CASCADE;
        }
        if (this.updateNoAction.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.NO_ACTION;
        }
        if (this.updateRestrict.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.RESTRICT;
        }
        if (this.updateSetDefault.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.SET_DEFAULT;
        }
        if (this.updateSetNull.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.SET_NULL;
        }
        throw new IllegalStateException("No update rule selected");
    }

    private SQLRelationship.UpdateDeleteRule getSelectedDeleteRule() {
        if (this.deleteCascade.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.CASCADE;
        }
        if (this.deleteNoAction.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.NO_ACTION;
        }
        if (this.deleteRestrict.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.RESTRICT;
        }
        if (this.deleteSetDefault.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.SET_DEFAULT;
        }
        if (this.deleteSetNull.isSelected()) {
            return SQLRelationship.UpdateDeleteRule.SET_NULL;
        }
        throw new IllegalStateException("No delete rule selected");
    }

    public void childRemoved(SPChildEvent e) {
        logger.debug((Object)("SQLObject child was removed: " + e));
        if (this.relationship.equals((Object)e.getChild())) {
            this.removeListeners();
            if (this.editDialog != null) {
                this.editDialog.dispose();
            }
        }
    }

    public void childAdded(SPChildEvent e) {
    }

    public void propertyChanged(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        boolean error = false;
        if (e.getSource() == this.relationship) {
            if (property.equals("name")) {
                error = DataEntryPanelChangeUtil.incomingChange((JTextComponent)this.relationshipName, (PropertyChangeEvent)e);
            } else if (property.equals("textForParentLabel")) {
                error = DataEntryPanelChangeUtil.incomingChange((JTextComponent)this.pkLabelTextField, (PropertyChangeEvent)e);
            } else if (property.equals("textForChildLabel")) {
                error = DataEntryPanelChangeUtil.incomingChange((JTextComponent)this.fkLabelTextField, (PropertyChangeEvent)e);
            } else if (property.equals("identifying")) {
                error = DataEntryPanelChangeUtil.incomingChange((ButtonGroup)this.identifyingGroup, (Object)this.identifyingButton.isSelected(), (PropertyChangeEvent)e);
            } else if (property.equals("pkCardinality")) {
                error = DataEntryPanelChangeUtil.incomingChange((ButtonGroup)this.pkTypeGroup, (Object)this.getSelectedPKCardinality(), (PropertyChangeEvent)e);
            } else if (property.equals("fkCardinality")) {
                error = DataEntryPanelChangeUtil.incomingChange((ButtonGroup)this.fkTypeGroup, (Object)this.getSelectedFKCardinality(), (PropertyChangeEvent)e);
            } else if (property.equals("deferrability")) {
                error = DataEntryPanelChangeUtil.incomingChange((ButtonGroup)this.deferrabilityGroup, (Object)this.getSelectedDeferrability(), (PropertyChangeEvent)e);
            } else if (property.equals("updateRule")) {
                error = DataEntryPanelChangeUtil.incomingChange((ButtonGroup)this.updateRuleGroup, (Object)this.getSelectedUpdateRule(), (PropertyChangeEvent)e);
            } else if (property.equals("deleteRule")) {
                error = DataEntryPanelChangeUtil.incomingChange((ButtonGroup)this.deleteRuleGroup, (Object)this.getSelectedDeleteRule(), (PropertyChangeEvent)e);
            }
        } else if (e.getSource() == this.relationshipLine && property.equals("foregroundColor")) {
            error = DataEntryPanelChangeUtil.incomingChange((JComboBox)this.relationLineColor, (PropertyChangeEvent)e);
        }
        if (error) {
            this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
        }
    }

    public void transactionEnded(TransactionEvent e) {
    }

    public void transactionRollback(TransactionEvent e) {
    }

    public void transactionStarted(TransactionEvent e) {
    }
}

