/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.AbstractPlacer;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.TableEditPanel;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.DataEntryPanel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CreateTableAction
extends AbstractArchitectAction {
    private static final Logger logger = Logger.getLogger(CreateTableAction.class);
    private static final String NEW_TABLE_NAME = "New_Table";

    public CreateTableAction(ArchitectFrame frame) {
        super(frame, Messages.getString("CreateTableAction.name"), Messages.getString("CreateTableAction.description"), "new_table");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 0));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        PlayPen playpen = this.getPlaypen();
        playpen.fireCancel();
        SQLTable t = null;
        t = new SQLTable();
        t.initFolders(true);
        playpen.resetTableNames();
        int suffix = playpen.uniqueTableSuffix(NEW_TABLE_NAME);
        if (suffix != 0) {
            t.setName("New_Table_" + suffix);
        } else {
            t.setName(NEW_TABLE_NAME);
        }
        TablePane tp = new TablePane(t, playpen.getContentPane());
        TablePlacer tablePlacer = new TablePlacer(playpen, tp);
        tablePlacer.dirtyup();
    }

    private class TablePlacer
    extends AbstractPlacer {
        private final TablePane tp;

        TablePlacer(PlayPen playpen, TablePane tp) {
            super(playpen);
            this.tp = tp;
        }

        @Override
        protected String getEditDialogTitle() {
            return Messages.getString("CreateTableAction.tablePropertiesDialogTitle");
        }

        @Override
        public DataEntryPanel place(final Point p) throws SQLObjectException {
            TableEditPanel editPanel = new TableEditPanel(this.playpen.getSession(), this.tp){

                @Override
                public boolean applyChanges() {
                    String warnings = this.generateWarnings();
                    if (warnings.length() == 0) {
                        ArchitectSwingSession session = CreateTableAction.this.getSession();
                        try {
                            session.getWorkspace().begin("Creating a SQLTable and TablePane");
                            if (super.applyChanges()) {
                                TablePlacer.this.tp.setName(((SQLTable)TablePlacer.this.tp.getModel()).getName());
                                session.getTargetDatabase().addChild((SQLObject)TablePlacer.this.tp.getModel());
                                TablePlacer.this.playpen.selectNone();
                                TablePlacer.this.playpen.addTablePane(TablePlacer.this.tp, p);
                                TablePlacer.this.tp.setSelected(true, 4);
                                session.getWorkspace().commit();
                                return true;
                            }
                            session.getWorkspace().rollback("Error creating table and table pane");
                            return false;
                        }
                        catch (Throwable t) {
                            session.getWorkspace().rollback("Error creating table and table pane");
                            throw new RuntimeException(t);
                        }
                    }
                    JOptionPane.showMessageDialog(this.getPanel(), warnings);
                    return false;
                }
            };
            editPanel.setNameText(((SQLTable)this.tp.getModel()).getName());
            editPanel.setPhysicalNameText(((SQLTable)this.tp.getModel()).getPhysicalName());
            editPanel.setPkNameText(((SQLTable)this.tp.getModel()).getName() + "_pk");
            return editPanel;
        }
    }
}

