/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPSession;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.olap.OLAPObjectListCellRenderer;
import ca.sqlpower.architect.swingui.olap.OLAPObjectNameValidator;
import ca.sqlpower.architect.swingui.olap.ViewEntryPanel;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLDatabaseMapping;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.validation.Validator;
import ca.sqlpower.validation.swingui.FormValidationHandler;
import ca.sqlpower.validation.swingui.StatusComponent;
import ca.sqlpower.validation.swingui.ValidatableDataEntryPanel;
import ca.sqlpower.validation.swingui.ValidationHandler;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class CubeEditPanel
implements ValidatableDataEntryPanel {
    private static final Logger logger = Logger.getLogger(CubeEditPanel.class);
    private final MondrianModel.Cube cube;
    private final JPanel panel;
    private JTextField nameField;
    private JTextField captionField;
    private JComboBox defMeasure;
    private JComboBox tableChooser;
    private JTextArea selectStatements;
    private JTextField viewAlias;
    private FormValidationHandler handler;
    private StatusComponent status = new StatusComponent();
    private JRadioButton tableRadioButton;
    private JRadioButton viewRadioButton;

    public CubeEditPanel(MondrianModel.Cube cube, final PlayPen playPen, SQLDatabaseMapping dbMapping) throws SQLObjectException {
        this.cube = cube;
        List<SQLTable> tables = OLAPUtil.getAvailableTables(cube);
        FormLayout layout = new FormLayout("left:max(40dlu;pref), 3dlu, 80dlu:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.status, 3);
        this.nameField = new JTextField(cube.getName());
        builder.append("Name", (Component)this.nameField);
        this.captionField = new JTextField(cube.getCaption());
        builder.append("Caption", (Component)this.captionField);
        ArrayList<MondrianModel.Measure> measures = new ArrayList<MondrianModel.Measure>(cube.getMeasures());
        measures.add(0, null);
        this.defMeasure = new JComboBox<Object>(measures.toArray());
        builder.append("Default Measure", this.defMeasure);
        this.defMeasure.setRenderer(new OLAPObjectListCellRenderer());
        for (MondrianModel.Measure ms : cube.getMeasures()) {
            if (!ms.getName().equals(cube.getDefaultMeasure())) continue;
            this.defMeasure.setSelectedItem((Object)ms);
            break;
        }
        final JButton viewEditButton = new JButton(new AbstractAction("Edit..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                JDialog dialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)new ViewEntryPanel(playPen.getSession(), CubeEditPanel.this.getDatabase(), CubeEditPanel.this), (Component)playPen, (String)"View Builder", (String)DataEntryPanelBuilder.OK_BUTTON_LABEL);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        builder.appendSeparator("Fact Table");
        this.tableChooser = new JComboBox<SQLTable>(new Vector<SQLTable>(tables));
        this.selectStatements = new JTextArea("", 4, 30);
        final JScrollPane selectStatementsPane = new JScrollPane(this.selectStatements);
        AbstractAction radioButtonsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                CubeEditPanel.this.tableChooser.setEnabled(CubeEditPanel.this.tableRadioButton.isSelected());
                selectStatementsPane.setEnabled(CubeEditPanel.this.viewRadioButton.isSelected());
                CubeEditPanel.this.viewAlias.setEnabled(CubeEditPanel.this.viewRadioButton.isSelected());
                viewEditButton.setEnabled(CubeEditPanel.this.viewRadioButton.isSelected());
            }
        };
        this.tableRadioButton = new JRadioButton();
        this.tableRadioButton.setAction(radioButtonsAction);
        this.tableRadioButton.setText("Use Existing Table");
        this.viewRadioButton = new JRadioButton();
        this.viewRadioButton.setAction(radioButtonsAction);
        this.viewRadioButton.setText("Use View");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.tableRadioButton);
        buttonGroup.add(this.viewRadioButton);
        DefaultFormBuilder factBuilder = new DefaultFormBuilder(new FormLayout("9dlu, 3dlu, pref, 3dlu, pref:grow"));
        builder.append((Component)factBuilder.getPanel(), 3);
        factBuilder.append((Component)this.tableRadioButton, 5);
        factBuilder.append("", (Component)this.tableChooser, 3);
        factBuilder.append((Component)this.viewRadioButton, 5);
        this.viewAlias = new JTextField();
        factBuilder.append("", (Component)new JLabel("Alias"), (Component)this.viewAlias);
        factBuilder.append("", (Component)new JLabel("SELECT Statements"), 3);
        factBuilder.append("", (Component)selectStatementsPane, 3);
        factBuilder.append("", (Component)viewEditButton);
        factBuilder.nextLine();
        this.selectStatements.setLineWrap(true);
        this.selectStatements.setEditable(false);
        if (cube.getFact() instanceof MondrianModel.View) {
            this.viewRadioButton.doClick();
            this.tableRadioButton.setEnabled(false);
            this.tableChooser.setEnabled(false);
            List<MondrianModel.SQL> selects = ((MondrianModel.View)cube.getFact()).getSelects();
            for (MondrianModel.SQL sql : selects) {
                if (sql.getDialect() != null && !sql.getDialect().equals("generic")) continue;
                this.selectStatements.append(sql.getText());
                break;
            }
            if (this.selectStatements.getText().trim().length() == 0 && !selects.isEmpty()) {
                this.selectStatements.append(selects.get(0).getText());
            }
        } else if (tables.isEmpty()) {
            this.tableChooser.addItem("Database has no tables");
            this.viewRadioButton.doClick();
            this.tableRadioButton.setEnabled(false);
            this.tableChooser.setEnabled(false);
        } else {
            SQLTable t = OLAPUtil.tableForCube(cube);
            if (tables.contains(t)) {
                this.tableChooser.setSelectedItem(t);
                this.tableRadioButton.doClick();
            } else if (cube.getFact() != null) {
                this.viewRadioButton.doClick();
            } else {
                this.tableRadioButton.doClick();
            }
        }
        this.panel = builder.getPanel();
        this.handler = new FormValidationHandler(this.status);
        OLAPObjectNameValidator validator = new OLAPObjectNameValidator((OLAPObject)cube.getParent(), cube, false);
        this.handler.addValidateObject((JComponent)this.nameField, (Validator)validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean applyChanges() {
        try {
            this.cube.begin("Modify cube properties");
            if (this.tableRadioButton.isSelected()) {
                SQLTable table;
                if (this.tableChooser.isEnabled() && (table = (SQLTable)this.tableChooser.getSelectedItem()) != null) {
                    MondrianModel.Table t = new MondrianModel.Table();
                    t.setName(table.getName());
                    t.setSchema(OLAPUtil.getQualifier(table));
                    this.cube.setFact(t);
                }
            } else if (this.viewRadioButton.isSelected()) {
                MondrianModel.View view = new MondrianModel.View();
                view.setAlias(this.viewAlias.getText());
                MondrianModel.SQL sql = new MondrianModel.SQL();
                sql.setText(this.selectStatements.getText());
                view.addSelect(sql);
                this.cube.setFact(view);
            }
            this.cube.setName(this.nameField.getText());
            if (!this.captionField.getText().equals("")) {
                this.cube.setCaption(this.captionField.getText());
            } else {
                this.cube.setCaption(null);
            }
            MondrianModel.Measure ms = (MondrianModel.Measure)((Object)this.defMeasure.getSelectedItem());
            this.cube.setDefaultMeasure(ms == null ? null : ms.getName());
        }
        finally {
            this.cube.commit();
        }
        return true;
    }

    public void discardChanges() {
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public ValidationHandler getValidationHandler() {
        return this.handler;
    }

    private SQLDatabase getDatabase() {
        return ((OLAPSession)SQLPowerUtils.getAncestor((SPObject)this.cube, OLAPSession.class)).getDatabase();
    }

    public String getSelectText() {
        return this.selectStatements.getText();
    }

    public void setSelectText(String text) {
        this.selectStatements.setText(text);
    }

    public void setViewSelected() {
        this.viewRadioButton.doClick();
    }
}

