/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.preauth.j2ee;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.MutableGrantedAuthoritiesContainer;
import org.springframework.security.authoritymapping.Attributes2GrantedAuthoritiesMapper;
import org.springframework.security.authoritymapping.MappableAttributesRetriever;
import org.springframework.security.authoritymapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.security.ui.AuthenticationDetailsSourceImpl;
import org.springframework.util.Assert;

public abstract class AbstractPreAuthenticatedAuthenticationDetailsSource
extends AuthenticationDetailsSourceImpl {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected String[] j2eeMappableRoles;
    protected Attributes2GrantedAuthoritiesMapper j2eeUserRoles2GrantedAuthoritiesMapper = new SimpleAttributes2GrantedAuthoritiesMapper();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.j2eeMappableRoles, (String)"No mappable roles available");
        Assert.notNull((Object)this.j2eeUserRoles2GrantedAuthoritiesMapper, (String)"Roles to granted authorities mapper not set");
    }

    public Object buildDetails(Object context) {
        Object result = super.buildDetails(context);
        if (result instanceof MutableGrantedAuthoritiesContainer) {
            String[] j2eeUserRoles = this.getUserRoles(context, this.j2eeMappableRoles);
            GrantedAuthority[] userGas = this.j2eeUserRoles2GrantedAuthoritiesMapper.getGrantedAuthorities(j2eeUserRoles);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("J2EE user roles [" + Arrays.asList(j2eeUserRoles) + "] mapped to Granted Authorities: [" + Arrays.asList(userGas) + "]"));
            }
            ((MutableGrantedAuthoritiesContainer)result).setGrantedAuthorities(userGas);
        }
        return result;
    }

    protected abstract String[] getUserRoles(Object var1, String[] var2);

    public void setMappableRolesRetriever(MappableAttributesRetriever aJ2eeMappableRolesRetriever) {
        this.j2eeMappableRoles = aJ2eeMappableRolesRetriever.getMappableAttributes();
    }

    public void setUserRoles2GrantedAuthoritiesMapper(Attributes2GrantedAuthoritiesMapper mapper) {
        this.j2eeUserRoles2GrantedAuthoritiesMapper = mapper;
    }
}

