/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.createfolder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.createfile.JobEntryCreateFile;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryCreateFolder
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String foldername;
    private boolean failOfFolderExists;

    public JobEntryCreateFolder(String n) {
        super(n, "");
        this.foldername = null;
        this.failOfFolderExists = true;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.CREATE_FOLDER);
    }

    public JobEntryCreateFolder() {
        this("");
    }

    public JobEntryCreateFolder(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryCreateFolder je = (JobEntryCreateFolder)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"foldername", (String)this.foldername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"fail_of_folder_exists", (boolean)this.failOfFolderExists));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.foldername = XMLHandler.getTagValue((Node)entrynode, (String)"foldername");
            this.failOfFolderExists = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"fail_of_folder_exists"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'create folder' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.foldername = rep.getJobEntryAttributeString(id_jobentry, "foldername");
            this.failOfFolderExists = rep.getJobEntryAttributeBoolean(id_jobentry, "fail_of_folder_exists");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'create Folder' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "foldername", this.foldername);
            rep.saveJobEntryAttribute(id_job, this.getID(), "fail_of_folder_exists", this.failOfFolderExists);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'create Folder' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setFoldername(String foldername) {
        this.foldername = foldername;
    }

    public String getFoldername() {
        return this.foldername;
    }

    public String getRealFoldername() {
        return this.environmentSubstitute(this.getFoldername());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setResult(false);
        if (this.foldername != null) {
            FileObject FolderObject;
            String realFoldername;
            block17: {
                realFoldername = this.getRealFoldername();
                FolderObject = null;
                FolderObject = KettleVFS.getFileObject((String)realFoldername);
                if (FolderObject.exists()) {
                    boolean isFolder = false;
                    if (FolderObject.getType() == FileType.FOLDER) {
                        isFolder = true;
                    }
                    if (this.isFailOfFolderExists()) {
                        result.setResult(false);
                        if (isFolder) {
                            log.logError(this.toString(), "Folder [" + realFoldername + "] exists, failing.", new Object[0]);
                        } else {
                            log.logError(this.toString(), "File [" + realFoldername + "] exists, failing.", new Object[0]);
                        }
                    } else {
                        result.setResult(true);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), "Folder [" + realFoldername + "] already exists, not recreating.", new Object[0]);
                        }
                    }
                    break block17;
                }
                FolderObject.createFolder();
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), "Folder [" + realFoldername + "] created!", new Object[0]);
                }
                result.setResult(true);
            }
            Object var11_11 = null;
            if (FolderObject == null) return result;
            try {
                FolderObject.close();
                return result;
            }
            catch (IOException ex) {}
            return result;
            {
                catch (IOException e) {
                    log.logError(this.toString(), "Could not create Folder [" + realFoldername + "], exception: " + e.getMessage(), new Object[0]);
                    result.setResult(false);
                    result.setNrErrors(1L);
                    Object var11_12 = null;
                    if (FolderObject == null) return result;
                    try {
                        FolderObject.close();
                        return result;
                    }
                    catch (IOException ex) {}
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var11_13 = null;
                if (FolderObject == null) throw throwable;
                try {
                    FolderObject.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        log.logError(this.toString(), "No Foldername is defined.", new Object[0]);
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isFailOfFolderExists() {
        return this.failOfFolderExists;
    }

    public void setFailOfFolderExists(boolean failIfFolderExists) {
        this.failOfFolderExists = failIfFolderExists;
    }

    public static void main(String[] args) {
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        new JobEntryCreateFile().check(remarks, null);
        System.out.printf("Remarks: %s\n", remarks);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
    }
}

