/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.db;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.swingui.DataEntryPanel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;

public class DataSourceTypeCopyPropertiesPanel
implements DataEntryPanel {
    private final JPanel panel;
    private final JDBCDataSourceType dsType;
    private final JComboBox dsTypesComboBox;

    public DataSourceTypeCopyPropertiesPanel(JDBCDataSourceType type, DataSourceCollection collection) {
        this.dsType = type;
        ArrayList<JDBCDataSourceType> types = new ArrayList<JDBCDataSourceType>(collection.getDataSourceTypes());
        types.remove(this.dsType);
        this.dsTypesComboBox = new JComboBox<Object>(types.toArray());
        this.dsTypesComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (c instanceof JLabel && value != null) {
                    ((JLabel)c).setText(((JDBCDataSourceType)value).getName());
                }
                return c;
            }
        });
        this.panel = this.buildUI();
    }

    private JPanel buildUI() {
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref"));
        builder.setDefaultDialogBorder();
        builder.append((Component)new JLabel("Copy all properties from which data source type?"));
        builder.append((Component)this.dsTypesComboBox);
        builder.append((Component)new JLabel("Note: This will overwrite all current settings on " + this.dsType.getName() + "."));
        return builder.getPanel();
    }

    @Override
    public boolean applyChanges() {
        JDBCDataSourceType defaultDSType = (JDBCDataSourceType)this.dsTypesComboBox.getSelectedItem();
        if (defaultDSType != null && defaultDSType != this.dsType) {
            for (String key : defaultDSType.getPropertyNames()) {
                if ("Name".equals(key)) continue;
                this.dsType.putProperty(key, defaultDSType.getProperty(key));
            }
        }
        return true;
    }

    @Override
    public void discardChanges() {
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return true;
    }

    JComboBox getDsTypesComboBox() {
        return this.dsTypesComboBox;
    }
}

