/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.map;

import com.googlecode.d2j.util.Mapper;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InheritanceTree
implements Mapper {
    Map<String, Clz> clzMap = new HashMap<String, Clz>();
    String from;
    boolean isLibrary;

    public static void main(String ... args) {
        InheritanceTree tree = new InheritanceTree();
        Clz a = tree.addClz(0, "La;");
        a.addMethod(0, "abc", new String[0], "V");
        Clz b = tree.addClz(0, "Lb;");
        b.addMethod(0, "abc", new String[0], "V");
        Clz c = tree.addClz(0, "Lc;");
        c.relateSuper("Ljava/lang/Object;");
        c.relateInterface("La;");
        c.relateInterface("Lb;");
        tree.link();
    }

    private static boolean isPrivate(int accessFlags) {
        return (2 & accessFlags) != 0;
    }

    private static boolean isStaticOrPrivate(int accessFlags) {
        return (0xA & accessFlags) != 0;
    }

    private static boolean isStaticOrPrivateOrFinal(int accessFlags) {
        return (0x1A & accessFlags) != 0;
    }

    public void updateFrom(String from, boolean isLibrary) {
        this.from = from;
        this.isLibrary = isLibrary;
    }

    @Override
    public String mapClassName(String name) {
        Clz clz = this.clzMap.get(name);
        if (clz == null) {
            return null;
        }
        return clz.name.newValue;
    }

    public void recordClassRenameTo(String old, String newName) {
        Clz clz = this.clzMap.get(old);
        if (clz == null) {
            this.WARN("WARN: cant find class %s", old);
            return;
        }
        if (clz.name.noRename) {
            this.WARN("WARN: cant rename class %s", new Object[0]);
            return;
        }
        clz.name.newValue = newName;
    }

    public void recordMethodRenameTo(String owner, String oldName, String[] args, String ret, String newName) {
        Clz clz = this.clzMap.get(owner);
        if (clz == null) {
            this.WARN("WARN: cant find class %s", owner);
            return;
        }
        String key = InheritanceTree.toMethodKey(oldName, args, ret);
        Mtd mtd = clz.methods.get(key);
        if (mtd == null) {
            this.WARN("WARN: cant find method %s->%s", owner, key);
            return;
        }
        if (mtd.name.noRename && !oldName.equals(newName)) {
            this.WARN("WARN: cant rename method %s->%s to %s", owner, key, newName);
            return;
        }
        if (mtd.name.newValue == null) {
            mtd.name.newValue = newName;
        } else if (!newName.equals(mtd.name.newValue)) {
            this.WARN("WARN: cant rename method %s->%s to %s, pre rename to %s", owner, key, newName, mtd.name.newValue);
        }
    }

    public void recordFieldRenameTo(String owner, String oldName, String type, String newName) {
        Clz clz = this.clzMap.get(owner);
        if (clz == null) {
            this.WARN("WARN: cant find class %s", owner);
            return;
        }
        String key = InheritanceTree.toFieldKey(oldName, type);
        Fld fld = clz.fields.get(key);
        if (fld == null) {
            this.WARN("WARN: cant find field %s->%s", owner, key);
            return;
        }
        if (fld.name.noRename && !oldName.equals(newName)) {
            this.WARN("WARN: cant rename field %s->%s to %s", owner, key, newName);
            return;
        }
        if (fld.name.newValue == null) {
            fld.name.newValue = newName;
        } else if (!newName.equals(fld.name.newValue)) {
            this.WARN("WARN: cant rename field %s->%s to %s, pre rename to %s", owner, key, newName, fld.name.newValue);
        }
    }

    @Override
    public String mapFieldName(String owner, String name, String type) {
        Clz clz = this.clzMap.get(owner);
        if (clz == null) {
            return null;
        }
        Fld fld = clz.fields.get(InheritanceTree.toFieldKey(name, type));
        if (fld == null) {
            return null;
        }
        return fld.name.newValue;
    }

    @Override
    public String mapFieldOwner(String owner, String name, String type) {
        Clz clz = this.clzMap.get(owner);
        if (clz == null) {
            return null;
        }
        Fld fld = clz.fields.get(InheritanceTree.toFieldKey(name, type));
        if (fld == null) {
            return clz.name.newValue;
        }
        Name fldName = fld.owner.name;
        if (fldName.newValue == null) {
            return fldName.oldValue;
        }
        return fldName.newValue;
    }

    @Override
    public String mapMethodName(String owner, String name, String[] args, String ret) {
        Clz clz = this.clzMap.get(owner);
        if (clz == null) {
            return null;
        }
        Mtd mtd = null;
        if (args == null || ret == null) {
            for (Mtd m : clz.methods.values()) {
                if (m.args.length != 0 || !m.name.oldValue.equals(name)) continue;
                mtd = m;
                break;
            }
        } else {
            mtd = clz.methods.get(InheritanceTree.toMethodKey(name, args, ret));
        }
        if (mtd == null) {
            return null;
        }
        return mtd.name.newValue;
    }

    @Override
    public String mapMethodOwner(String owner, String name, String[] args, String ret) {
        Clz clz = this.clzMap.get(owner);
        if (clz == null) {
            return null;
        }
        Mtd mtd = null;
        if (args == null || ret == null) {
            for (Mtd m : clz.methods.values()) {
                if (m.args.length != 0 || !m.name.oldValue.equals(name)) continue;
                mtd = m;
                break;
            }
        } else {
            mtd = clz.methods.get(InheritanceTree.toMethodKey(name, args, ret));
        }
        if (mtd == null) {
            return clz.name.newValue;
        }
        Name mtdName = mtd.owner.name;
        if (mtdName.newValue == null) {
            return mtdName.oldValue;
        }
        return mtdName.newValue;
    }

    Clz addClz(int accessFlags, String name) {
        Clz clz = this.getOrCreateClz(name);
        if (clz.stat != Stat.UNKNOWN) {
            if (clz.stat == Stat.LIBRARY && !this.isLibrary) {
                this.WARN("app class %s redefined, org %s, new %s, skiping.", name, clz.from, this.from);
                return null;
            }
            this.WARN("class %s is defined in %s, skip redefine in %s", name, clz.from, this.from);
            return null;
        }
        clz.stat = this.isLibrary ? Stat.LIBRARY : Stat.APP;
        clz.accessFlags = accessFlags;
        clz.from = this.from;
        return clz;
    }

    public void link() {
        Name name;
        String key;
        UniqueQueue q = new UniqueQueue();
        q.addAll(this.clzMap.values());
        while (!q.isEmpty()) {
            Clz clz2 = (Clz)q.poll();
            for (Map.Entry<String, Mtd> entry : clz2.methods.entrySet()) {
                Mtd childMtd;
                key = entry.getKey();
                Mtd mtd = entry.getValue();
                mtd.name = name = mtd.name.trim();
                if (name.oldValue.startsWith("<") || InheritanceTree.isPrivate(mtd.accessFlags)) continue;
                if (clz2.children.size() > 0) {
                    for (Clz child : clz2.children) {
                        childMtd = child.methods.get(key);
                        if (childMtd != null) {
                            if (InheritanceTree.isStaticOrPrivateOrFinal(childMtd.accessFlags)) continue;
                            childMtd.name = this.merge(name, childMtd.name);
                            continue;
                        }
                        child.methods.put(key, mtd);
                        q.add(child);
                    }
                }
                if (clz2.impls.size() <= 0) continue;
                for (Clz child : clz2.impls) {
                    childMtd = child.methods.get(key);
                    if (childMtd != null) {
                        childMtd.name = this.merge(name, childMtd.name);
                        continue;
                    }
                    child.methods.put(key, mtd);
                    q.add(child);
                }
            }
        }
        q.addAll(this.clzMap.values());
        while (!q.isEmpty()) {
            Clz clz = (Clz)q.poll();
            if (clz.fields.size() <= 0) continue;
            for (Map.Entry<String, Object> entry : clz.fields.entrySet()) {
                key = entry.getKey();
                Fld fld = (Fld)entry.getValue();
                if (InheritanceTree.isPrivate(fld.accessFlags) || clz.children.size() <= 0) continue;
                for (Clz child : clz.children) {
                    if (child.fields.containsKey(key)) continue;
                    child.fields.put(key, fld);
                    q.add(child);
                }
            }
        }
        for (Clz clz : this.clzMap.values()) {
            boolean noRename;
            if (clz.stat == Stat.UNKNOWN) {
                this.WARN("clz %s is unknow", clz.name);
            }
            clz.name.noRename = noRename = clz.stat == Stat.UNKNOWN || clz.stat == Stat.LIBRARY;
            if (clz.methods.size() > 0) {
                for (Mtd mtd : clz.methods.values()) {
                    mtd.name = name = mtd.name.trim();
                    if (!noRename) continue;
                    name.noRename = true;
                }
            }
            if (noRename && clz.fields.size() > 0) {
                for (Fld fld : clz.fields.values()) {
                    fld.name.noRename = true;
                }
            }
            clz.children = null;
            clz.impls = null;
            clz.superClz = null;
            clz.interfaces = null;
        }
    }

    private Name merge(Name name, Name childMtd) {
        if ((childMtd = childMtd.trim()) != name) {
            childMtd.next = name;
        }
        return name;
    }

    private boolean isPrivateOrFinal(int accessFlags) {
        return (0x12 & accessFlags) != 0;
    }

    private void WARN(String s, Object ... args) {
        System.err.println(String.format(s, args));
    }

    Clz getOrCreateClz(String name) {
        Clz clz = this.clzMap.get(name);
        if (clz == null) {
            clz = new Clz(name);
            this.clzMap.put(name, clz);
        }
        return clz;
    }

    public static String toFieldKey(String name, String type) {
        return String.valueOf(name) + ":" + type;
    }

    public static String toMethodKey(String name, String[] args, String ret) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append("(");
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            sb.append(arg);
            ++n2;
        }
        sb.append(")").append(ret);
        return sb.toString();
    }

    public class Clz {
        public final Name name;
        public Stat stat = Stat.UNKNOWN;
        public String from;
        public int accessFlags;
        public Clz superClz;
        public Set<Clz> interfaces = new HashSet<Clz>();
        public Set<Clz> children = new HashSet<Clz>();
        public Set<Clz> impls = new HashSet<Clz>();
        public Map<String, Mtd> methods = new HashMap<String, Mtd>();
        public Map<String, Fld> fields = new HashMap<String, Fld>();

        Clz(String name) {
            this.name = new Name(name);
        }

        public String toString() {
            return this.name.toString();
        }

        public void relateSuper(String name) {
            Clz s;
            this.superClz = s = InheritanceTree.this.getOrCreateClz(name);
            s.children.add(this);
        }

        public void relateInterface(String itf) {
            Clz s = InheritanceTree.this.getOrCreateClz(itf);
            this.interfaces.add(s);
            s.impls.add(this);
        }

        public void addMethod(int accessFlags, String name, String[] args, String ret) {
            String key = InheritanceTree.toMethodKey(name, args, ret);
            if (this.methods.containsKey(key)) {
                InheritanceTree.this.WARN("DUP method: %s in class %s, skiping.", new Object[]{key, this.name});
                return;
            }
            Mtd mtd = new Mtd();
            mtd.owner = this;
            mtd.accessFlags = accessFlags;
            mtd.name = new Name(name);
            mtd.ret = ret;
            mtd.args = args;
            this.methods.put(key, mtd);
        }

        public void addField(int accessFlags, String name, String type) {
            String key = InheritanceTree.toFieldKey(name, type);
            if (this.fields.containsKey(key)) {
                InheritanceTree.this.WARN("DUP field: %s in class %s, skiping.", new Object[]{key, this.name});
                return;
            }
            Fld fld = new Fld();
            fld.owner = this;
            fld.name = new Name(name);
            fld.accessFlags = accessFlags;
            fld.type = type;
            this.fields.put(key, fld);
        }
    }

    public static class Fld {
        public int accessFlags;
        public Name name;
        public Clz owner;
        public String type;
    }

    public static class Mtd {
        public int accessFlags;
        public Name name;
        public Clz owner;
        public String ret;
        public String[] args;
    }

    public static class Name {
        final String oldValue;
        boolean noRename = false;
        String newValue;
        Name next;

        public Name(String name) {
            this.oldValue = name;
        }

        public String toString() {
            return this.oldValue;
        }

        public Name trim() {
            Name n = this;
            while (n.next != null) {
                n = n.next;
            }
            return n;
        }
    }

    public static enum Stat {
        UNKNOWN,
        LIBRARY,
        APP;

    }
}

