/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.Method;
import com.googlecode.d2j.dex.BaseDexExceptionHandler;
import com.googlecode.d2j.dex.Dex2jar;
import com.googlecode.d2j.node.DexMethodNode;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.smali.BaksmaliDumper;
import com.googlecode.d2j.smali.Smali;
import com.googlecode.dex2jar.ir.ET;
import com.googlecode.dex2jar.tools.BaseCmd;
import com.googlecode.dex2jar.tools.Dex2jarCmd;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.objectweb.asm.MethodVisitor;

public class BaksmaliBaseDexExceptionHandler
extends BaseDexExceptionHandler {
    private Map<DexMethodNode, Exception> exceptionMap = new HashMap<DexMethodNode, Exception>();
    private List<Exception> fileExceptions = new ArrayList<Exception>();

    boolean hasException() {
        return this.exceptionMap.size() > 0 || this.fileExceptions.size() > 0;
    }

    public void handleFileException(Exception e) {
        super.handleFileException(e);
        this.fileExceptions.add(e);
    }

    public void handleMethodTranslateException(Method method, DexMethodNode methodNode, MethodVisitor mv, Exception e) {
        super.handleMethodTranslateException(method, methodNode, mv, e);
        this.exceptionMap.put(methodNode, e);
    }

    public static String getVersionString() {
        ArrayList<String> vs = new ArrayList<String>();
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-reader", DexFileReader.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-reader-api", Method.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-ir", ET.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "d2j-smali", Smali.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "d2j-base-cmd", BaseCmd.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-tools", Dex2jarCmd.class);
        BaksmaliBaseDexExceptionHandler.doAddVersion(vs, "dex-translator", Dex2jar.class);
        return ((Object)vs).toString();
    }

    private static void doAddVersion(List<String> vs, String pkg, Class<?> clz) {
        try {
            vs.add(String.valueOf(pkg) + "-" + clz.getPackage().getImplementationVersion());
        }
        catch (Exception exception) {}
    }

    public void dump(Path exFile, String[] orginalArgs) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(exFile, new OpenOption[0]));){
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)zos, StandardCharsets.UTF_8));
                zos.putNextEntry(new ZipEntry("summary.txt"));
                if (this.fileExceptions.size() > 0) {
                    writer.append(String.format("There are %d fails.", this.fileExceptions.size()));
                    writer.newLine();
                }
                if (this.exceptionMap.size() > 0) {
                    writer.append(String.format("There are %d methods fail to translate.", this.exceptionMap.size()));
                    writer.newLine();
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                writer.append(sdf.format(new Date()));
                writer.newLine();
                writer.append("version: ");
                writer.append(BaksmaliBaseDexExceptionHandler.getVersionString());
                writer.newLine();
                writer.append("cmdline: ");
                writer.append(Arrays.asList(orginalArgs).toString());
                writer.newLine();
                writer.append("env:");
                writer.newLine();
                Properties properties = System.getProperties();
                for (String key : properties.stringPropertyNames()) {
                    if (!key.startsWith("java.") || key.toLowerCase().contains("pass")) continue;
                    writer.append(key).append(": ").append(properties.getProperty(key));
                    writer.newLine();
                }
                PrintWriter p = new PrintWriter((Writer)writer, true);
                for (Exception ex : this.fileExceptions) {
                    ex.printStackTrace(p);
                }
                writer.flush();
                zos.closeEntry();
                int i = 0;
                BaksmaliDumper baksmaliDumper = new BaksmaliDumper();
                for (Map.Entry<DexMethodNode, Exception> e : this.exceptionMap.entrySet()) {
                    zos.putNextEntry(new ZipEntry("m-" + i++ + ".txt"));
                    writer.append(e.getKey().method.toString());
                    writer.newLine();
                    writer.flush();
                    e.getValue().printStackTrace(new PrintWriter((Writer)writer, true));
                    writer.newLine();
                    baksmaliDumper.baksmaliMethod(e.getKey(), writer);
                    writer.flush();
                    zos.closeEntry();
                }
                zos.setComment("This file is generated by dex2jar,\n Please report this file to http://code.google.com/p/dex2jar/issues/entry if possible.");
                zos.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

