/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.discovery.tools;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.discovery.DiscoveryException;
import org.apache.commons.discovery.tools.ClassUtils;

public class SPInterface {
    private final Class spi;
    private final String propertyName;
    private Class[] paramClasses = null;
    private Object[] params = null;

    public SPInterface(Class provider) {
        this(provider, provider.getName());
    }

    public SPInterface(Class spi, String propertyName) {
        this.spi = spi;
        this.propertyName = propertyName;
    }

    public SPInterface(Class provider, Class[] constructorParamClasses, Object[] constructorParams) {
        this(provider, provider.getName(), constructorParamClasses, constructorParams);
    }

    public SPInterface(Class spi, String propertyName, Class[] constructorParamClasses, Object[] constructorParams) {
        this.spi = spi;
        this.propertyName = propertyName;
        this.paramClasses = constructorParamClasses;
        this.params = constructorParams;
    }

    public String getSPName() {
        return this.spi.getName();
    }

    public Class getSPClass() {
        return this.spi;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object newInstance(Class impl) throws DiscoveryException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        this.verifyAncestory(impl);
        return ClassUtils.newInstance(impl, this.paramClasses, this.params);
    }

    public void verifyAncestory(Class impl) {
        ClassUtils.verifyAncestory(this.spi, impl);
    }
}

