/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.Storage;
import com.amazonaws.services.ec2.model.transform.S3StorageStaxUnmarshaller;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class StorageStaxUnmarshaller
implements Unmarshaller<Storage, StaxUnmarshallerContext> {
    private static StorageStaxUnmarshaller instance;

    public Storage unmarshall(StaxUnmarshallerContext context) throws Exception {
        Storage storage = new Storage();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return storage;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("S3", targetDepth)) continue;
                storage.setS3(S3StorageStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return storage;
    }

    public static StorageStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new StorageStaxUnmarshaller();
        }
        return instance;
    }
}

