/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.Options;

public class DisableVpcClassicLink
extends BaseCmd {
    public static final String[] VPC_DESC = new String[]{"The ID of the VPC."};

    public DisableVpcClassicLink(String[] args) {
        super("ec2disablecl", "ec2-disable-vpc-classic-link");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected Options getOptions() {
        return new Options();
    }

    @Override
    public String getOptionString() {
        return "VPC";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC that has EC2-Classic instances linked to it.");
    }

    @Override
    public void printOptions() {
        super.printOptions();
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.warnIfTooManyNonOptions();
        this.assertNonOptionSet("VPC");
        String vpcId = this.getNonOptions()[0];
        RequestResultPair result = jec2.disableVpcClassicLink(vpcId);
        out.output(System.out, (Boolean)result.getResponse());
        out.printRequestId(System.out, (RequestResult)result);
        return true;
    }

    public static void main(String[] args) {
        new DisableVpcClassicLink(args).invoke();
    }
}

