/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ncx;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.FeatureReport;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ncx.NCXHandler;
import com.adobe.epubcheck.opf.PublicationResourceChecker;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.xml.XMLParser;
import com.adobe.epubcheck.xml.XMLValidators;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;

public class NCXChecker
extends PublicationResourceChecker {
    private String ncxId = null;

    public NCXChecker(ValidationContext context) {
        super(context);
        Preconditions.checkState((boolean)"application/x-dtbncx+xml".equals(context.mimeType));
    }

    @Override
    protected boolean checkContent() {
        XMLParser ncxParser = new XMLParser(this.context);
        ncxParser.addValidator(XMLValidators.NCX_RNG.get());
        ncxParser.addValidator(XMLValidators.NCX_SCH.get());
        NCXHandler ncxHandler = new NCXHandler(this.context);
        ncxParser.addContentHandler(ncxHandler);
        ncxParser.process();
        this.ncxId = ncxHandler.getUid();
        if (this.ncxId != null && !this.ncxId.equals(this.ncxId.trim())) {
            this.report.message(MessageId.NCX_004, EPUBLocation.of(this.context), new Object[0]);
        }
        return true;
    }

    @Override
    protected boolean checkPublicationAfterContent() {
        String uid;
        if (this.context.featureReport.hasFeature(FeatureEnum.UNIQUE_IDENT) && (uid = (String)((FeatureReport.Feature)Iterables.get(this.context.featureReport.getFeature(FeatureEnum.UNIQUE_IDENT), (int)0)).getValue().get()) != null && this.ncxId != null && !uid.equals(this.ncxId.trim())) {
            this.report.message(MessageId.NCX_001, EPUBLocation.of(this.context), this.ncxId, uid);
        }
        return true;
    }
}

