/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.regex.OpNothing;
import net.sf.saxon.regex.OpRepeat;
import net.sf.saxon.regex.Operation;
import net.sf.saxon.regex.REFlags;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.REProgram;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntStepIterator;

public class OpGreedyFixed
extends OpRepeat {
    private final int len;

    OpGreedyFixed(Operation op, int min, int max, int len) {
        super(op, min, max, true);
        this.len = len;
    }

    @Override
    public int getMatchLength() {
        return this.min == this.max ? this.min * this.len : -1;
    }

    @Override
    public int matchesEmptyString() {
        if (this.min == 0) {
            return 7;
        }
        return this.op.matchesEmptyString();
    }

    @Override
    public Operation optimize(REProgram program, REFlags flags) {
        if (this.max == 0) {
            return new OpNothing();
        }
        if (this.op.getMatchLength() == 0) {
            return this.op;
        }
        this.op = this.op.optimize(program, flags);
        return this;
    }

    @Override
    public IntIterator iterateMatches(REMatcher matcher, int position) {
        int p;
        int guard = matcher.search.length32();
        if (this.max < Integer.MAX_VALUE) {
            guard = Math.min(guard, position + this.len * this.max);
        }
        if (position >= guard && this.min > 0) {
            return EmptyIntIterator.getInstance();
        }
        int matches = 0;
        for (p = position; p <= guard; p += this.len) {
            IntIterator it = this.op.iterateMatches(matcher, p);
            boolean matched = false;
            if (it.hasNext()) {
                matched = true;
                it.next();
            }
            if (!matched) break;
            if (++matches != this.max) continue;
            break;
        }
        if (matches < this.min) {
            return EmptyIntIterator.getInstance();
        }
        return new IntStepIterator(p, -this.len, position + this.len * this.min);
    }
}

