/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.duo;

import com.duosecurity.Client;
import com.duosecurity.exception.DuoException;
import com.duosecurity.model.Token;
import com.google.inject.Inject;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.duo.DuoAuthenticationSession;
import org.apache.guacamole.auth.duo.DuoAuthenticationSessionManager;
import org.apache.guacamole.auth.duo.conf.ConfigurationService;
import org.apache.guacamole.form.RedirectField;
import org.apache.guacamole.language.TranslatableGuacamoleInsufficientCredentialsException;
import org.apache.guacamole.language.TranslatableMessage;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.properties.IPAddressListProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserVerificationService {
    private static final Logger logger = LoggerFactory.getLogger(UserVerificationService.class);
    public static final String DUO_CODE_PARAMETER_NAME = "duo_code";
    public static final String DUO_STATE_PARAMETER_NAME = "state";
    private static final String DUO_TOKEN_SUCCESS_VALUE = "allow";
    @Inject
    private DuoAuthenticationSessionManager sessionManager;
    @Inject
    private ConfigurationService confService;

    public void verifyAuthenticatedUser(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        URI duoAuthUrl;
        String duoAuthUrlString;
        String duoState;
        Client duoClient;
        String username;
        Credentials credentials;
        block16: {
            boolean enforceHost;
            credentials = authenticatedUser.getCredentials();
            IPAddress clientAddr = new IPAddressString(credentials.getRemoteAddress()).getAddress();
            username = authenticatedUser.getIdentifier();
            if (username == null || username.equals("")) {
                return;
            }
            List<IPAddress> bypassAddresses = this.confService.getBypassHosts();
            List<IPAddress> enforceAddresses = this.confService.getEnforceHosts();
            boolean bl = enforceHost = !IPAddressListProperty.addressListContains(bypassAddresses, (IPAddress)clientAddr);
            if (!enforceAddresses.isEmpty()) {
                enforceHost = clientAddr == null || !clientAddr.isIPAddress() ? true : IPAddressListProperty.addressListContains(enforceAddresses, (IPAddress)clientAddr);
            }
            if (!enforceHost) {
                return;
            }
            try {
                duoClient = new Client.Builder(this.confService.getClientId(), this.confService.getClientSecret(), this.confService.getAPIHostname(), this.confService.getRedirectUri().toString()).build();
            }
            catch (DuoException e) {
                throw new GuacamoleServerException("Client for communicating with the Duo authentication service could not be created.", (Throwable)e);
            }
            try {
                duoClient.healthCheck();
            }
            catch (DuoException e) {
                throw new GuacamoleServerException("Duo authentication service is not currently available (failed health check).", (Throwable)e);
            }
            String duoCode = credentials.getParameter(DUO_CODE_PARAMETER_NAME);
            duoState = credentials.getParameter(DUO_STATE_PARAMETER_NAME);
            if (duoCode != null && duoState != null) {
                try {
                    Token token = duoClient.exchangeAuthorizationCodeFor2FAResult(duoCode, username);
                    if (token == null) {
                        logger.warn("Duo did not return an authentication result at all for the authentication attempt by user \"{}\". This is unexpected behavior and may be a bug in the Duo service or the Duo SDK. Guacamole will attempt to automatically work around the issue by making a fresh Duo authentication request.", (Object)username);
                        break block16;
                    }
                    if (token.getAuth_result() == null || !DUO_TOKEN_SUCCESS_VALUE.equals(token.getAuth_result().getStatus())) {
                        logger.warn("Duo did not return an explicitly successful authentication result for the authentication attempt by user \"{}\". The user will now be redirected back to the Duo service to reattemptauthentication.", (Object)username);
                        break block16;
                    }
                    return;
                }
                catch (DuoException e) {
                    logger.debug("The Duo client failed internally while attempting to validate the identity of user \"{}\". This is commonly caused by stale query parameters from an older Duo request remaining present in the Guacamole URL. The user will now be redirected back to the Duo service to reattempt authentication.", (Throwable)e);
                }
            }
        }
        duoState = duoClient.generateState();
        long expiresAfter = TimeUnit.MINUTES.toMillis(this.confService.getAuthenticationTimeout());
        this.sessionManager.defer(new DuoAuthenticationSession(credentials, expiresAfter), duoState);
        try {
            duoAuthUrlString = duoClient.createAuthUrl(username, duoState);
        }
        catch (DuoException e) {
            throw new GuacamoleServerException("Duo client failed to generate the authentication URL necessary to redirect the authenticating user to the Duo service.", (Throwable)e);
        }
        try {
            duoAuthUrl = new URI(duoAuthUrlString);
        }
        catch (URISyntaxException e) {
            throw new GuacamoleServerException("Authentication URL generated by the Duo client is not actually a valid URL and cannot be used to redirect the authenticating user to the Duo service.", (Throwable)e);
        }
        throw new TranslatableGuacamoleInsufficientCredentialsException("Verification using Duo is required before authentication can continue.", "LOGIN.INFO_DUO_AUTH_REQUIRED", new CredentialsInfo(Collections.singletonList(new RedirectField(DUO_CODE_PARAMETER_NAME, duoAuthUrl, new TranslatableMessage("LOGIN.INFO_DUO_REDIRECT_PENDING")))));
    }
}

