/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.json.user;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.json.connection.ConnectionService;
import org.apache.guacamole.auth.json.user.UserData;
import org.apache.guacamole.net.GuacamoleTunnel;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.protocol.GuacamoleClientInformation;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class UserDataConnection
implements Connection {
    @Inject
    private ConnectionService connectionService;
    private String identifier;
    private UserData data;
    private UserData.Connection connection;

    public UserDataConnection init(UserData data, String identifier, UserData.Connection connection) {
        this.identifier = identifier;
        this.data = data;
        this.connection = connection;
        return this;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        throw new UnsupportedOperationException("UserDataConnection is immutable.");
    }

    public String getName() {
        return this.identifier;
    }

    public void setName(String name) {
        throw new UnsupportedOperationException("UserDataConnection is immutable.");
    }

    public String getParentIdentifier() {
        return "ROOT";
    }

    public void setParentIdentifier(String parentIdentifier) {
        throw new UnsupportedOperationException("UserDataConnection is immutable.");
    }

    public GuacamoleConfiguration getConfiguration() {
        GuacamoleConfiguration config = this.connectionService.getConfiguration(this.connection);
        if (config == null) {
            config = new GuacamoleConfiguration();
        }
        return config;
    }

    public void setConfiguration(GuacamoleConfiguration config) {
        throw new UnsupportedOperationException("UserDataConnection is immutable.");
    }

    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    public void setAttributes(Map<String, String> attributes) {
        throw new UnsupportedOperationException("UserDataConnection is immutable.");
    }

    public Date getLastActive() {
        return null;
    }

    public Set<String> getSharingProfileIdentifiers() throws GuacamoleException {
        return Collections.emptySet();
    }

    public int getActiveConnections() {
        return 0;
    }

    public GuacamoleTunnel connect(GuacamoleClientInformation info, Map<String, String> tokens) throws GuacamoleException {
        if (this.connection.isSingleUse() && this.data.removeConnection(this.getIdentifier()) == null) {
            throw new GuacamoleSecurityException("Permission denied");
        }
        return this.connectionService.connect(this.connection, info, tokens);
    }
}

