/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.udp;

import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.client.datagram.I2PDatagramMaker;
import net.i2p.data.Destination;
import net.i2p.i2ptunnel.udp.Sink;

public class I2PSink
implements Sink {
    protected final boolean raw;
    protected final I2PSession sess;
    protected final Destination dest;
    protected final I2PDatagramMaker maker;
    protected final int toPort;

    public I2PSink(I2PSession sess, Destination dest) {
        this(sess, dest, false);
    }

    public I2PSink(I2PSession sess, Destination dest, boolean raw) {
        this(sess, dest, raw, 0);
    }

    public I2PSink(I2PSession sess, Destination dest, boolean raw, int toPort) {
        this.sess = sess;
        this.dest = dest;
        this.raw = raw;
        this.toPort = toPort;
        if (raw) {
            this.maker = null;
        } else {
            this.maker = new I2PDatagramMaker();
            this.maker.setI2PDatagramMaker(this.sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(Destination src, int fromPort, int ign_toPort, byte[] data) {
        byte[] payload;
        if (!this.raw) {
            I2PDatagramMaker i2PDatagramMaker = this.maker;
            synchronized (i2PDatagramMaker) {
                payload = this.maker.makeI2PDatagram(data);
            }
        } else {
            payload = data;
        }
        try {
            this.sess.sendMessage(this.dest, payload, this.raw ? 18 : 17, fromPort, this.toPort);
        }
        catch (I2PSessionException ise) {
            throw new RuntimeException("failed to send data", ise);
        }
    }
}

