/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.ntcp.EstablishState;
import net.i2p.router.transport.ntcp.EventPumper;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;

class Reader {
    private final RouterContext _context;
    private final Log _log;
    private final Set<NTCPConnection> _pendingConnections;
    private final Set<NTCPConnection> _liveReads;
    private final Set<NTCPConnection> _readAfterLive;
    private final List<Runner> _runners;

    public Reader(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._pendingConnections = new LinkedHashSet<NTCPConnection>(16);
        this._runners = new ArrayList<Runner>(8);
        this._liveReads = new HashSet<NTCPConnection>(8);
        this._readAfterLive = new HashSet<NTCPConnection>(8);
    }

    public synchronized void startReading(int numReaders) {
        for (int i = 1; i <= numReaders; ++i) {
            Runner r = new Runner();
            I2PThread t = new I2PThread(r, "NTCP reader " + i + '/' + numReaders, true);
            this._runners.add(r);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopReading() {
        while (!this._runners.isEmpty()) {
            Runner r = this._runners.remove(0);
            r.stop();
        }
        Set<NTCPConnection> set = this._pendingConnections;
        synchronized (set) {
            this._readAfterLive.clear();
            this._pendingConnections.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wantsRead(NTCPConnection con) {
        boolean already = false;
        Set<NTCPConnection> set = this._pendingConnections;
        synchronized (set) {
            if (this._liveReads.contains(con)) {
                this._readAfterLive.add(con);
                already = true;
            } else {
                this._pendingConnections.add(con);
                this._pendingConnections.notify();
            }
        }
        if (this._log.shouldLog(10)) {
            this._log.debug("wantsRead: " + con + " already live? " + already);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionClosed(NTCPConnection con) {
        Set<NTCPConnection> set = this._pendingConnections;
        synchronized (set) {
            this._readAfterLive.remove(con);
            this._pendingConnections.remove(con);
            this._pendingConnections.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRead(NTCPConnection con) {
        ByteBuffer buf;
        block9: {
            EstablishState est;
            buf = null;
            do {
                NTCPConnection nTCPConnection = con;
                synchronized (nTCPConnection) {
                    if (con.isClosed()) {
                        return;
                    }
                    if (con.isEstablished()) {
                        break block9;
                    }
                }
                buf = con.getNextReadBuf();
                if (buf == null) {
                    return;
                }
                est = con.getEstablishState();
                if (est.isComplete()) {
                    this._log.error("establishment state [" + est + "] is complete, yet the connection isn't established? " + con.isEstablished() + " (inbound? " + con.isInbound() + " " + con + ")");
                    EventPumper.releaseBuf(buf);
                    break block9;
                }
                est.receive(buf);
                EventPumper.releaseBuf(buf);
            } while (!est.isCorrupt());
            con.close();
            return;
        }
        while (!con.isClosed() && (buf = con.getNextReadBuf()) != null) {
            con.recvEncryptedI2NP(buf);
            EventPumper.releaseBuf(buf);
        }
    }

    private class Runner
    implements Runnable {
        private volatile boolean _stop;

        public void stop() {
            this._stop = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (Reader.this._log.shouldLog(20)) {
                Reader.this._log.info("Starting reader");
            }
            NTCPConnection con = null;
            while (!this._stop) {
                try {
                    Set set = Reader.this._pendingConnections;
                    synchronized (set) {
                        boolean keepReading;
                        boolean bl = keepReading = con != null && Reader.this._readAfterLive.remove(con);
                        if (!keepReading) {
                            if (con != null) {
                                Reader.this._liveReads.remove(con);
                                con = null;
                            }
                            if (Reader.this._pendingConnections.isEmpty()) {
                                Reader.this._pendingConnections.wait();
                            } else {
                                Iterator iter = Reader.this._pendingConnections.iterator();
                                con = (NTCPConnection)iter.next();
                                iter.remove();
                                Reader.this._liveReads.add(con);
                            }
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this._stop || con == null) continue;
                if (Reader.this._log.shouldLog(10)) {
                    Reader.this._log.debug("begin read for " + con);
                }
                try {
                    Reader.this.processRead(con);
                }
                catch (IllegalStateException ise) {
                    if (Reader.this._log.shouldWarn()) {
                        Reader.this._log.warn("Error in the ntcp reader", ise);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (Reader.this._log.shouldWarn()) {
                        Reader.this._log.warn("Error in the ntcp reader", iae);
                    }
                }
                catch (RuntimeException re) {
                    Reader.this._log.error("Error in the ntcp reader", re);
                }
                if (!Reader.this._log.shouldLog(10)) continue;
                Reader.this._log.debug("end read for " + con);
            }
            if (Reader.this._log.shouldLog(20)) {
                Reader.this._log.info("Stopping reader");
            }
        }
    }
}

