/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.mappingio.tree;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Locale;
import net.fabricmc.mappingio.tree.MappingTree;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public final class ClassAnalysisDescCompleter {
    public static void process(Path path, String namespace, MappingTree mappingTree) throws IOException {
        AnalyzingVisitor visitor = new AnalyzingVisitor(namespace, mappingTree);
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, new DirVisitor(visitor));
        } else {
            ClassAnalysisDescCompleter.processFile(path, null, visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer processFile(Path file, ByteBuffer buffer, AnalyzingVisitor visitor) throws IOException {
        String fileName = file.getFileName().toString().toLowerCase(Locale.ENGLISH);
        if (fileName.endsWith(".jar")) {
            URI uri = file.toUri();
            try {
                uri = new URI("jar:".concat(uri.getScheme()), uri.getHost(), uri.getPath(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            FileSystem fs = null;
            boolean closeFs = false;
            try {
                try {
                    fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    closeFs = true;
                }
                catch (FileSystemAlreadyExistsException e) {
                    fs = FileSystems.getFileSystem(uri);
                }
                DirVisitor dirVisitor = new DirVisitor(visitor);
                for (Path rootDir : fs.getRootDirectories()) {
                    Files.walkFileTree(rootDir, dirVisitor);
                }
                buffer = dirVisitor.buffer;
            }
            finally {
                if (closeFs) {
                    fs.close();
                }
            }
        }
        if (fileName.endsWith(".class")) {
            try (SeekableByteChannel channel = Files.newByteChannel(file, new OpenOption[0]);){
                if (buffer == null) {
                    buffer = ByteBuffer.allocate((int)Math.min(channel.size() + 1L, 100000000L));
                }
                while (channel.read(buffer) >= 0) {
                    if (buffer.hasRemaining()) continue;
                    ByteBuffer newBuffer = ByteBuffer.allocate(buffer.capacity() * 2);
                    buffer.flip();
                    newBuffer.put(buffer);
                    buffer = newBuffer;
                }
            }
            buffer.flip();
            ClassAnalysisDescCompleter.processClass(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining(), visitor);
            buffer.clear();
        }
        return buffer;
    }

    public static void processClass(byte[] classBytes, String namespace, MappingTree mappingTree) {
        ClassAnalysisDescCompleter.processClass(classBytes, 0, classBytes.length, new AnalyzingVisitor(namespace, mappingTree));
    }

    public static void processClass(byte[] classBytes, int offset, int length, String namespace, MappingTree mappingTree) {
        ClassAnalysisDescCompleter.processClass(classBytes, offset, length, new AnalyzingVisitor(namespace, mappingTree));
    }

    private static void processClass(byte[] classBytes, int offset, int length, AnalyzingVisitor visitor) {
        ClassReader reader = new ClassReader(classBytes, offset, length);
        reader.accept((ClassVisitor)visitor, 3);
    }

    private static final class AnalyzingVisitor
    extends ClassVisitor {
        private final int namespace;
        private final MappingTree mappingTree;
        private MappingTree.ClassMapping cls;

        AnalyzingVisitor(String namespace, MappingTree mappingTree) {
            super(Integer.getInteger("mappingIo.asmApiVersion", 589824).intValue());
            int n = this.namespace = namespace != null ? mappingTree.getNamespaceId(namespace) : -1;
            if (this.namespace == -2) {
                throw new IllegalArgumentException("Unknown namespace: " + namespace);
            }
            this.mappingTree = mappingTree;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.cls = this.mappingTree.getClass(name, this.namespace);
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            MappingTree.FieldMapping field;
            if (this.cls != null && (field = this.cls.getField(name, descriptor, this.namespace)) != null && field.getSrcDesc() == null) {
                field.setSrcDesc(this.mappingTree.mapDesc(descriptor, this.namespace, -1));
            }
            return null;
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            MappingTree.MethodMapping method;
            if (this.cls != null && (method = this.cls.getMethod(name, descriptor, this.namespace)) != null && method.getSrcDesc() == null) {
                method.setSrcDesc(this.mappingTree.mapDesc(descriptor, this.namespace, -1));
            }
            return null;
        }
    }

    private static final class DirVisitor
    extends SimpleFileVisitor<Path> {
        private final AnalyzingVisitor visitor;
        ByteBuffer buffer;

        DirVisitor(AnalyzingVisitor visitor) {
            this.visitor = visitor;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.buffer = ClassAnalysisDescCompleter.processFile(file, this.buffer, this.visitor);
            return FileVisitResult.CONTINUE;
        }
    }
}

