/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public abstract class GenericArray
extends VMObject {
    private static long sizeOfArray;
    private static CIntField lengthField;
    private long dataFieldOffset;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("Array<int>");
        lengthField = new CIntField(type.getCIntegerField("_length"), 0L);
    }

    public GenericArray(Address addr, long dataOffset) {
        super(addr);
        this.dataFieldOffset = dataOffset;
    }

    public int length() {
        return (int)lengthField.getValue(this);
    }

    public int getLength() {
        return this.length();
    }

    protected long getIntegerAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new ArrayIndexOutOfBoundsException(index + " " + this.length());
        }
        Type elemType = this.getElemType();
        if (!this.getElemType().isCIntegerType()) {
            throw new RuntimeException("elemType must be of CInteger type");
        }
        Address data = this.getAddress().addOffsetTo(this.dataFieldOffset);
        long elemSize = elemType.getSize();
        return data.getCIntegerAt((long)index * elemSize, elemSize, false);
    }

    protected Address getAddressAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Type elemType = this.getElemType();
        if (this.getElemType().isCIntegerType()) {
            throw new RuntimeException("elemType must not be of CInteger type");
        }
        Address data = this.getAddress().addOffsetTo(this.dataFieldOffset);
        long elemSize = elemType.getSize();
        return data.getAddressAt((long)index * elemSize);
    }

    private long byteSizeof(int length) {
        return sizeOfArray + (long)length * this.getElemType().getSize();
    }

    public long getSize() {
        return VM.getVM().alignUp(this.byteSizeof(this.length()), VM.getVM().getBytesPerWord()) / (long)VM.getVM().getBytesPerWord();
    }

    public abstract Type getElemType();

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                GenericArray.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

