/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import json.ext.Generator;
import json.ext.RuntimeInfo;
import json.ext.Utils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

class GeneratorMethods {
    GeneratorMethods() {
    }

    static void populate(RuntimeInfo runtimeInfo, RubyModule rubyModule) {
        GeneratorMethods.defineMethods(rubyModule, "Array", RbArray.class);
        GeneratorMethods.defineMethods(rubyModule, "FalseClass", RbFalse.class);
        GeneratorMethods.defineMethods(rubyModule, "Float", RbFloat.class);
        GeneratorMethods.defineMethods(rubyModule, "Hash", RbHash.class);
        GeneratorMethods.defineMethods(rubyModule, "Integer", RbInteger.class);
        GeneratorMethods.defineMethods(rubyModule, "NilClass", RbNil.class);
        GeneratorMethods.defineMethods(rubyModule, "Object", RbObject.class);
        GeneratorMethods.defineMethods(rubyModule, "String", RbString.class);
        GeneratorMethods.defineMethods(rubyModule, "TrueClass", RbTrue.class);
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("String").defineModuleUnder("Extend");
        rubyModule2.defineAnnotatedMethods(StringExtend.class);
    }

    private static void defineMethods(RubyModule rubyModule, String string, Class<?> clazz) {
        RubyModule rubyModule2 = rubyModule.defineModuleUnder(string);
        rubyModule2.defineAnnotatedMethods(clazz);
    }

    public static class RbObject {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return RbString.to_json(threadContext, (IRubyObject)iRubyObject.asString());
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return RbString.to_json(threadContext, (IRubyObject)iRubyObject.asString(), iRubyObject2);
        }
    }

    public static class RbNil {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, iRubyObject, Generator.NIL_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, iRubyObject, Generator.NIL_HANDLER, iRubyObject2);
        }
    }

    public static class RbFalse {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.FALSE_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.FALSE_HANDLER, iRubyObject2);
        }
    }

    public static class RbTrue {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.TRUE_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.TRUE_HANDLER, iRubyObject2);
        }
    }

    public static class StringExtend {
        @JRubyMethod
        public static IRubyObject json_create(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Ruby ruby = threadContext.runtime;
            RubyHash rubyHash = iRubyObject2.convertToHash();
            IRubyObject iRubyObject3 = rubyHash.fastARef((IRubyObject)ruby.newString("raw"));
            if (iRubyObject3 == null) {
                throw ruby.newArgumentError("\"raw\" value not defined for encoded String");
            }
            RubyArray rubyArray = Utils.ensureArray(iRubyObject3);
            byte[] byArray = new byte[rubyArray.getLength()];
            int n = rubyArray.getLength();
            for (int i = 0; i < n; ++i) {
                IRubyObject iRubyObject4 = rubyArray.eltInternal(i);
                if (!(iRubyObject4 instanceof RubyFixnum)) {
                    throw ruby.newTypeError(iRubyObject4, ruby.getFixnum());
                }
                byArray[i] = (byte)RubyNumeric.fix2long((IRubyObject)iRubyObject4);
            }
            return ruby.newString(new ByteList(byArray, false));
        }
    }

    public static class RbString {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyString)iRubyObject, Generator.STRING_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyString)iRubyObject, Generator.STRING_HANDLER, iRubyObject2);
        }

        @JRubyMethod
        public static IRubyObject to_json_raw(ThreadContext threadContext, IRubyObject iRubyObject) {
            RubyHash rubyHash = RbString.toJsonRawObject(threadContext, Utils.ensureString(iRubyObject));
            return Generator.generateJson(threadContext, rubyHash, Generator.HASH_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json_raw(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            RubyHash rubyHash = RbString.toJsonRawObject(threadContext, Utils.ensureString(iRubyObject));
            return Generator.generateJson(threadContext, rubyHash, Generator.HASH_HANDLER, iRubyObject2);
        }

        @JRubyMethod
        public static IRubyObject to_json_raw_object(ThreadContext threadContext, IRubyObject iRubyObject) {
            return RbString.toJsonRawObject(threadContext, Utils.ensureString(iRubyObject));
        }

        private static RubyHash toJsonRawObject(ThreadContext threadContext, RubyString rubyString) {
            Ruby ruby = threadContext.runtime;
            RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
            IRubyObject iRubyObject = ((RubyModule)RuntimeInfo.forRuntime((Ruby)ruby).jsonModule.get()).callMethod(threadContext, "create_id");
            rubyHash.op_aset(threadContext, iRubyObject, (IRubyObject)rubyString.getMetaClass().to_s());
            ByteList byteList = rubyString.getByteList();
            byte[] byArray = byteList.unsafeBytes();
            RubyArray rubyArray = ruby.newArray(byteList.length());
            int n = byteList.begin() + byteList.length();
            for (int i = byteList.begin(); i < n; ++i) {
                rubyArray.store((long)i, (IRubyObject)ruby.newFixnum(byArray[i] & 0xFF));
            }
            rubyHash.op_aset(threadContext, (IRubyObject)ruby.newString("raw"), (IRubyObject)rubyArray);
            return rubyHash;
        }

        @JRubyMethod(module=true)
        public static IRubyObject included(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(threadContext.runtime);
            return iRubyObject2.callMethod(threadContext, "extend", ((RubyModule)iRubyObject).getConstant("Extend"));
        }
    }

    public static class RbFloat {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyFloat)iRubyObject, Generator.FLOAT_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyFloat)iRubyObject, Generator.FLOAT_HANDLER, iRubyObject2);
        }
    }

    public static class RbInteger {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, iRubyObject);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, iRubyObject, iRubyObject2);
        }
    }

    public static class RbArray {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyArray)iRubyObject, Generator.ARRAY_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyArray)iRubyObject, Generator.ARRAY_HANDLER, iRubyObject2);
        }
    }

    public static class RbHash {
        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject) {
            return Generator.generateJson(threadContext, (RubyHash)iRubyObject, Generator.HASH_HANDLER);
        }

        @JRubyMethod
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return Generator.generateJson(threadContext, (RubyHash)iRubyObject, Generator.HASH_HANDLER, iRubyObject2);
        }
    }
}

