/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class BCSSLParameters {
    private String[] cipherSuites;
    private String[] protocols;
    private boolean wantClientAuth;
    private boolean needClientAuth;
    private String endpointIdentificationAlgorithm;
    private BCAlgorithmConstraints algorithmConstraints;
    private List<BCSNIServerName> serverNames;
    private List<BCSNIMatcher> sniMatchers;
    private boolean useCipherSuitesOrder;
    private boolean enableRetransmissions = true;
    private int maximumPacketSize = 0;
    private String[] applicationProtocols = TlsUtils.EMPTY_STRINGS;
    private String[] signatureSchemes = null;
    private String[] signatureSchemesCert = null;
    private String[] namedGroups = null;

    private static <T> List<T> copyList(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(collection));
    }

    public BCSSLParameters() {
    }

    public BCSSLParameters(String[] stringArray) {
        this.setCipherSuites(stringArray);
    }

    public BCSSLParameters(String[] stringArray, String[] stringArray2) {
        this.setCipherSuites(stringArray);
        this.setProtocols(stringArray2);
    }

    public String[] getCipherSuites() {
        return TlsUtils.clone(this.cipherSuites);
    }

    public void setCipherSuites(String[] stringArray) {
        this.cipherSuites = TlsUtils.clone(stringArray);
    }

    public String[] getProtocols() {
        return TlsUtils.clone(this.protocols);
    }

    public void setProtocols(String[] stringArray) {
        this.protocols = TlsUtils.clone(stringArray);
    }

    public boolean getWantClientAuth() {
        return this.wantClientAuth;
    }

    public void setWantClientAuth(boolean bl) {
        this.wantClientAuth = bl;
        this.needClientAuth = false;
    }

    public boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(boolean bl) {
        this.needClientAuth = bl;
        this.wantClientAuth = false;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }

    public void setEndpointIdentificationAlgorithm(String string) {
        this.endpointIdentificationAlgorithm = string;
    }

    public BCAlgorithmConstraints getAlgorithmConstraints() {
        return this.algorithmConstraints;
    }

    public void setAlgorithmConstraints(BCAlgorithmConstraints bCAlgorithmConstraints) {
        this.algorithmConstraints = bCAlgorithmConstraints;
    }

    public List<BCSNIServerName> getServerNames() {
        return BCSSLParameters.copyList(this.serverNames);
    }

    public void setServerNames(List<BCSNIServerName> list) {
        if (list == null) {
            this.serverNames = null;
        } else {
            List<BCSNIServerName> list2 = BCSSLParameters.copyList(list);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (BCSNIServerName bCSNIServerName : list2) {
                int n = bCSNIServerName.getType();
                if (hashSet.add(n)) continue;
                throw new IllegalArgumentException("Found duplicate SNI server name entry of type " + n);
            }
            this.serverNames = list2;
        }
    }

    public Collection<BCSNIMatcher> getSNIMatchers() {
        return BCSSLParameters.copyList(this.sniMatchers);
    }

    public void setSNIMatchers(Collection<BCSNIMatcher> collection) {
        if (collection == null) {
            this.sniMatchers = null;
        } else {
            List<BCSNIMatcher> list = BCSSLParameters.copyList(collection);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (BCSNIMatcher bCSNIMatcher : list) {
                int n = bCSNIMatcher.getType();
                if (hashSet.add(n)) continue;
                throw new IllegalArgumentException("Found duplicate SNI matcher entry of type " + n);
            }
            this.sniMatchers = list;
        }
    }

    public boolean getUseCipherSuitesOrder() {
        return this.useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean bl) {
        this.useCipherSuitesOrder = bl;
    }

    public boolean getEnableRetransmissions() {
        return this.enableRetransmissions;
    }

    public void setEnableRetransmissions(boolean bl) {
        this.enableRetransmissions = bl;
    }

    public int getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public void setMaximumPacketSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("The maximum packet size cannot be negative");
        }
        this.maximumPacketSize = n;
    }

    public String[] getApplicationProtocols() {
        return TlsUtils.clone(this.applicationProtocols);
    }

    public void setApplicationProtocols(String[] stringArray) {
        String[] stringArray2;
        if (null == stringArray) {
            throw new NullPointerException("'applicationProtocols' cannot be null");
        }
        for (String string : stringArray2 = TlsUtils.clone(stringArray)) {
            if (!TlsUtils.isNullOrEmpty(string)) continue;
            throw new IllegalArgumentException("'applicationProtocols' entries cannot be null or empty strings");
        }
        this.applicationProtocols = stringArray2;
    }

    public String[] getSignatureSchemes() {
        return TlsUtils.clone(this.signatureSchemes);
    }

    public void setSignatureSchemes(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            for (String string : stringArray2 = TlsUtils.clone(stringArray)) {
                if (!TlsUtils.isNullOrEmpty(string)) continue;
                throw new IllegalArgumentException("'signatureSchemes' entries cannot be null or empty strings");
            }
        }
        this.signatureSchemes = stringArray2;
    }

    public String[] getSignatureSchemesCert() {
        return TlsUtils.clone(this.signatureSchemesCert);
    }

    public void setSignatureSchemesCert(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            for (String string : stringArray2 = TlsUtils.clone(stringArray)) {
                if (!TlsUtils.isNullOrEmpty(string)) continue;
                throw new IllegalArgumentException("'signatureSchemesCert' entries cannot be null or empty strings");
            }
        }
        this.signatureSchemesCert = stringArray2;
    }

    public String[] getNamedGroups() {
        return TlsUtils.clone(this.namedGroups);
    }

    public void setNamedGroups(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = TlsUtils.clone(stringArray);
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : stringArray2) {
                if (TlsUtils.isNullOrEmpty(string)) {
                    throw new IllegalArgumentException("'namedGroups' entries cannot be null or empty strings");
                }
                if (hashSet.add(string)) continue;
                throw new IllegalArgumentException("'namedGroups' contains duplicate entry: " + string);
            }
        }
        this.namedGroups = stringArray2;
    }
}

