/*
 * Decompiled with CFR 0.152.
 */
package jnr.ffi.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import jnr.ffi.CallingConvention;
import jnr.ffi.annotations.IgnoreError;
import jnr.ffi.annotations.SaveError;

public final class NativeFunction {
    private final Method method;
    private final Collection<Annotation> annotations;
    private final boolean saveError;
    private final boolean ignoreError;
    private final CallingConvention callingConvention;

    public NativeFunction(Method method2, CallingConvention callingConvention) {
        this.method = method2;
        this.annotations = Collections.unmodifiableCollection(Arrays.asList(method2.getAnnotations()));
        this.saveError = NativeFunction.hasSaveError(method2);
        this.ignoreError = NativeFunction.hasIgnoreError(method2);
        this.callingConvention = callingConvention;
    }

    public Collection<Annotation> annotations() {
        return this.annotations;
    }

    public CallingConvention convention() {
        return this.callingConvention;
    }

    public String name() {
        return this.method.getName();
    }

    public boolean isErrnoRequired() {
        return !this.ignoreError || this.saveError;
    }

    public boolean hasSaveError() {
        return this.saveError;
    }

    public boolean hasIgnoreError() {
        return this.ignoreError;
    }

    public Method getMethod() {
        return this.method;
    }

    public static boolean hasSaveError(Method method2) {
        return method2.getAnnotation(SaveError.class) != null;
    }

    public static boolean hasIgnoreError(Method method2) {
        return method2.getAnnotation(IgnoreError.class) != null;
    }
}

