/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.jsr223;

import java.io.Reader;
import java.util.Objects;
import java.util.function.Supplier;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.jruby.Ruby;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.embed.jsr223.JRubyCompiledScript;
import org.jruby.embed.jsr223.JRubyContext;
import org.jruby.embed.jsr223.JRubyEngineFactory;
import org.jruby.embed.jsr223.Utils;
import org.jruby.exceptions.NoMethodError;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.backtrace.RubyStackTraceElement;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyEngine
implements AutoCloseable,
Compilable,
Invocable,
ScriptEngine {
    final ScriptingContainer container;
    private final JRubyEngineFactory factory;
    private ScriptContext context;

    JRubyEngine(ScriptingContainer container, JRubyEngineFactory factory) {
        this.container = container;
        this.factory = factory;
        this.context = new JRubyContext(container);
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        Objects.requireNonNull(script, "script");
        try {
            return new JRubyCompiledScript(this.container, this, script);
        }
        catch (RaiseException e) {
            throw JRubyEngine.wrapRaiseException(e);
        }
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        Objects.requireNonNull(reader, "reader");
        try {
            return new JRubyCompiledScript(this.container, this, reader);
        }
        catch (RaiseException e) {
            throw JRubyEngine.wrapRaiseException(e);
        }
    }

    static Object doEval(ScriptingContainer container, ScriptContext context, Supplier<EmbedEvalUnit> unit) throws ScriptException {
        if (Utils.isClearVariablesOn(context)) {
            container.clear();
        }
        Utils.preEval(container, context);
        try {
            IRubyObject ret = unit.get().run();
            Object t = JavaEmbedUtils.rubyToJava(ret);
            return t;
        }
        catch (RaiseException e) {
            throw JRubyEngine.wrapRaiseException(e);
        }
        catch (Exception e) {
            throw JRubyEngine.wrapException(e);
        }
        finally {
            Utils.postEval(container, context);
            if (Utils.isTerminationOn(context)) {
                container.terminate();
            }
        }
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        Objects.requireNonNull(script, "script");
        Objects.requireNonNull(context, "context");
        this.container.setScriptFilename(Utils.getFilename(context));
        return JRubyEngine.doEval(this.container, context, () -> this.container.parse(script, Utils.getLineNumber(context)));
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        Objects.requireNonNull(reader, "reader");
        Objects.requireNonNull(context, "context");
        String filename2 = Utils.getFilename(context);
        return JRubyEngine.doEval(this.container, context, () -> this.container.parse(reader, filename2, Utils.getLineNumber(context)));
    }

    @Override
    public Object eval(String script, Bindings bindings) throws ScriptException {
        Objects.requireNonNull(script, "script");
        Objects.requireNonNull(bindings, "bindings");
        ScriptContext context = this.getScriptContext(bindings);
        return this.eval(script, context);
    }

    @Override
    public Object eval(Reader reader, Bindings bindings) throws ScriptException {
        Objects.requireNonNull(reader, "reader");
        Objects.requireNonNull(bindings, "bindings");
        ScriptContext context = this.getScriptContext(bindings);
        return this.eval(reader, context);
    }

    @Override
    public Object eval(String script) throws ScriptException {
        return this.eval(script, this.context);
    }

    @Override
    public Object eval(Reader reader) throws ScriptException {
        return this.eval(reader, this.context);
    }

    protected ScriptContext getScriptContext(Bindings bindings) {
        if (bindings == null) {
            return this.context;
        }
        SimpleScriptContext newContext = new SimpleScriptContext();
        newContext.setBindings(bindings, 100);
        Bindings global = this.getBindings(200);
        if (global != null) {
            newContext.setBindings(global, 200);
        }
        newContext.setReader(this.context.getReader());
        newContext.setWriter(this.context.getWriter());
        newContext.setErrorWriter(this.context.getErrorWriter());
        return newContext;
    }

    @Override
    public Object get(String key2) {
        return this.context.getAttribute(key2, 100);
    }

    @Override
    public void put(String key2, Object value2) {
        this.context.getBindings(100).put(key2, value2);
    }

    @Override
    public Bindings getBindings(int scope) {
        return this.context.getBindings(scope);
    }

    @Override
    public void setBindings(Bindings bindings, int scope) {
        this.context.setBindings(bindings, scope);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptContext getContext() {
        return this.context;
    }

    @Override
    public void setContext(ScriptContext context) {
        Objects.requireNonNull(context, "context");
        this.context = context;
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public Object invokeMethod(Object receiver2, String method2, Object ... args2) throws ScriptException, NoSuchMethodException {
        Objects.requireNonNull(method2, "method");
        Objects.requireNonNull(receiver2, "receiver");
        Utils.preEval(this.container, this.context);
        try {
            if (args2 == null || args2.length == 0) {
                Object object = this.container.callMethod(receiver2, method2, Object.class);
                return object;
            }
            Object object = this.container.callMethod(receiver2, method2, args2, Object.class);
            return object;
        }
        catch (NoMethodError e) {
            throw JRubyEngine.wrapMethodException(e);
        }
        catch (RaiseException e) {
            throw JRubyEngine.wrapRaiseException(e);
        }
        catch (Exception e) {
            throw JRubyEngine.wrapException(e);
        }
        finally {
            Utils.postEval(this.container, this.context);
        }
    }

    @Override
    public Object invokeFunction(String method2, Object ... args2) throws ScriptException, NoSuchMethodException {
        Objects.requireNonNull(method2, "method");
        Utils.preEval(this.container, this.context);
        try {
            IRubyObject receiver2 = this.container.getProvider().getRuntime().getTopSelf();
            if (args2 == null || args2.length == 0) {
                Object object = this.container.callMethod((Object)receiver2, method2, Object.class);
                return object;
            }
            Object object = this.container.callMethod((Object)receiver2, method2, args2, Object.class);
            return object;
        }
        catch (NoMethodError e) {
            throw JRubyEngine.wrapMethodException(e);
        }
        catch (RaiseException e) {
            throw JRubyEngine.wrapRaiseException(e);
        }
        catch (Exception e) {
            throw JRubyEngine.wrapException(e);
        }
        finally {
            Utils.postEval(this.container, this.context);
        }
    }

    @Override
    public void close() {
        this.container.terminate();
    }

    @Override
    public <T> T getInterface(Class<T> returnType) {
        return this.getInterface(null, returnType);
    }

    @Override
    public <T> T getInterface(Object receiver2, Class<T> returnType) {
        return this.container.getInstance(receiver2, returnType);
    }

    private static ScriptException wrapException(Exception e) {
        return new ScriptException(e);
    }

    private static ScriptException wrapRaiseException(RaiseException e) {
        RubyStackTraceElement[] trace2 = e.getException().getBacktraceElements();
        if (trace2.length > 0) {
            RubyStackTraceElement top = trace2[0];
            String file2 = top.getFileName();
            int line = top.getLineNumber();
            if (file2 == null) {
                file2 = "<script>";
            }
            ScriptException se = new ScriptException("Error during evaluation of Ruby in " + file2 + " at line " + line + ": " + e.getMessage());
            se.initCause(e);
            Ruby runtime2 = e.getException().getRuntime();
            runtime2.getCurrentContext().setErrorInfo(runtime2.getNil());
            return se;
        }
        return new ScriptException(e);
    }

    private static NoSuchMethodException wrapMethodException(RaiseException e) {
        return (NoSuchMethodException)new NoSuchMethodException(e.getMessage()).initCause(e);
    }
}

