/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteOrder;
import java.util.Objects;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Error;
import org.jruby.ext.ffi.CallbackInfo;
import org.jruby.ext.ffi.Factory;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryObject;
import org.jruby.ext.ffi.MemoryOp;
import org.jruby.ext.ffi.MemoryUtil;
import org.jruby.ext.ffi.Platform;
import org.jruby.ext.ffi.Pointer;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.Type;
import org.jruby.ext.ffi.TypeSizeMapper;
import org.jruby.ext.ffi.Util;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"FFI::AbtractMemoryAbstractMemory"}, parent="Object")
public abstract class AbstractMemory
extends MemoryObject {
    public static final String ABSTRACT_MEMORY_RUBY_CLASS = "AbstractMemory";
    protected long size;
    protected int typeSize;

    public static RubyClass createAbstractMemoryClass(ThreadContext context, RubyModule FFI2, RubyClass Object2) {
        return (RubyClass)((RubyModule)((RubyModule)FFI2.defineClassUnder(context, ABSTRACT_MEMORY_RUBY_CLASS, Object2, ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR)).defineMethods(context, AbstractMemory.class)).defineConstants(context, AbstractMemory.class);
    }

    protected static final int calculateTypeSize(ThreadContext context, IRubyObject sizeArg) {
        int n;
        IRubyObject iRubyObject = sizeArg;
        Objects.requireNonNull(iRubyObject);
        IRubyObject iRubyObject2 = iRubyObject;
        int n2 = 0;
        block6: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RubyFixnum.class, RubySymbol.class, Type.class, RubyClass.class}, (Object)iRubyObject2, n2)) {
                case 0: {
                    RubyFixnum fix2 = (RubyFixnum)iRubyObject2;
                    n = fix2.asInt(context);
                    break block6;
                }
                case 1: {
                    RubySymbol sym = (RubySymbol)iRubyObject2;
                    n = TypeSizeMapper.getTypeSize(context, sym);
                    break block6;
                }
                case 2: {
                    Type type2 = (Type)iRubyObject2;
                    n = type2.getNativeSize();
                    break block6;
                }
                case 3: {
                    RubyClass cls = (RubyClass)iRubyObject2;
                    if (!Struct.isStruct(context, cls)) {
                        n2 = 4;
                        continue block6;
                    }
                    n = Struct.getStructSize(context, sizeArg);
                    break block6;
                }
                default: {
                    DynamicMethod sizeMethod = sizeArg.getMetaClass().searchMethod("size");
                    if (sizeMethod.isUndefined()) {
                        throw Error.argumentError(context, "Invalid size argument");
                    }
                    n = Convert.toInt(context, sizeMethod.call(context, sizeArg, sizeArg.getMetaClass(), "size"));
                    break block6;
                }
            }
            break;
        }
        return n;
    }

    protected static final RubyArray checkArray(IRubyObject obj) {
        if (obj instanceof RubyArray) {
            RubyArray arr = (RubyArray)obj;
            return arr;
        }
        throw Error.typeError(obj.getRuntime().getCurrentContext(), "Array expected");
    }

    private static int checkArrayLength(ThreadContext context, IRubyObject val) {
        int i2 = Convert.toInt(context, val);
        if (i2 < 0) {
            throw Error.indexError(context, "negative array length (" + i2 + ")");
        }
        return i2;
    }

    protected AbstractMemory(Ruby runtime2, RubyClass klass, MemoryIO io2, long size2) {
        this(runtime2, klass, io2, size2, 1);
    }

    protected AbstractMemory(Ruby runtime2, RubyClass klass, MemoryIO io2, long size2, int typeSize) {
        super(runtime2, klass);
        this.setMemoryIO(io2);
        this.size = size2;
        this.typeSize = typeSize;
    }

    static AbstractMemory cast(ThreadContext context, IRubyObject ptr) {
        if (ptr instanceof AbstractMemory) {
            AbstractMemory memory = (AbstractMemory)ptr;
            return memory;
        }
        throw Error.typeError(context, ptr, context.runtime.getFFI().memoryClass);
    }

    @Override
    protected MemoryIO allocateMemoryIO() {
        throw this.getRuntime().newRuntimeError("allocateMemoryIO should not be called");
    }

    protected final long getOffset(IRubyObject offset2) {
        return Util.longValue(offset2);
    }

    public final long getSize() {
        return this.size;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashCode());
    }

    @JRubyMethod(name={"[]"})
    public final IRubyObject aref(ThreadContext context, IRubyObject indexArg) {
        int index2 = Convert.toInt(context, indexArg);
        int offset2 = index2 * this.typeSize;
        if ((long)offset2 >= this.size) {
            throw Error.indexError(context, String.format("Index %d out of range", index2));
        }
        return this.slice(context.runtime, offset2);
    }

    @Override
    public boolean equals(Object obj) {
        AbstractMemory other;
        return obj instanceof AbstractMemory && (other = (AbstractMemory)obj).getMemoryIO().equals(this.getMemoryIO());
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject obj) {
        return Convert.asBoolean(context, this.equals(obj));
    }

    @Override
    public int hashCode() {
        return 67 * this.getMemoryIO().hashCode();
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context) {
        this.getMemoryIO().setMemory(0L, this.size, (byte)0);
        return this;
    }

    @JRubyMethod(name={"total", "size", "length"})
    public IRubyObject total(ThreadContext context) {
        return Convert.asFixnum(context, this.size);
    }

    @JRubyMethod(name={"type_size"})
    public final IRubyObject type_size(ThreadContext context) {
        return Convert.asFixnum(context, this.typeSize);
    }

    @JRubyMethod(name={"write_char"})
    public IRubyObject write_char(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putByte(0L, Util.int8Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int8", "put_char"})
    public IRubyObject put_int8(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putByte(0L, Util.int8Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int8", "put_char"})
    public IRubyObject put_int8(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putByte(this.getOffset(offset2), Util.int8Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_char"})
    public IRubyObject read_char(ThreadContext context) {
        return Util.newSigned8(context.runtime, this.getMemoryIO().getByte(0L));
    }

    @JRubyMethod(name={"get_int8", "get_char"})
    public IRubyObject get_int8(ThreadContext context) {
        return Util.newSigned8(context.runtime, this.getMemoryIO().getByte(0L));
    }

    @JRubyMethod(name={"get_int8", "get_char"})
    public IRubyObject get_int8(ThreadContext context, IRubyObject offset2) {
        return Util.newSigned8(context.runtime, this.getMemoryIO().getByte(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_uchar"})
    public IRubyObject write_uchar(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putByte(0L, (byte)Util.uint8Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint8", "put_uchar"})
    public IRubyObject put_uint8(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putByte(0L, (byte)Util.uint8Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint8", "put_uchar"})
    public IRubyObject put_uint8(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putByte(this.getOffset(offset2), (byte)Util.uint8Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_uchar"})
    public IRubyObject read_uchar(ThreadContext context) {
        return Util.newUnsigned8(context.runtime, this.getMemoryIO().getByte(0L));
    }

    @JRubyMethod(name={"get_uint8", "get_uchar"})
    public IRubyObject get_uint8(ThreadContext context) {
        return Util.newUnsigned8(context.runtime, this.getMemoryIO().getByte(0L));
    }

    @JRubyMethod(name={"get_uint8", "get_uchar"})
    public IRubyObject get_uint8(ThreadContext context, IRubyObject offset2) {
        return Util.newUnsigned8(context.runtime, this.getMemoryIO().getByte(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_short", "write_int16"})
    public IRubyObject write_short(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putShort(0L, Util.int16Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int16", "put_short"})
    public IRubyObject put_int16(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putShort(0L, Util.int16Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int16", "put_short"})
    public IRubyObject put_int16(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putShort(this.getOffset(offset2), Util.int16Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_short"})
    public IRubyObject read_short(ThreadContext context) {
        return Util.newSigned16(context.runtime, this.getMemoryIO().getShort(0L));
    }

    @JRubyMethod(name={"get_int16", "get_short"})
    public IRubyObject get_int16(ThreadContext context) {
        return Util.newSigned16(context.runtime, this.getMemoryIO().getShort(0L));
    }

    @JRubyMethod(name={"get_int16", "get_short"})
    public IRubyObject get_int16(ThreadContext context, IRubyObject offset2) {
        return Util.newSigned16(context.runtime, this.getMemoryIO().getShort(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_ushort"})
    public IRubyObject write_ushort(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putShort(0L, (short)Util.uint16Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint16", "put_ushort"})
    public IRubyObject put_uint16(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putShort(0L, (short)Util.uint16Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint16", "put_ushort"})
    public IRubyObject put_uint16(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putShort(this.getOffset(offset2), (short)Util.uint16Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_ushort"})
    public IRubyObject read_ushort(ThreadContext context) {
        return Util.newUnsigned16(context.runtime, this.getMemoryIO().getShort(0L));
    }

    @JRubyMethod(name={"get_uint16", "get_ushort"})
    public IRubyObject get_uint16(ThreadContext context) {
        return Util.newUnsigned16(context.runtime, this.getMemoryIO().getShort(0L));
    }

    @JRubyMethod(name={"get_uint16", "get_ushort"})
    public IRubyObject get_uint16(ThreadContext context, IRubyObject offset2) {
        return Util.newUnsigned16(context.runtime, this.getMemoryIO().getShort(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_int", "write_int32"})
    public IRubyObject write_int(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putInt(0L, Util.int32Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int32", "put_int"})
    public IRubyObject put_int32(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putInt(0L, Util.int32Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int32", "put_int"})
    public IRubyObject put_int32(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putInt(this.getOffset(offset2), Util.int32Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_int", "read_int32"})
    public IRubyObject read_int(ThreadContext context) {
        return Util.newSigned32(context.runtime, this.getMemoryIO().getInt(0L));
    }

    @JRubyMethod(name={"get_int32", "get_int"})
    public IRubyObject get_int32(ThreadContext context) {
        return Util.newSigned32(context.runtime, this.getMemoryIO().getInt(0L));
    }

    @JRubyMethod(name={"get_int32", "get_int"})
    public IRubyObject get_int32(ThreadContext context, IRubyObject offset2) {
        return Util.newSigned32(context.runtime, this.getMemoryIO().getInt(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_uint32", "write_uint"})
    public IRubyObject write_uint(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putInt(0L, (int)Util.uint32Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint32", "put_uint"})
    public IRubyObject put_uint32(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putInt(0L, (int)Util.uint32Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint32", "put_uint"})
    public IRubyObject put_uint32(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putInt(this.getOffset(offset2), (int)Util.uint32Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_uint8"})
    public IRubyObject read_uint8(ThreadContext context) {
        return Util.newUnsigned8(context.runtime, this.getMemoryIO().getByte(0L));
    }

    @JRubyMethod(name={"read_uint16"})
    public IRubyObject read_uint16(ThreadContext context) {
        return Util.newUnsigned16(context.runtime, this.getMemoryIO().getShort(0L));
    }

    @JRubyMethod(name={"read_uint", "read_uint32"})
    public IRubyObject read_uint(ThreadContext context) {
        return Util.newUnsigned32(context.runtime, this.getMemoryIO().getInt(0L));
    }

    @JRubyMethod(name={"get_uint32", "get_uint"})
    public IRubyObject get_uint32(ThreadContext context) {
        return Util.newUnsigned32(context.runtime, this.getMemoryIO().getInt(0L));
    }

    @JRubyMethod(name={"get_uint32", "get_uint"})
    public IRubyObject get_uint32(ThreadContext context, IRubyObject offset2) {
        return Util.newUnsigned32(context.runtime, this.getMemoryIO().getInt(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_int64", "write_long_long"})
    public IRubyObject write_long_long(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putLong(0L, Util.int64Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int64", "put_long_long"})
    public IRubyObject put_int64(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putLong(0L, Util.int64Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_int64", "put_long_long"})
    public IRubyObject put_int64(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putLong(this.getOffset(offset2), Util.int64Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_int64", "read_long_long"})
    public IRubyObject read_long_long(ThreadContext context) {
        return Util.newSigned64(context.runtime, this.getMemoryIO().getLong(0L));
    }

    @JRubyMethod(name={"get_int64", "get_long_long"})
    public IRubyObject get_int64(ThreadContext context) {
        return Util.newSigned64(context.runtime, this.getMemoryIO().getLong(0L));
    }

    @JRubyMethod(name={"get_int64", "get_long_long"})
    public IRubyObject get_int64(ThreadContext context, IRubyObject offset2) {
        return Util.newSigned64(context.runtime, this.getMemoryIO().getLong(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_uint64", "write_ulong_long"})
    public IRubyObject write_ulong_long(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putLong(0L, Util.uint64Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint64", "put_ulong_long"})
    public IRubyObject put_uint64(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putLong(0L, Util.uint64Value(value2));
        return this;
    }

    @JRubyMethod(name={"put_uint64", "put_ulong_long"})
    public IRubyObject put_uint64(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putLong(this.getOffset(offset2), Util.uint64Value(value2));
        return this;
    }

    @JRubyMethod(name={"read_uint64", "read_ulong_long"})
    public IRubyObject read_ulong_long(ThreadContext context) {
        return Util.newUnsigned64(context.runtime, this.getMemoryIO().getLong(0L));
    }

    @JRubyMethod(name={"get_uint64", "get_ulong_long"})
    public IRubyObject get_uint64(ThreadContext context) {
        return Util.newUnsigned64(context.runtime, this.getMemoryIO().getLong(0L));
    }

    @JRubyMethod(name={"get_uint64", "get_ulong_long"})
    public IRubyObject get_uint64(ThreadContext context, IRubyObject offset2) {
        return Util.newUnsigned64(context.runtime, this.getMemoryIO().getLong(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_long"})
    public IRubyObject write_long(ThreadContext context, IRubyObject value2) {
        return this.put_long(context, value2);
    }

    @JRubyMethod(name={"put_long"})
    public IRubyObject put_long(ThreadContext context, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_int32(context, value2) : this.put_int64(context, value2);
    }

    @JRubyMethod(name={"put_long"})
    public IRubyObject put_long(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_int32(context, offset2, value2) : this.put_int64(context, offset2, value2);
    }

    @JRubyMethod(name={"read_long"})
    public IRubyObject read_long(ThreadContext context) {
        return this.get_long(context);
    }

    @JRubyMethod(name={"get_long"})
    public IRubyObject get_long(ThreadContext context) {
        return Platform.getPlatform().longSize() == 32 ? this.get_int32(context) : this.get_int64(context);
    }

    @JRubyMethod(name={"get_long"})
    public IRubyObject get_long(ThreadContext context, IRubyObject offset2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_int32(context, offset2) : this.get_int64(context, offset2);
    }

    @JRubyMethod(name={"put_ulong", "write_ulong"})
    public IRubyObject put_ulong(ThreadContext context, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_uint32(context, value2) : this.put_uint64(context, value2);
    }

    @JRubyMethod(name={"put_ulong"})
    public IRubyObject put_ulong(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        return Platform.getPlatform().longSize() == 32 ? this.put_uint32(context, offset2, value2) : this.put_uint64(context, offset2, value2);
    }

    @JRubyMethod(name={"read_ulong"})
    public IRubyObject read_ulong(ThreadContext context) {
        return this.get_ulong(context);
    }

    @JRubyMethod(name={"get_ulong", "read_ulong"})
    public IRubyObject get_ulong(ThreadContext context) {
        return Platform.getPlatform().longSize() == 32 ? this.get_uint32(context) : this.get_uint64(context);
    }

    @JRubyMethod(name={"get_ulong"})
    public IRubyObject get_ulong(ThreadContext context, IRubyObject offset2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_uint32(context, offset2) : this.get_uint64(context, offset2);
    }

    @JRubyMethod(name={"write_float"})
    public IRubyObject write_float(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putFloat(0L, Util.floatValue(context, value2));
        return this;
    }

    @JRubyMethod(name={"put_float32", "put_float"})
    public IRubyObject put_float32(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putFloat(0L, Util.floatValue(context, value2));
        return this;
    }

    @JRubyMethod(name={"put_float32", "put_float"})
    public IRubyObject put_float32(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putFloat(this.getOffset(offset2), Util.floatValue(context, value2));
        return this;
    }

    @JRubyMethod(name={"read_float"})
    public IRubyObject read_float(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getFloat(0L));
    }

    @JRubyMethod(name={"get_float32", "get_float"})
    public IRubyObject get_float32(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getFloat(0L));
    }

    @JRubyMethod(name={"get_float32", "get_float"})
    public IRubyObject get_float32(ThreadContext context, IRubyObject offset2) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getFloat(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"write_double"})
    public IRubyObject write_double(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putDouble(0L, Util.doubleValue(context, value2));
        return this;
    }

    @JRubyMethod(name={"put_float64", "put_double"})
    public IRubyObject put_float64(ThreadContext context, IRubyObject value2) {
        this.getMemoryIO().putDouble(0L, Util.doubleValue(context, value2));
        return this;
    }

    @JRubyMethod(name={"put_float64", "put_double"})
    public IRubyObject put_float64(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.getMemoryIO().putDouble(this.getOffset(offset2), Util.doubleValue(context, value2));
        return this;
    }

    @JRubyMethod(name={"read_double"})
    public IRubyObject read_double(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getDouble(0L));
    }

    @JRubyMethod(name={"get_float64", "get_double"})
    public IRubyObject get_float64(ThreadContext context) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getDouble(0L));
    }

    @JRubyMethod(name={"get_float64", "get_double"})
    public IRubyObject get_float64(ThreadContext context, IRubyObject offset2) {
        return RubyFloat.newFloat(context.runtime, this.getMemoryIO().getDouble(this.getOffset(offset2)));
    }

    @JRubyMethod(name={"get_array_of_int8", "get_array_of_char"})
    public IRubyObject get_array_of_int8(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned8(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_int8", "put_array_of_char"})
    public IRubyObject put_array_of_int8(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfSigned8(this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_uint8", "get_array_of_uchar"})
    public IRubyObject get_array_of_uint8(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned8(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_uint8", "put_array_of_uchar"})
    public IRubyObject put_array_of_uint8(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfUnsigned8(this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_int16", "get_array_of_short"})
    public IRubyObject get_array_of_int16(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned16(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_int16", "put_array_of_short"})
    public IRubyObject put_array_of_int16(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfSigned16(this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_uint16", "get_array_of_ushort"})
    public IRubyObject get_array_of_uint16(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned16(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_uint16", "put_array_of_ushort"})
    public IRubyObject put_array_of_uint16(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfUnsigned16(this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_int32", "get_array_of_int"})
    public IRubyObject get_array_of_int32(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned32(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_int32", "put_array_of_int"})
    public IRubyObject put_array_of_int32(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfSigned32(this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_uint32", "get_array_of_uint"})
    public IRubyObject get_array_of_uint32(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned32(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_uint32", "put_array_of_uint"})
    public IRubyObject put_array_of_uint32(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfUnsigned32(this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_long"})
    public IRubyObject get_array_of_long(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_array_of_int32(context, offset2, length2) : this.get_array_of_int64(context, offset2, length2);
    }

    @JRubyMethod(name={"put_array_of_long"})
    public IRubyObject put_array_of_long(ThreadContext context, IRubyObject offset2, IRubyObject arr) {
        return Platform.getPlatform().longSize() == 32 ? this.put_array_of_int32(context, offset2, arr) : this.put_array_of_int64(context, offset2, arr);
    }

    @JRubyMethod(name={"get_array_of_ulong"})
    public IRubyObject get_array_of_ulong(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return Platform.getPlatform().longSize() == 32 ? this.get_array_of_uint32(context, offset2, length2) : this.get_array_of_uint64(context, offset2, length2);
    }

    @JRubyMethod(name={"put_array_of_ulong"})
    public IRubyObject put_array_of_ulong(ThreadContext context, IRubyObject offset2, IRubyObject arr) {
        return Platform.getPlatform().longSize() == 32 ? this.put_array_of_uint32(context, offset2, arr) : this.put_array_of_uint64(context, offset2, arr);
    }

    @JRubyMethod(name={"get_array_of_int64", "get_array_of_long_long"})
    public IRubyObject get_array_of_int64(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned64(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_int64", "put_array_of_long_long"})
    public IRubyObject put_array_of_int64(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfSigned64(this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_uint64", "get_array_of_ulong_long"})
    public IRubyObject get_array_of_uint64(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned64(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_uint64", "put_array_of_ulong_long"})
    public IRubyObject put_array_of_uint64(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfUnsigned64(this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_float32", "get_array_of_float"})
    public IRubyObject get_array_of_float(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfFloat32(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_float32", "put_array_of_float"})
    public IRubyObject put_array_of_float(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfFloat32(context, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"get_array_of_float64", "get_array_of_double"})
    public IRubyObject get_array_of_float64(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        return MemoryUtil.getArrayOfFloat64(context, this.getMemoryIO(), this.getOffset(offset2), Util.int32Value(length2));
    }

    @JRubyMethod(name={"put_array_of_float64", "put_array_of_double"})
    public IRubyObject put_array_of_float64(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        MemoryUtil.putArrayOfFloat64(context, this.getMemoryIO(), this.getOffset(offset2), AbstractMemory.checkArray(arrParam));
        return this;
    }

    @JRubyMethod(name={"read_array_of_int8", "read_array_of_char"})
    public IRubyObject read_array_of_int8(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned8(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_int8", "write_array_of_char"})
    public IRubyObject write_array_of_int8(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfSigned8(this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_uint8", "read_array_of_uchar"})
    public IRubyObject read_array_of_uint8(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned8(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_uint8", "write_array_of_uchar"})
    public IRubyObject write_array_of_uint8(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfUnsigned8(this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_int16", "read_array_of_short"})
    public IRubyObject read_array_of_int16(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned16(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_int16", "write_array_of_short"})
    public IRubyObject write_array_of_int16(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfSigned16(this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_uint16", "read_array_of_ushort"})
    public IRubyObject read_array_of_uint16(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned16(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_uint16", "write_array_of_ushort"})
    public IRubyObject write_array_of_uint16(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfUnsigned16(this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_int32", "read_array_of_int"})
    public IRubyObject read_array_of_int32(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned32(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_int32", "write_array_of_int"})
    public IRubyObject write_array_of_int32(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfSigned32(this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_uint32", "read_array_of_uint"})
    public IRubyObject read_array_of_uint32(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned32(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_uint32", "write_array_of_uint"})
    public IRubyObject write_array_of_uint32(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfUnsigned32(this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_int64", "read_array_of_long_long"})
    public IRubyObject read_array_of_int64(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfSigned64(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_int64", "write_array_of_long_long"})
    public IRubyObject write_array_of_int64(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfSigned64(this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_uint64", "read_array_of_ulong_long"})
    public IRubyObject read_array_of_uint64(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfUnsigned64(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_uint64", "write_array_of_ulong_long"})
    public IRubyObject write_array_of_uint64(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfUnsigned64(this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_long"})
    public IRubyObject read_array_of_long(ThreadContext context, IRubyObject length2) {
        return Platform.getPlatform().longSize() == 32 ? this.read_array_of_int32(context, length2) : this.read_array_of_int64(context, length2);
    }

    @JRubyMethod(name={"write_array_of_long"})
    public IRubyObject write_array_of_long(ThreadContext context, IRubyObject ary) {
        return Platform.getPlatform().longSize() == 32 ? this.write_array_of_int32(context, ary) : this.write_array_of_int64(context, ary);
    }

    @JRubyMethod(name={"read_array_of_ulong"})
    public IRubyObject read_array_of_ulong(ThreadContext context, IRubyObject length2) {
        return Platform.getPlatform().longSize() == 32 ? this.read_array_of_uint32(context, length2) : this.read_array_of_uint64(context, length2);
    }

    @JRubyMethod(name={"write_array_of_ulong"})
    public IRubyObject write_array_of_ulong(ThreadContext context, IRubyObject ary) {
        return Platform.getPlatform().longSize() == 32 ? this.write_array_of_uint32(context, ary) : this.write_array_of_uint64(context, ary);
    }

    @JRubyMethod(name={"read_array_of_float32", "read_array_of_float"})
    public IRubyObject read_array_of_float(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfFloat32(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_float32", "write_array_of_float"})
    public IRubyObject write_array_of_float(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfFloat32(context, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_float64", "read_array_of_double"})
    public IRubyObject read_array_of_float64(ThreadContext context, IRubyObject length2) {
        return MemoryUtil.getArrayOfFloat64(context, this.getMemoryIO(), 0L, Util.int32Value(length2));
    }

    @JRubyMethod(name={"write_array_of_float64", "write_array_of_double"})
    public IRubyObject write_array_of_float64(ThreadContext context, IRubyObject ary) {
        MemoryUtil.putArrayOfFloat64(context, this.getMemoryIO(), 0L, AbstractMemory.checkArray(ary));
        return this;
    }

    @JRubyMethod(name={"read_array_of_type"})
    public IRubyObject read_array_of_type(ThreadContext context, IRubyObject typeArg, IRubyObject lenArg) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeArg);
        MemoryOp op = MemoryOp.getMemoryOp(type2);
        if (op == null) {
            throw Error.typeError(context, "cannot get memory reader for type " + String.valueOf(type2));
        }
        int len = AbstractMemory.checkArrayLength(context, lenArg);
        IRubyObject[] objArray = new IRubyObject[len];
        int i2 = 0;
        int off = 0;
        while (i2 < len) {
            objArray[i2] = op.get(context, this.getMemoryIO(), (long)off);
            ++i2;
            off += type2.size;
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    @JRubyMethod(name={"read_array_of_type"})
    public IRubyObject read_array_of_type(ThreadContext context, IRubyObject typeArg, IRubyObject reader, IRubyObject lenArg) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeArg);
        DynamicMethod method2 = this.getMetaClass().searchMethod(reader.asJavaString());
        int len = AbstractMemory.checkArrayLength(context, lenArg);
        IRubyObject[] objArray = new IRubyObject[len];
        int i2 = 0;
        int off = 0;
        while (i2 < len) {
            objArray[i2] = method2.call(context, this.slice(context.runtime, off, type2.size), this.getMetaClass(), reader.asJavaString());
            ++i2;
            off += type2.size;
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    @JRubyMethod(name={"write_array_of_type"})
    public IRubyObject write_array_of_type(ThreadContext context, IRubyObject typeArg, IRubyObject aryArg) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeArg);
        MemoryOp op = MemoryOp.getMemoryOp(type2);
        if (op == null) {
            throw Error.typeError(context, "cannot get memory writer for type " + String.valueOf(type2));
        }
        RubyArray arr = aryArg.convertToArray();
        int len = arr.size();
        int i2 = 0;
        int off = 0;
        while (i2 < len) {
            op.put(context, this.getMemoryIO(), (long)off, arr.entry(i2));
            ++i2;
            off += type2.size;
        }
        return this;
    }

    @JRubyMethod(name={"write_array_of_type"})
    public IRubyObject write_array_of_type(ThreadContext context, IRubyObject typeArg, IRubyObject writer, IRubyObject aryArg) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeArg);
        DynamicMethod method2 = this.getMetaClass().searchMethod(writer.asJavaString());
        RubyArray arr = aryArg.convertToArray();
        int len = arr.size();
        int i2 = 0;
        int off = 0;
        while (i2 < len) {
            method2.call(context, (IRubyObject)this.slice(context.runtime, off, type2.size), (RubyModule)this.getMetaClass(), writer.asJavaString(), arr.entry(i2));
            ++i2;
            off += type2.size;
        }
        return this;
    }

    @JRubyMethod(name={"read_string"})
    public IRubyObject read_string(ThreadContext context) {
        return MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), 0L);
    }

    @JRubyMethod(name={"read_string"})
    public IRubyObject read_string(ThreadContext context, IRubyObject rbLength) {
        if (rbLength.isNil()) {
            return MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), 0L);
        }
        int len = Util.int32Value(rbLength);
        return len != 0 ? MemoryUtil.getTaintedByteString(context.runtime, this.getMemoryIO(), 0L, len) : Create.newEmptyString(context, ASCIIEncoding.INSTANCE);
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context) {
        return MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), 0L);
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context, IRubyObject offArg) {
        return MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), this.getOffset(offArg));
    }

    @JRubyMethod(name={"get_string"})
    public IRubyObject get_string(ThreadContext context, IRubyObject offArg, IRubyObject lenArg) {
        return MemoryUtil.getTaintedString(context.runtime, this.getMemoryIO(), this.getOffset(offArg), Util.int32Value(lenArg));
    }

    @JRubyMethod(name={"get_array_of_string"})
    public IRubyObject get_array_of_string(ThreadContext context, IRubyObject rbOffset) {
        MemoryIO mem;
        int POINTER_SIZE = Platform.getPlatform().addressSize() / 8;
        RubyArray<?> arr = Create.newArray(context);
        for (long off = this.getOffset(rbOffset); off <= this.size - (long)POINTER_SIZE && (mem = this.getMemoryIO().getMemoryIO(off)) != null && !mem.isNull(); off += (long)POINTER_SIZE) {
            arr.add(MemoryUtil.getTaintedString(context.runtime, mem, 0L));
        }
        return arr;
    }

    @JRubyMethod(name={"get_array_of_string"})
    public IRubyObject get_array_of_string(ThreadContext context, IRubyObject rbOffset, IRubyObject rbCount) {
        int POINTER_SIZE = Platform.getPlatform().addressSize() / 8;
        long off = this.getOffset(rbOffset);
        int count2 = Util.int32Value(rbCount);
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < count2; ++i2) {
            MemoryIO mem = this.getMemoryIO().getMemoryIO(off + (long)(i2 * POINTER_SIZE));
            objArray[i2] = mem != null && !mem.isNull() ? MemoryUtil.getTaintedString(context.runtime, mem, 0L) : context.nil;
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    @JRubyMethod(name={"read_array_of_string"})
    public IRubyObject read_array_of_string(ThreadContext context) {
        return this.get_array_of_string(context, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod(name={"read_array_of_string"})
    public IRubyObject read_array_of_string(ThreadContext context, IRubyObject rbLength) {
        return this.get_array_of_string(context, RubyFixnum.zero(context.runtime), rbLength);
    }

    @JRubyMethod(name={"put_string"})
    public IRubyObject put_string(ThreadContext context, IRubyObject offArg, IRubyObject strArg) {
        long off = this.getOffset(offArg);
        ByteList bl = strArg.convertToString().getByteList();
        this.getMemoryIO().putZeroTerminatedByteArray(off, bl.getUnsafeBytes(), bl.begin(), bl.length());
        return this;
    }

    @JRubyMethod(name={"write_string"})
    public IRubyObject write_string(ThreadContext context, IRubyObject strArg) {
        ByteList bl = strArg.convertToString().getByteList();
        this.getMemoryIO().put(0L, bl.getUnsafeBytes(), bl.begin(), bl.length());
        return this;
    }

    @JRubyMethod(name={"write_string"})
    public IRubyObject write_string(ThreadContext context, IRubyObject strArg, IRubyObject lenArg) {
        ByteList bl = strArg.convertToString().getByteList();
        this.getMemoryIO().put(0L, bl.getUnsafeBytes(), bl.begin(), Math.min(bl.length(), Convert.toInt(context, lenArg)));
        return this;
    }

    @JRubyMethod(name={"get_bytes"})
    public IRubyObject get_bytes(ThreadContext context, IRubyObject offArg, IRubyObject lenArg) {
        return MemoryUtil.getTaintedByteString(context.runtime, this.getMemoryIO(), this.getOffset(offArg), Util.int32Value(lenArg));
    }

    private IRubyObject putBytes(ThreadContext context, long off, ByteList bl, int idx, int len) {
        if (idx < 0) {
            throw Error.rangeError(context, "index can not be less than zero");
        }
        if (idx + len > bl.length()) {
            throw Error.rangeError(context, "index+length is greater than size of string");
        }
        this.getMemoryIO().put(off, bl.getUnsafeBytes(), bl.begin() + idx, len);
        return this;
    }

    @JRubyMethod(name={"put_bytes"}, required=2, optional=2, checkArity=false)
    public IRubyObject put_bytes(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 2, 4);
        ByteList bl = args2[1].convertToString().getByteList();
        int idx = argc > 2 ? Util.int32Value(args2[2]) : 0;
        int len = argc > 3 ? Util.int32Value(args2[3]) : bl.length() - idx;
        return this.putBytes(context, this.getOffset(args2[0]), bl, idx, len);
    }

    @JRubyMethod(name={"read_bytes"})
    public IRubyObject read_bytes(ThreadContext context, IRubyObject lenArg) {
        return MemoryUtil.getTaintedByteString(context.runtime, this.getMemoryIO(), 0L, Util.int32Value(lenArg));
    }

    @JRubyMethod(name={"write_bytes"}, required=1, optional=2, checkArity=false)
    public IRubyObject write_bytes(ThreadContext context, IRubyObject[] args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 3);
        ByteList bl = args2[0].convertToString().getByteList();
        int idx = argc > 1 ? Util.int32Value(args2[1]) : 0;
        int len = argc > 2 ? Util.int32Value(args2[2]) : bl.length() - idx;
        return this.putBytes(context, 0L, bl, idx, len);
    }

    @JRubyMethod(name={"read_pointer"})
    public IRubyObject read_pointer(ThreadContext context) {
        return this.getPointer(context.runtime, 0L);
    }

    @JRubyMethod(name={"get_pointer"})
    public IRubyObject get_pointer(ThreadContext context) {
        return this.getPointer(context.runtime, 0L);
    }

    @JRubyMethod(name={"get_pointer"})
    public IRubyObject get_pointer(ThreadContext context, IRubyObject offset2) {
        return this.getPointer(context.runtime, this.getOffset(offset2));
    }

    private void putPointer(ThreadContext context, long offset2, IRubyObject value2) {
        if (value2 instanceof Pointer) {
            Pointer ptr = (Pointer)value2;
            this.putPointer(context, offset2, ptr);
        } else if (value2.isNil()) {
            this.getMemoryIO().putAddress(offset2, 0L);
        } else {
            DynamicMethod conversionMethod = value2.getMetaClass().searchMethod("to_ptr");
            if (!conversionMethod.isUndefined()) {
                this.putPointer(context, offset2, conversionMethod.call(context, value2, value2.getMetaClass(), "to_ptr"));
            } else {
                throw Error.typeError(context, value2, context.runtime.getFFI().pointerClass);
            }
        }
    }

    private void putPointer(ThreadContext context, long offset2, Pointer value2) {
        MemoryIO ptr = value2.getMemoryIO();
        if (ptr.isDirect()) {
            this.getMemoryIO().putMemoryIO(offset2, ptr);
        } else if (ptr.isNull()) {
            this.getMemoryIO().putAddress(offset2, 0L);
        } else {
            throw Error.argumentError(context, "Cannot convert argument to pointer");
        }
    }

    @JRubyMethod(name={"write_pointer"})
    public IRubyObject write_pointer(ThreadContext context, IRubyObject value2) {
        this.putPointer(context, 0L, value2);
        return this;
    }

    @JRubyMethod(name={"put_pointer"})
    public IRubyObject put_pointer(ThreadContext context, IRubyObject value2) {
        this.putPointer(context, 0L, value2);
        return this;
    }

    @JRubyMethod(name={"put_pointer"})
    public IRubyObject put_pointer(ThreadContext context, IRubyObject offset2, IRubyObject value2) {
        this.putPointer(context, this.getOffset(offset2), value2);
        return this;
    }

    @JRubyMethod(name={"get_array_of_pointer"})
    public IRubyObject get_array_of_pointer(ThreadContext context, IRubyObject offset2, IRubyObject length2) {
        int POINTER_SIZE = Platform.getPlatform().addressSize / 8;
        int count2 = Util.int32Value(length2);
        long off = this.getOffset(offset2);
        Ruby runtime2 = context.runtime;
        IRubyObject[] objArray = new IRubyObject[count2];
        for (int i2 = 0; i2 < count2; ++i2) {
            objArray[i2] = this.getPointer(runtime2, off + (long)(i2 * POINTER_SIZE));
        }
        return Create.newArrayNoCopy(context, objArray);
    }

    @JRubyMethod(name={"put_array_of_pointer"})
    public IRubyObject put_array_of_pointer(ThreadContext context, IRubyObject offset2, IRubyObject arrParam) {
        int POINTER_SIZE = Platform.getPlatform().addressSize / 8;
        RubyArray arr = (RubyArray)arrParam;
        int count2 = arr.getLength();
        long off = this.getOffset(offset2);
        for (int i2 = 0; i2 < count2; ++i2) {
            this.putPointer(context, off + (long)(i2 * POINTER_SIZE), arr.entry(i2));
        }
        return this;
    }

    @JRubyMethod(name={"read_array_of_pointer"})
    public IRubyObject read_array_of_pointer(ThreadContext context, IRubyObject length2) {
        return this.get_array_of_pointer(context, RubyFixnum.zero(context.runtime), length2);
    }

    @JRubyMethod(name={"write_array_of_pointer"})
    public IRubyObject write_array_of_pointer(ThreadContext context, IRubyObject arrParam) {
        return this.put_array_of_pointer(context, RubyFixnum.zero(context.runtime), arrParam);
    }

    @JRubyMethod(name={"put_callback"})
    public IRubyObject put_callback(ThreadContext context, IRubyObject offset2, IRubyObject proc2, IRubyObject cbInfo) {
        if (!(cbInfo instanceof CallbackInfo)) {
            throw Error.argumentError(context, "invalid CallbackInfo");
        }
        CallbackInfo info = (CallbackInfo)cbInfo;
        Pointer ptr = Factory.getInstance().getCallbackManager().getCallback(context, info, (Object)proc2);
        this.getMemoryIO().putMemoryIO(this.getOffset(offset2), ptr.getMemoryIO());
        return this;
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_plus(ThreadContext context, IRubyObject value2) {
        return this.slice(context.runtime, Convert.toLong(context, value2));
    }

    @JRubyMethod(name={"order"})
    public final IRubyObject order(ThreadContext context) {
        return Convert.asSymbol(context, this.getMemoryIO().order().equals(ByteOrder.LITTLE_ENDIAN) ? "little" : "big");
    }

    @JRubyMethod(name={"order"})
    public final IRubyObject order(ThreadContext context, IRubyObject byte_order) {
        ByteOrder newOrder = Util.parseByteOrder(context.runtime, byte_order);
        return this.getMemoryIO().order().equals(newOrder) ? this : this.order(context.runtime, newOrder);
    }

    @JRubyMethod(name={"to_ptr"})
    public final IRubyObject to_ptr(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"slice"})
    public final IRubyObject slice(ThreadContext context, IRubyObject offset2, IRubyObject size2) {
        return this.slice(context.getRuntime(), Convert.toInt(context, offset2), Convert.toInt(context, size2));
    }

    @JRubyMethod(name={"get"})
    public final IRubyObject put(ThreadContext context, IRubyObject typeName, IRubyObject offset2) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeName);
        MemoryOp op = MemoryOp.getMemoryOp(type2);
        if (op == null) {
            throw Error.argumentError(context, "undefined type " + String.valueOf(typeName));
        }
        return op.get(context, this.getMemoryIO(), Convert.toLong(context, offset2));
    }

    @JRubyMethod(name={"put"})
    public final IRubyObject get(ThreadContext context, IRubyObject typeName, IRubyObject offset2, IRubyObject value2) {
        Type type2 = context.runtime.getFFI().getTypeResolver().findType(context.runtime, typeName);
        MemoryOp op = MemoryOp.getMemoryOp(type2);
        if (op != null) {
            op.put(context, this.getMemoryIO(), Convert.toLong(context, offset2), value2);
            return context.nil;
        }
        throw Error.argumentError(context, "undefined type " + String.valueOf(typeName));
    }

    public abstract AbstractMemory order(Ruby var1, ByteOrder var2);

    protected abstract AbstractMemory slice(Ruby var1, long var2);

    protected abstract AbstractMemory slice(Ruby var1, long var2, long var4);

    protected abstract Pointer getPointer(Ruby var1, long var2);
}

