/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.api.Error;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;

public class ReadonlyAccessor
implements IAccessor {
    private String name;
    private IAccessor accessor;

    public ReadonlyAccessor(String name2, IAccessor accessor) {
        assert (name2 != null);
        assert (accessor != null);
        this.name = name2;
        this.accessor = accessor;
    }

    @Override
    public IRubyObject getValue() {
        return this.accessor.getValue();
    }

    @Override
    public IRubyObject setValue(IRubyObject newValue) {
        assert (newValue != null);
        throw Error.nameError(newValue.getRuntime().getCurrentContext(), this.name + " is a read-only variable", this.name);
    }

    @Override
    public void forceValue(IRubyObject newValue) {
        this.accessor.setValue(newValue);
    }
}

