
#ifndef KAUTHCORE_EXPORT_H
#define KAUTHCORE_EXPORT_H

#ifdef KAUTHCORE_STATIC_DEFINE
#  define KAUTHCORE_EXPORT
#  define KAUTHCORE_NO_EXPORT
#else
#  ifndef KAUTHCORE_EXPORT
#    ifdef KF6AuthCore_EXPORTS
        /* We are building this library */
#      define KAUTHCORE_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KAUTHCORE_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KAUTHCORE_NO_EXPORT
#    define KAUTHCORE_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KAUTHCORE_DECL_DEPRECATED
#  define KAUTHCORE_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KAUTHCORE_DECL_DEPRECATED_EXPORT
#  define KAUTHCORE_DECL_DEPRECATED_EXPORT KAUTHCORE_EXPORT KAUTHCORE_DECL_DEPRECATED
#endif

#ifndef KAUTHCORE_DECL_DEPRECATED_NO_EXPORT
#  define KAUTHCORE_DECL_DEPRECATED_NO_EXPORT KAUTHCORE_NO_EXPORT KAUTHCORE_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KAUTHCORE_NO_DEPRECATED
#    define KAUTHCORE_NO_DEPRECATED
#  endif
#endif
#include <kauth_version.h>

#define KAUTHCORE_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KAUTHCORE_NO_DEPRECATED) && !defined(KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KAUTHCORE_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KAUTHCORE_NO_DEPRECATED_WARNINGS) && !defined(KAUTHCORE_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KAUTHCORE_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KAUTHCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KAUTHCORE_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KAUTHCORE_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KAUTHCORE_NO_DEPRECATED)
#  undef KAUTHCORE_DEPRECATED
#  define KAUTHCORE_DEPRECATED_EXPORT KAUTHCORE_EXPORT
#  define KAUTHCORE_DEPRECATED_NO_EXPORT KAUTHCORE_NO_EXPORT
#elif defined(KAUTHCORE_NO_DEPRECATED_WARNINGS)
#  define KAUTHCORE_DEPRECATED
#  define KAUTHCORE_DEPRECATED_EXPORT KAUTHCORE_EXPORT
#  define KAUTHCORE_DEPRECATED_NO_EXPORT KAUTHCORE_NO_EXPORT
#else
#  define KAUTHCORE_DEPRECATED KAUTHCORE_DECL_DEPRECATED
#  define KAUTHCORE_DEPRECATED_EXPORT KAUTHCORE_DECL_DEPRECATED_EXPORT
#  define KAUTHCORE_DEPRECATED_NO_EXPORT KAUTHCORE_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KAUTHCORE_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KAUTHCORE_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KAUTHCORE_NO_DEPRECATED
#  define KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT KAUTH_VERSION
#endif
#ifdef KAUTHCORE_NO_DEPRECATED_WARNINGS
#  define KAUTHCORE_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KAUTHCORE_DEPRECATED_WARNINGS_SINCE
#  ifdef KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KAUTHCORE_DEPRECATED_WARNINGS_SINCE KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KAUTHCORE_DEPRECATED_WARNINGS_SINCE KAUTH_VERSION
#  endif
#endif

#ifndef KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KAUTHCORE_DEPRECATED
#  define KAUTHCORE_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KAUTHCORE_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KAUTHCORE_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KAUTHCORE_EXPORT_H */
