/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.file;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;

public abstract class FileContentEntity
implements ContentEntity,
Serializable {
    private File backend;
    private ContentLocation parent;
    private Repository repository;
    private static final long serialVersionUID = 3962114134995757847L;

    protected FileContentEntity(ContentLocation parent, File backend) {
        if (backend == null) {
            throw new NullPointerException("Backend file must be given.");
        }
        if (parent == null) {
            throw new NullPointerException("Parent file must be given.");
        }
        this.repository = parent.getRepository();
        this.parent = parent;
        this.backend = backend;
    }

    protected FileContentEntity(Repository repository, File backend) {
        if (backend == null) {
            throw new NullPointerException("Backend file must be given.");
        }
        if (repository == null) {
            throw new NullPointerException("Repository file must be given.");
        }
        this.repository = repository;
        this.backend = backend;
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public String getName() {
        return this.backend.getName();
    }

    protected File getBackend() {
        return this.backend;
    }

    @Override
    public Object getContentId() {
        return this.backend;
    }

    @Override
    public Object getAttribute(String domain, String key) {
        if ("org.jfree.repository".equals(domain)) {
            if ("size".equals(key)) {
                return new Long(this.backend.length());
            }
            if ("version".equals(key)) {
                return new Date(this.backend.lastModified());
            }
        }
        return null;
    }

    @Override
    public boolean setAttribute(String domain, String key, Object value) {
        if ("org.jfree.repository".equals(domain) && "version".equals(key)) {
            if (value instanceof Date) {
                Date date = (Date)value;
                return this.backend.setLastModified(date.getTime());
            }
            if (value instanceof Number) {
                Number time = (Number)value;
                return this.backend.setLastModified(time.longValue());
            }
        }
        return false;
    }

    @Override
    public ContentLocation getParent() {
        return this.parent;
    }

    @Override
    public boolean delete() {
        return this.backend.delete();
    }
}

