/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.util.ArrayList;
import java.util.Map;
import liquibase.CatalogAndSchema;
import liquibase.command.AbstractCommand;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.serializer.SnapshotSerializerFactory;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.snapshot.SnapshotListener;
import liquibase.util.StringUtils;

public class SnapshotCommand
extends AbstractCommand {
    private Database database;
    private CatalogAndSchema[] schemas;
    private String serializerFormat;
    private SnapshotListener snapshotListener;
    private Map<String, Object> snapshotMetadata;

    @Override
    public String getName() {
        return "snapshot";
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public SnapshotCommand setSchemas(CatalogAndSchema ... catalogAndSchema) {
        this.schemas = catalogAndSchema;
        return this;
    }

    public SnapshotCommand setSchemas(String ... schemas) {
        if (schemas == null || schemas.length == 0 || schemas[0] == null) {
            this.schemas = null;
            return this;
        }
        schemas = StringUtils.join(schemas, ",").split("\\s*,\\s*");
        ArrayList<CatalogAndSchema> finalList = new ArrayList<CatalogAndSchema>();
        for (String schema : schemas) {
            finalList.add(new CatalogAndSchema(null, schema).customize(this.database));
        }
        this.schemas = finalList.toArray(new CatalogAndSchema[finalList.size()]);
        return this;
    }

    public String getSerializerFormat() {
        return this.serializerFormat;
    }

    public SnapshotCommand setSerializerFormat(String serializerFormat) {
        this.serializerFormat = serializerFormat;
        return this;
    }

    public SnapshotListener getSnapshotListener() {
        return this.snapshotListener;
    }

    public void setSnapshotListener(SnapshotListener snapshotListener) {
        this.snapshotListener = snapshotListener;
    }

    public Map<String, Object> getSnapshotMetadata() {
        return this.snapshotMetadata;
    }

    public void setSnapshotMetadata(Map<String, Object> snapshotMetadata) {
        this.snapshotMetadata = snapshotMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object run() throws Exception {
        DatabaseSnapshot snapshot;
        SnapshotControl snapshotControl = new SnapshotControl(this.database);
        snapshotControl.setSnapshotListener(this.snapshotListener);
        CatalogAndSchema[] schemas = this.schemas;
        if (schemas == null) {
            schemas = new CatalogAndSchema[]{this.database.getDefaultSchema()};
        }
        ObjectQuotingStrategy originalQuotingStrategy = this.database.getObjectQuotingStrategy();
        this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
        try {
            snapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(schemas, this.database, snapshotControl);
        }
        finally {
            this.database.setObjectQuotingStrategy(originalQuotingStrategy);
        }
        snapshot.setMetadata(this.getSnapshotMetadata());
        String format = this.getSerializerFormat();
        if (format == null) {
            format = "txt";
        }
        return SnapshotSerializerFactory.getInstance().getSerializer(format).serialize(snapshot, true);
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }
}

