
	// These LSystems are designed to be run from FRACTINT.  No compilation is
	// necessary, just copy this file to the FRACTINT directory and run FRACTINT.
	// Select the lsystem fractal type and press F6 to select a file.


	// This is the old ColorPenrose1 with three changes.
	// 1. A brighter red and green
	// 2. The name was changed to group the Penrose tilings together
	// 3. The comment was corrected.

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses
	// Uses color to show similar lines

	Penrose_color(n)	=> attr (delta, 360/10) +WF--XF---YF--ZF, n;
	W	=> YF++ZF----XF[-YF----WF]++;
	X	=> +YF--ZF[---WF--XF]+;
	Y	=> -WF++XF[+++YF++ZF]-;
	Z	=> --YF++++WF[+ZF++++XF]--XF;
	F	=> ;
)

	// This tiling actually does what the old comment for ColorPenrose1 said
	// it did.

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's rhombuses
	// Uses color to show the edge matching rules to force nonperiodicy

	Penrose_forced(n)	=> attr (delta, 360/10) +WFF--XFF---YFF--ZFF, n;
	W	=> YFF++ZFF----XFF[-YFF----WFF]++;
	X	=> +YFF--ZFF[---WFF--XFF]+;
	Y	=> -WFF++XFF[+++YFF++ZFF]-;
	Z	=> --YFF++++WFF[+ZFF++++XFF]--XFF;
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's kites and darts

	Kites_and_darts(n)	=> attr (delta, 360/10) Wf+Xf+Wf+Xf+Wf+Xf+Wf+Xf+Wf+X, n;
	W	=> [F][++ attr (distance, distance*01.618033989) F][++f--- attr (distance, distance*0.618033989) f|X-Y|f|W];
	X	=> [F+++ attr (distance, distance*01.618033989) F][++ attr (distance, distance*0.618033989) fZ|X|-f|W];
	Y	=> [+F][ attr (distance, distance*01.618033989) F][+f attr (distance, distance*0.618033989) |Y+X];
	Z	=> [-F][ attr (distance, distance*01.618033989) F][ attr (distance, distance*0.618033989) f--Wf|+Z];
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// Roger Penrose's kites and darts

	Kites_and_darts_color(n)	=> attr (delta, 360/10) Wf+Xf+Wf+Xf+Wf+Xf+Wf+Xf+Wf+X, n;
	W	=> [F][++ attr (distance, distance*01.618033989) F][++f--- attr (distance, distance*0.618033989) f|X-Y|f|W];
	X	=> [F+++ attr (distance, distance*01.618033989) F][++ attr (distance, distance*0.618033989) fZ|X|-f|W];
	Y	=> [+F][ attr (distance, distance*01.618033989) F][+f attr (distance, distance*0.618033989) |Y+X];
	Z	=> [-F][ attr (distance, distance*01.618033989) F][ attr (distance, distance*0.618033989) f--Wf|+Z];
	F	=> ;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers"

	Spiral_tile(n)	=> attr (delta, 360/16) X++X++X++X++|f|X++X++X++X, n;
	X	=> [FX+++++ attr (distance, distance*0.7653668647) F attr (distance, distance/0.7653668647) [-----Y]+++++F];
	Y	=> [F+++++ attr (distance, distance*0.7653668647) F attr (distance, distance/0.7653668647) [-----Y]+++++F];
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// A spiral tiling by Heinz Voderberg

	Voderberg_tile(n)	=> attr (delta, 360/30)  -(84.1) A -(96) attr (distance, distance*04.783386117) f attr (distance, distance/04.783386117) +(96) A, n;
	A	=> X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) Z;
	X	=> [F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F -(114) [ -(168) X -(24) Y]F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F +(78) F];
	Y	=> [F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F +(78) F -(168) [ -(192) Y]F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F];
	Z	=> [F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F -(114) F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F +(78) F];
)

	// These two aren't tilings but simple spiral patterns done by my 12 year old
	// son Morgan that really need the warning from "Fractal Creations" about
	// color cycling introducing hypnotic states.

ruleset (	// by Morgan Savage
	// Try order 13 and color cycle in both 256 and 16 color modes

	Vertigo(n)	=> attr (delta, 360/46) X, n;
	X	=> XF+ attr (distance, distance*0.9997) X;
)

ruleset (	// by Morgan Savage
	// Try order 13 and color cycle in both 256 and 16 color modes

	Vertigo1(n)	=> attr (delta, 360/49) X, n;
	X	=> XF+ attr (distance, distance*0.9997) X;
)

