/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import javax.annotation.Nullable;
import org.lwjgl.openvr.HmdVector3;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct RenderModel_Vertex_t")
public class RenderModelVertex
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VPOSITION;
    public static final int VNORMAL;
    public static final int RFTEXTURECOORD;

    public RenderModelVertex(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), RenderModelVertex.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vPosition() {
        return RenderModelVertex.nvPosition(this.address());
    }

    @NativeType(value="HmdVector3_t")
    public HmdVector3 vNormal() {
        return RenderModelVertex.nvNormal(this.address());
    }

    @NativeType(value="float[2]")
    public FloatBuffer rfTextureCoord() {
        return RenderModelVertex.nrfTextureCoord(this.address());
    }

    public float rfTextureCoord(int index) {
        return RenderModelVertex.nrfTextureCoord(this.address(), index);
    }

    public static RenderModelVertex create(long address) {
        return (RenderModelVertex)RenderModelVertex.wrap(RenderModelVertex.class, (long)address);
    }

    @Nullable
    public static RenderModelVertex createSafe(long address) {
        return address == 0L ? null : (RenderModelVertex)RenderModelVertex.wrap(RenderModelVertex.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)RenderModelVertex.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)RenderModelVertex.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static HmdVector3 nvPosition(long struct) {
        return HmdVector3.create(struct + (long)VPOSITION);
    }

    public static HmdVector3 nvNormal(long struct) {
        return HmdVector3.create(struct + (long)VNORMAL);
    }

    public static FloatBuffer nrfTextureCoord(long struct) {
        return MemoryUtil.memFloatBuffer((long)(struct + (long)RFTEXTURECOORD), (int)2);
    }

    public static float nrfTextureCoord(long struct, int index) {
        return UNSAFE.getFloat(null, struct + (long)RFTEXTURECOORD + Checks.check((int)index, (int)2) * 4L);
    }

    static {
        Struct.Layout layout = RenderModelVertex.__struct((Struct.Member[])new Struct.Member[]{RenderModelVertex.__member((int)HmdVector3.SIZEOF, (int)HmdVector3.ALIGNOF), RenderModelVertex.__member((int)HmdVector3.SIZEOF, (int)HmdVector3.ALIGNOF), RenderModelVertex.__array((int)4, (int)2)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VPOSITION = layout.offsetof(0);
        VNORMAL = layout.offsetof(1);
        RFTEXTURECOORD = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<RenderModelVertex, Buffer> {
        private static final RenderModelVertex ELEMENT_FACTORY = RenderModelVertex.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected RenderModelVertex getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vPosition() {
            return RenderModelVertex.nvPosition(this.address());
        }

        @NativeType(value="HmdVector3_t")
        public HmdVector3 vNormal() {
            return RenderModelVertex.nvNormal(this.address());
        }

        @NativeType(value="float[2]")
        public FloatBuffer rfTextureCoord() {
            return RenderModelVertex.nrfTextureCoord(this.address());
        }

        public float rfTextureCoord(int index) {
            return RenderModelVertex.nrfTextureCoord(this.address(), index);
        }
    }
}

