/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.llvm.CXIdxDeclInfo;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXIdxObjCContainerDeclInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DECLINFO;
    public static final int KIND;

    public CXIdxObjCContainerDeclInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXIdxObjCContainerDeclInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CXIdxDeclInfo const *")
    public CXIdxDeclInfo declInfo() {
        return CXIdxObjCContainerDeclInfo.ndeclInfo(this.address());
    }

    @NativeType(value="CXIdxObjCContainerKind")
    public int kind() {
        return CXIdxObjCContainerDeclInfo.nkind(this.address());
    }

    public static CXIdxObjCContainerDeclInfo create(long address) {
        return (CXIdxObjCContainerDeclInfo)CXIdxObjCContainerDeclInfo.wrap(CXIdxObjCContainerDeclInfo.class, (long)address);
    }

    @Nullable
    public static CXIdxObjCContainerDeclInfo createSafe(long address) {
        return address == 0L ? null : (CXIdxObjCContainerDeclInfo)CXIdxObjCContainerDeclInfo.wrap(CXIdxObjCContainerDeclInfo.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CXIdxObjCContainerDeclInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CXIdxObjCContainerDeclInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CXIdxDeclInfo ndeclInfo(long struct) {
        return CXIdxDeclInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)DECLINFO)));
    }

    public static int nkind(long struct) {
        return UNSAFE.getInt(null, struct + (long)KIND);
    }

    static {
        Struct.Layout layout = CXIdxObjCContainerDeclInfo.__struct((Struct.Member[])new Struct.Member[]{CXIdxObjCContainerDeclInfo.__member((int)POINTER_SIZE), CXIdxObjCContainerDeclInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DECLINFO = layout.offsetof(0);
        KIND = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXIdxObjCContainerDeclInfo, Buffer> {
        private static final CXIdxObjCContainerDeclInfo ELEMENT_FACTORY = CXIdxObjCContainerDeclInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXIdxObjCContainerDeclInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CXIdxDeclInfo const *")
        public CXIdxDeclInfo declInfo() {
            return CXIdxObjCContainerDeclInfo.ndeclInfo(this.address());
        }

        @NativeType(value="CXIdxObjCContainerKind")
        public int kind() {
            return CXIdxObjCContainerDeclInfo.nkind(this.address());
        }
    }
}

