/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.vma;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.util.vma.VmaDefragmentationPassMoveInfo;

public class VmaDefragmentationPassInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MOVECOUNT;
    public static final int PMOVES;

    public VmaDefragmentationPassInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VmaDefragmentationPassInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int moveCount() {
        return VmaDefragmentationPassInfo.nmoveCount(this.address());
    }

    @NativeType(value="VmaDefragmentationPassMoveInfo *")
    public VmaDefragmentationPassMoveInfo.Buffer pMoves() {
        return VmaDefragmentationPassInfo.npMoves(this.address());
    }

    public static VmaDefragmentationPassInfo malloc() {
        return (VmaDefragmentationPassInfo)VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VmaDefragmentationPassInfo calloc() {
        return (VmaDefragmentationPassInfo)VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VmaDefragmentationPassInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VmaDefragmentationPassInfo)VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VmaDefragmentationPassInfo create(long address) {
        return (VmaDefragmentationPassInfo)VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, (long)address);
    }

    @Nullable
    public static VmaDefragmentationPassInfo createSafe(long address) {
        return address == 0L ? null : (VmaDefragmentationPassInfo)VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VmaDefragmentationPassInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VmaDefragmentationPassInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VmaDefragmentationPassInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VmaDefragmentationPassInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VmaDefragmentationPassInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VmaDefragmentationPassInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VmaDefragmentationPassInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VmaDefragmentationPassInfo malloc(MemoryStack stack) {
        return (VmaDefragmentationPassInfo)VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VmaDefragmentationPassInfo calloc(MemoryStack stack) {
        return (VmaDefragmentationPassInfo)VmaDefragmentationPassInfo.wrap(VmaDefragmentationPassInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaDefragmentationPassInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VmaDefragmentationPassInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nmoveCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)MOVECOUNT);
    }

    public static VmaDefragmentationPassMoveInfo.Buffer npMoves(long struct) {
        return VmaDefragmentationPassMoveInfo.create(MemoryUtil.memGetAddress((long)(struct + (long)PMOVES)), VmaDefragmentationPassInfo.nmoveCount(struct));
    }

    static {
        Struct.Layout layout = VmaDefragmentationPassInfo.__struct((Struct.Member[])new Struct.Member[]{VmaDefragmentationPassInfo.__member((int)4), VmaDefragmentationPassInfo.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MOVECOUNT = layout.offsetof(0);
        PMOVES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VmaDefragmentationPassInfo, Buffer>
    implements NativeResource {
        private static final VmaDefragmentationPassInfo ELEMENT_FACTORY = VmaDefragmentationPassInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VmaDefragmentationPassInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int moveCount() {
            return VmaDefragmentationPassInfo.nmoveCount(this.address());
        }

        @NativeType(value="VmaDefragmentationPassMoveInfo *")
        public VmaDefragmentationPassMoveInfo.Buffer pMoves() {
            return VmaDefragmentationPassInfo.npMoves(this.address());
        }
    }
}

