/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkOffset2D;
import org.lwjgl.vulkan.VkVideoDecodeH264PictureInfoEXT;
import org.lwjgl.vulkan.VkVideoDecodeH265PictureInfoEXT;
import org.lwjgl.vulkan.VkVideoPictureResourceKHR;
import org.lwjgl.vulkan.VkVideoReferenceSlotKHR;

public class VkVideoDecodeInfoKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int CODEDOFFSET;
    public static final int CODEDEXTENT;
    public static final int SRCBUFFER;
    public static final int SRCBUFFEROFFSET;
    public static final int SRCBUFFERRANGE;
    public static final int DSTPICTURERESOURCE;
    public static final int PSETUPREFERENCESLOT;
    public static final int REFERENCESLOTCOUNT;
    public static final int PREFERENCESLOTS;

    public VkVideoDecodeInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkVideoDecodeInfoKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoDecodeInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoDecodeInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoDecodeFlagsKHR")
    public int flags() {
        return VkVideoDecodeInfoKHR.nflags(this.address());
    }

    public VkOffset2D codedOffset() {
        return VkVideoDecodeInfoKHR.ncodedOffset(this.address());
    }

    public VkExtent2D codedExtent() {
        return VkVideoDecodeInfoKHR.ncodedExtent(this.address());
    }

    @NativeType(value="VkBuffer")
    public long srcBuffer() {
        return VkVideoDecodeInfoKHR.nsrcBuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long srcBufferOffset() {
        return VkVideoDecodeInfoKHR.nsrcBufferOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long srcBufferRange() {
        return VkVideoDecodeInfoKHR.nsrcBufferRange(this.address());
    }

    public VkVideoPictureResourceKHR dstPictureResource() {
        return VkVideoDecodeInfoKHR.ndstPictureResource(this.address());
    }

    @NativeType(value="VkVideoReferenceSlotKHR const *")
    public VkVideoReferenceSlotKHR pSetupReferenceSlot() {
        return VkVideoDecodeInfoKHR.npSetupReferenceSlot(this.address());
    }

    @NativeType(value="uint32_t")
    public int referenceSlotCount() {
        return VkVideoDecodeInfoKHR.nreferenceSlotCount(this.address());
    }

    @Nullable
    @NativeType(value="VkVideoReferenceSlotKHR const *")
    public VkVideoReferenceSlotKHR.Buffer pReferenceSlots() {
        return VkVideoDecodeInfoKHR.npReferenceSlots(this.address());
    }

    public VkVideoDecodeInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoDecodeInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR sType$Default() {
        return this.sType(1000024000);
    }

    public VkVideoDecodeInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoDecodeInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR pNext(VkVideoDecodeH264PictureInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoDecodeInfoKHR pNext(VkVideoDecodeH265PictureInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoDecodeInfoKHR flags(@NativeType(value="VkVideoDecodeFlagsKHR") int value) {
        VkVideoDecodeInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR codedOffset(VkOffset2D value) {
        VkVideoDecodeInfoKHR.ncodedOffset(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR codedOffset(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.codedOffset());
        return this;
    }

    public VkVideoDecodeInfoKHR codedExtent(VkExtent2D value) {
        VkVideoDecodeInfoKHR.ncodedExtent(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR codedExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.codedExtent());
        return this;
    }

    public VkVideoDecodeInfoKHR srcBuffer(@NativeType(value="VkBuffer") long value) {
        VkVideoDecodeInfoKHR.nsrcBuffer(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR srcBufferOffset(@NativeType(value="VkDeviceSize") long value) {
        VkVideoDecodeInfoKHR.nsrcBufferOffset(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR srcBufferRange(@NativeType(value="VkDeviceSize") long value) {
        VkVideoDecodeInfoKHR.nsrcBufferRange(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR dstPictureResource(VkVideoPictureResourceKHR value) {
        VkVideoDecodeInfoKHR.ndstPictureResource(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR dstPictureResource(Consumer<VkVideoPictureResourceKHR> consumer) {
        consumer.accept(this.dstPictureResource());
        return this;
    }

    public VkVideoDecodeInfoKHR pSetupReferenceSlot(@NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR value) {
        VkVideoDecodeInfoKHR.npSetupReferenceSlot(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR pReferenceSlots(@Nullable @NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR.Buffer value) {
        VkVideoDecodeInfoKHR.npReferenceSlots(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR set(int sType, long pNext, int flags, VkOffset2D codedOffset, VkExtent2D codedExtent, long srcBuffer, long srcBufferOffset, long srcBufferRange, VkVideoPictureResourceKHR dstPictureResource, VkVideoReferenceSlotKHR pSetupReferenceSlot, @Nullable VkVideoReferenceSlotKHR.Buffer pReferenceSlots) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.codedOffset(codedOffset);
        this.codedExtent(codedExtent);
        this.srcBuffer(srcBuffer);
        this.srcBufferOffset(srcBufferOffset);
        this.srcBufferRange(srcBufferRange);
        this.dstPictureResource(dstPictureResource);
        this.pSetupReferenceSlot(pSetupReferenceSlot);
        this.pReferenceSlots(pReferenceSlots);
        return this;
    }

    public VkVideoDecodeInfoKHR set(VkVideoDecodeInfoKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkVideoDecodeInfoKHR malloc() {
        return (VkVideoDecodeInfoKHR)VkVideoDecodeInfoKHR.wrap(VkVideoDecodeInfoKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkVideoDecodeInfoKHR calloc() {
        return (VkVideoDecodeInfoKHR)VkVideoDecodeInfoKHR.wrap(VkVideoDecodeInfoKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkVideoDecodeInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkVideoDecodeInfoKHR)VkVideoDecodeInfoKHR.wrap(VkVideoDecodeInfoKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkVideoDecodeInfoKHR create(long address) {
        return (VkVideoDecodeInfoKHR)VkVideoDecodeInfoKHR.wrap(VkVideoDecodeInfoKHR.class, (long)address);
    }

    @Nullable
    public static VkVideoDecodeInfoKHR createSafe(long address) {
        return address == 0L ? null : (VkVideoDecodeInfoKHR)VkVideoDecodeInfoKHR.wrap(VkVideoDecodeInfoKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkVideoDecodeInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkVideoDecodeInfoKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkVideoDecodeInfoKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoDecodeInfoKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkVideoDecodeInfoKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkVideoDecodeInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkVideoDecodeInfoKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkVideoDecodeInfoKHR malloc(MemoryStack stack) {
        return (VkVideoDecodeInfoKHR)VkVideoDecodeInfoKHR.wrap(VkVideoDecodeInfoKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkVideoDecodeInfoKHR calloc(MemoryStack stack) {
        return (VkVideoDecodeInfoKHR)VkVideoDecodeInfoKHR.wrap(VkVideoDecodeInfoKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkVideoDecodeInfoKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkVideoDecodeInfoKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static VkOffset2D ncodedOffset(long struct) {
        return VkOffset2D.create(struct + (long)CODEDOFFSET);
    }

    public static VkExtent2D ncodedExtent(long struct) {
        return VkExtent2D.create(struct + (long)CODEDEXTENT);
    }

    public static long nsrcBuffer(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCBUFFER);
    }

    public static long nsrcBufferOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCBUFFEROFFSET);
    }

    public static long nsrcBufferRange(long struct) {
        return UNSAFE.getLong(null, struct + (long)SRCBUFFERRANGE);
    }

    public static VkVideoPictureResourceKHR ndstPictureResource(long struct) {
        return VkVideoPictureResourceKHR.create(struct + (long)DSTPICTURERESOURCE);
    }

    public static VkVideoReferenceSlotKHR npSetupReferenceSlot(long struct) {
        return VkVideoReferenceSlotKHR.create(MemoryUtil.memGetAddress((long)(struct + (long)PSETUPREFERENCESLOT)));
    }

    public static int nreferenceSlotCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFERENCESLOTCOUNT);
    }

    @Nullable
    public static VkVideoReferenceSlotKHR.Buffer npReferenceSlots(long struct) {
        return VkVideoReferenceSlotKHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PREFERENCESLOTS)), VkVideoDecodeInfoKHR.nreferenceSlotCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ncodedOffset(long struct, VkOffset2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CODEDOFFSET), (long)VkOffset2D.SIZEOF);
    }

    public static void ncodedExtent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CODEDEXTENT), (long)VkExtent2D.SIZEOF);
    }

    public static void nsrcBuffer(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCBUFFER, value);
    }

    public static void nsrcBufferOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCBUFFEROFFSET, value);
    }

    public static void nsrcBufferRange(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SRCBUFFERRANGE, value);
    }

    public static void ndstPictureResource(long struct, VkVideoPictureResourceKHR value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)DSTPICTURERESOURCE), (long)VkVideoPictureResourceKHR.SIZEOF);
    }

    public static void npSetupReferenceSlot(long struct, VkVideoReferenceSlotKHR value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PSETUPREFERENCESLOT), (long)value.address());
    }

    public static void nreferenceSlotCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFERENCESLOTCOUNT, value);
    }

    public static void npReferenceSlots(long struct, @Nullable VkVideoReferenceSlotKHR.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PREFERENCESLOTS), (long)MemoryUtil.memAddressSafe((Pointer)value));
        VkVideoDecodeInfoKHR.nreferenceSlotCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        long pSetupReferenceSlot = MemoryUtil.memGetAddress((long)(struct + (long)PSETUPREFERENCESLOT));
        Checks.check((long)pSetupReferenceSlot);
        VkVideoReferenceSlotKHR.validate(pSetupReferenceSlot);
        int referenceSlotCount = VkVideoDecodeInfoKHR.nreferenceSlotCount(struct);
        if (referenceSlotCount != 0) {
            long pReferenceSlots = MemoryUtil.memGetAddress((long)(struct + (long)PREFERENCESLOTS));
            Checks.check((long)pReferenceSlots);
            VkVideoDecodeInfoKHR.validate((long)pReferenceSlots, (int)referenceSlotCount, (int)VkVideoReferenceSlotKHR.SIZEOF, VkVideoReferenceSlotKHR::validate);
        }
    }

    static {
        Struct.Layout layout = VkVideoDecodeInfoKHR.__struct((Struct.Member[])new Struct.Member[]{VkVideoDecodeInfoKHR.__member((int)4), VkVideoDecodeInfoKHR.__member((int)POINTER_SIZE), VkVideoDecodeInfoKHR.__member((int)4), VkVideoDecodeInfoKHR.__member((int)VkOffset2D.SIZEOF, (int)VkOffset2D.ALIGNOF), VkVideoDecodeInfoKHR.__member((int)VkExtent2D.SIZEOF, (int)VkExtent2D.ALIGNOF), VkVideoDecodeInfoKHR.__member((int)8), VkVideoDecodeInfoKHR.__member((int)8), VkVideoDecodeInfoKHR.__member((int)8), VkVideoDecodeInfoKHR.__member((int)VkVideoPictureResourceKHR.SIZEOF, (int)VkVideoPictureResourceKHR.ALIGNOF), VkVideoDecodeInfoKHR.__member((int)POINTER_SIZE), VkVideoDecodeInfoKHR.__member((int)4), VkVideoDecodeInfoKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        CODEDOFFSET = layout.offsetof(3);
        CODEDEXTENT = layout.offsetof(4);
        SRCBUFFER = layout.offsetof(5);
        SRCBUFFEROFFSET = layout.offsetof(6);
        SRCBUFFERRANGE = layout.offsetof(7);
        DSTPICTURERESOURCE = layout.offsetof(8);
        PSETUPREFERENCESLOT = layout.offsetof(9);
        REFERENCESLOTCOUNT = layout.offsetof(10);
        PREFERENCESLOTS = layout.offsetof(11);
    }

    public static class Buffer
    extends StructBuffer<VkVideoDecodeInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoDecodeInfoKHR ELEMENT_FACTORY = VkVideoDecodeInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkVideoDecodeInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoDecodeInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoDecodeInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoDecodeFlagsKHR")
        public int flags() {
            return VkVideoDecodeInfoKHR.nflags(this.address());
        }

        public VkOffset2D codedOffset() {
            return VkVideoDecodeInfoKHR.ncodedOffset(this.address());
        }

        public VkExtent2D codedExtent() {
            return VkVideoDecodeInfoKHR.ncodedExtent(this.address());
        }

        @NativeType(value="VkBuffer")
        public long srcBuffer() {
            return VkVideoDecodeInfoKHR.nsrcBuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long srcBufferOffset() {
            return VkVideoDecodeInfoKHR.nsrcBufferOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long srcBufferRange() {
            return VkVideoDecodeInfoKHR.nsrcBufferRange(this.address());
        }

        public VkVideoPictureResourceKHR dstPictureResource() {
            return VkVideoDecodeInfoKHR.ndstPictureResource(this.address());
        }

        @NativeType(value="VkVideoReferenceSlotKHR const *")
        public VkVideoReferenceSlotKHR pSetupReferenceSlot() {
            return VkVideoDecodeInfoKHR.npSetupReferenceSlot(this.address());
        }

        @NativeType(value="uint32_t")
        public int referenceSlotCount() {
            return VkVideoDecodeInfoKHR.nreferenceSlotCount(this.address());
        }

        @Nullable
        @NativeType(value="VkVideoReferenceSlotKHR const *")
        public VkVideoReferenceSlotKHR.Buffer pReferenceSlots() {
            return VkVideoDecodeInfoKHR.npReferenceSlots(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoDecodeInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000024000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoDecodeInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoDecodeH264PictureInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH265PictureInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkVideoDecodeFlagsKHR") int value) {
            VkVideoDecodeInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer codedOffset(VkOffset2D value) {
            VkVideoDecodeInfoKHR.ncodedOffset(this.address(), value);
            return this;
        }

        public Buffer codedOffset(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.codedOffset());
            return this;
        }

        public Buffer codedExtent(VkExtent2D value) {
            VkVideoDecodeInfoKHR.ncodedExtent(this.address(), value);
            return this;
        }

        public Buffer codedExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.codedExtent());
            return this;
        }

        public Buffer srcBuffer(@NativeType(value="VkBuffer") long value) {
            VkVideoDecodeInfoKHR.nsrcBuffer(this.address(), value);
            return this;
        }

        public Buffer srcBufferOffset(@NativeType(value="VkDeviceSize") long value) {
            VkVideoDecodeInfoKHR.nsrcBufferOffset(this.address(), value);
            return this;
        }

        public Buffer srcBufferRange(@NativeType(value="VkDeviceSize") long value) {
            VkVideoDecodeInfoKHR.nsrcBufferRange(this.address(), value);
            return this;
        }

        public Buffer dstPictureResource(VkVideoPictureResourceKHR value) {
            VkVideoDecodeInfoKHR.ndstPictureResource(this.address(), value);
            return this;
        }

        public Buffer dstPictureResource(Consumer<VkVideoPictureResourceKHR> consumer) {
            consumer.accept(this.dstPictureResource());
            return this;
        }

        public Buffer pSetupReferenceSlot(@NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR value) {
            VkVideoDecodeInfoKHR.npSetupReferenceSlot(this.address(), value);
            return this;
        }

        public Buffer pReferenceSlots(@Nullable @NativeType(value="VkVideoReferenceSlotKHR const *") VkVideoReferenceSlotKHR.Buffer value) {
            VkVideoDecodeInfoKHR.npReferenceSlots(this.address(), value);
            return this;
        }
    }
}

