/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrApiLayerProperties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int NEXT;
    public static final int LAYERNAME;
    public static final int SPECVERSION;
    public static final int LAYERVERSION;
    public static final int DESCRIPTION;

    public XrApiLayerProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrApiLayerProperties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrStructureType")
    public int type() {
        return XrApiLayerProperties.ntype(this.address());
    }

    @NativeType(value="void *")
    public long next() {
        return XrApiLayerProperties.nnext(this.address());
    }

    @NativeType(value="char[XR_MAX_API_LAYER_NAME_SIZE]")
    public ByteBuffer layerName() {
        return XrApiLayerProperties.nlayerName(this.address());
    }

    @NativeType(value="char[XR_MAX_API_LAYER_NAME_SIZE]")
    public String layerNameString() {
        return XrApiLayerProperties.nlayerNameString(this.address());
    }

    @NativeType(value="XrVersion")
    public long specVersion() {
        return XrApiLayerProperties.nspecVersion(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerVersion() {
        return XrApiLayerProperties.nlayerVersion(this.address());
    }

    @NativeType(value="char[XR_MAX_API_LAYER_DESCRIPTION_SIZE]")
    public ByteBuffer description() {
        return XrApiLayerProperties.ndescription(this.address());
    }

    @NativeType(value="char[XR_MAX_API_LAYER_DESCRIPTION_SIZE]")
    public String descriptionString() {
        return XrApiLayerProperties.ndescriptionString(this.address());
    }

    public XrApiLayerProperties type(@NativeType(value="XrStructureType") int value) {
        XrApiLayerProperties.ntype(this.address(), value);
        return this;
    }

    public XrApiLayerProperties type$Default() {
        return this.type(1);
    }

    public XrApiLayerProperties next(@NativeType(value="void *") long value) {
        XrApiLayerProperties.nnext(this.address(), value);
        return this;
    }

    public XrApiLayerProperties set(int type, long next) {
        this.type(type);
        this.next(next);
        return this;
    }

    public XrApiLayerProperties set(XrApiLayerProperties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrApiLayerProperties malloc() {
        return (XrApiLayerProperties)XrApiLayerProperties.wrap(XrApiLayerProperties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrApiLayerProperties calloc() {
        return (XrApiLayerProperties)XrApiLayerProperties.wrap(XrApiLayerProperties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrApiLayerProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrApiLayerProperties)XrApiLayerProperties.wrap(XrApiLayerProperties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrApiLayerProperties create(long address) {
        return (XrApiLayerProperties)XrApiLayerProperties.wrap(XrApiLayerProperties.class, (long)address);
    }

    @Nullable
    public static XrApiLayerProperties createSafe(long address) {
        return address == 0L ? null : (XrApiLayerProperties)XrApiLayerProperties.wrap(XrApiLayerProperties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrApiLayerProperties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrApiLayerProperties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrApiLayerProperties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrApiLayerProperties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrApiLayerProperties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrApiLayerProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrApiLayerProperties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrApiLayerProperties malloc(MemoryStack stack) {
        return (XrApiLayerProperties)XrApiLayerProperties.wrap(XrApiLayerProperties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrApiLayerProperties calloc(MemoryStack stack) {
        return (XrApiLayerProperties)XrApiLayerProperties.wrap(XrApiLayerProperties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrApiLayerProperties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrApiLayerProperties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static long nnext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NEXT));
    }

    public static ByteBuffer nlayerName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)LAYERNAME), (int)256);
    }

    public static String nlayerNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)LAYERNAME));
    }

    public static long nspecVersion(long struct) {
        return UNSAFE.getLong(null, struct + (long)SPECVERSION);
    }

    public static int nlayerVersion(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERVERSION);
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DESCRIPTION), (int)256);
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)DESCRIPTION));
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nnext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)value);
    }

    static {
        Struct.Layout layout = XrApiLayerProperties.__struct((Struct.Member[])new Struct.Member[]{XrApiLayerProperties.__member((int)4), XrApiLayerProperties.__member((int)POINTER_SIZE), XrApiLayerProperties.__array((int)1, (int)256), XrApiLayerProperties.__member((int)8), XrApiLayerProperties.__member((int)4), XrApiLayerProperties.__array((int)1, (int)256)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        NEXT = layout.offsetof(1);
        LAYERNAME = layout.offsetof(2);
        SPECVERSION = layout.offsetof(3);
        LAYERVERSION = layout.offsetof(4);
        DESCRIPTION = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XrApiLayerProperties, Buffer>
    implements NativeResource {
        private static final XrApiLayerProperties ELEMENT_FACTORY = XrApiLayerProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrApiLayerProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrStructureType")
        public int type() {
            return XrApiLayerProperties.ntype(this.address());
        }

        @NativeType(value="void *")
        public long next() {
            return XrApiLayerProperties.nnext(this.address());
        }

        @NativeType(value="char[XR_MAX_API_LAYER_NAME_SIZE]")
        public ByteBuffer layerName() {
            return XrApiLayerProperties.nlayerName(this.address());
        }

        @NativeType(value="char[XR_MAX_API_LAYER_NAME_SIZE]")
        public String layerNameString() {
            return XrApiLayerProperties.nlayerNameString(this.address());
        }

        @NativeType(value="XrVersion")
        public long specVersion() {
            return XrApiLayerProperties.nspecVersion(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerVersion() {
            return XrApiLayerProperties.nlayerVersion(this.address());
        }

        @NativeType(value="char[XR_MAX_API_LAYER_DESCRIPTION_SIZE]")
        public ByteBuffer description() {
            return XrApiLayerProperties.ndescription(this.address());
        }

        @NativeType(value="char[XR_MAX_API_LAYER_DESCRIPTION_SIZE]")
        public String descriptionString() {
            return XrApiLayerProperties.ndescriptionString(this.address());
        }

        public Buffer type(@NativeType(value="XrStructureType") int value) {
            XrApiLayerProperties.ntype(this.address(), value);
            return this;
        }

        public Buffer type$Default() {
            return this.type(1);
        }

        public Buffer next(@NativeType(value="void *") long value) {
            XrApiLayerProperties.nnext(this.address(), value);
            return this;
        }
    }
}

