/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrUuidMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BYTES;

    public XrUuidMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrUuidMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t[16]")
    public ByteBuffer bytes() {
        return XrUuidMSFT.nbytes(this.address());
    }

    @NativeType(value="uint8_t")
    public byte bytes(int index) {
        return XrUuidMSFT.nbytes(this.address(), index);
    }

    public XrUuidMSFT bytes(@NativeType(value="uint8_t[16]") ByteBuffer value) {
        XrUuidMSFT.nbytes(this.address(), value);
        return this;
    }

    public XrUuidMSFT bytes(int index, @NativeType(value="uint8_t") byte value) {
        XrUuidMSFT.nbytes(this.address(), index, value);
        return this;
    }

    public XrUuidMSFT set(XrUuidMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrUuidMSFT malloc() {
        return (XrUuidMSFT)XrUuidMSFT.wrap(XrUuidMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrUuidMSFT calloc() {
        return (XrUuidMSFT)XrUuidMSFT.wrap(XrUuidMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrUuidMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrUuidMSFT)XrUuidMSFT.wrap(XrUuidMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrUuidMSFT create(long address) {
        return (XrUuidMSFT)XrUuidMSFT.wrap(XrUuidMSFT.class, (long)address);
    }

    @Nullable
    public static XrUuidMSFT createSafe(long address) {
        return address == 0L ? null : (XrUuidMSFT)XrUuidMSFT.wrap(XrUuidMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrUuidMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrUuidMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrUuidMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrUuidMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrUuidMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrUuidMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrUuidMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrUuidMSFT malloc(MemoryStack stack) {
        return (XrUuidMSFT)XrUuidMSFT.wrap(XrUuidMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrUuidMSFT calloc(MemoryStack stack) {
        return (XrUuidMSFT)XrUuidMSFT.wrap(XrUuidMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrUuidMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrUuidMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nbytes(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)BYTES), (int)16);
    }

    public static byte nbytes(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)BYTES + Checks.check((int)index, (int)16) * 1L);
    }

    public static void nbytes(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)16);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)BYTES), (long)(value.remaining() * 1));
    }

    public static void nbytes(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)BYTES + Checks.check((int)index, (int)16) * 1L, value);
    }

    static {
        Struct.Layout layout = XrUuidMSFT.__struct((Struct.Member[])new Struct.Member[]{XrUuidMSFT.__array((int)1, (int)16)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BYTES = layout.offsetof(0);
    }

    public static class Buffer
    extends StructBuffer<XrUuidMSFT, Buffer>
    implements NativeResource {
        private static final XrUuidMSFT ELEMENT_FACTORY = XrUuidMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrUuidMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t[16]")
        public ByteBuffer bytes() {
            return XrUuidMSFT.nbytes(this.address());
        }

        @NativeType(value="uint8_t")
        public byte bytes(int index) {
            return XrUuidMSFT.nbytes(this.address(), index);
        }

        public Buffer bytes(@NativeType(value="uint8_t[16]") ByteBuffer value) {
            XrUuidMSFT.nbytes(this.address(), value);
            return this;
        }

        public Buffer bytes(int index, @NativeType(value="uint8_t") byte value) {
            XrUuidMSFT.nbytes(this.address(), index, value);
            return this;
        }
    }
}

