/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.jsmpp.PDUStringException;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;

public class RandomMessageIDGenerator
implements MessageIDGenerator {
    private Random random;

    public RandomMessageIDGenerator() {
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.random = new Random();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageId newMessageId() {
        try {
            Random random = this.random;
            synchronized (random) {
                return new MessageId(Integer.toString(this.random.nextInt(Integer.MAX_VALUE), 16));
            }
        }
        catch (PDUStringException e) {
            throw new RuntimeException("Failed creating message id", e);
        }
    }
}

