/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec4(165ul, 133ul, 193ul, 76ul) << 0u) => u64vec4(165ul, 133ul, 193ul, 76ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) << 1u) => u64vec4(330ul, 266ul, 386ul, 152ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) << 2u) => u64vec4(660ul, 532ul, 772ul, 304ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) << 5u) => u64vec4(5280ul, 4256ul, 6176ul, 2432ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) << 25u) => u64vec4(5536481280ul, 4462739456ul, 6476005376ul, 2550136832ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) << 31u) => u64vec4(354334801920ul, 285615325184ul, 414464344064ul, 163208757248ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) << 0u) => u64vec4(80ul, 15ul, 51ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) << 1u) => u64vec4(160ul, 30ul, 102ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) << 2u) => u64vec4(320ul, 60ul, 204ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) << 5u) => u64vec4(2560ul, 480ul, 1632ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) << 25u) => u64vec4(2684354560ul, 503316480ul, 1711276032ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) << 31u) => u64vec4(171798691840ul, 32212254720ul, 109521666048ul, 0ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) << 0u), u64vec4(165ul, 133ul, 193ul, 76ul))) ? 1 : -1] array0;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) << 1u), u64vec4(330ul, 266ul, 386ul, 152ul))) ? 1 : -1] array1;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) << 2u), u64vec4(660ul, 532ul, 772ul, 304ul))) ? 1 : -1] array2;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) << 5u), u64vec4(5280ul, 4256ul, 6176ul, 2432ul))) ? 1 : -1] array3;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) << 25u), u64vec4(5536481280ul, 4462739456ul, 6476005376ul, 2550136832ul))) ? 1 : -1] array4;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) << 31u), u64vec4(354334801920ul, 285615325184ul, 414464344064ul, 163208757248ul))) ? 1 : -1] array5;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) << 0u), u64vec4(80ul, 15ul, 51ul, 0ul))) ? 1 : -1] array6;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) << 1u), u64vec4(160ul, 30ul, 102ul, 0ul))) ? 1 : -1] array7;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) << 2u), u64vec4(320ul, 60ul, 204ul, 0ul))) ? 1 : -1] array8;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) << 5u), u64vec4(2560ul, 480ul, 1632ul, 0ul))) ? 1 : -1] array9;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) << 25u), u64vec4(2684354560ul, 503316480ul, 1711276032ul, 0ul))) ? 1 : -1] array10;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) << 31u), u64vec4(171798691840ul, 32212254720ul, 109521666048ul, 0ul))) ? 1 : -1] array11;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length());
}
