/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (0ul << 0u) => 0ul
 * (0ul << 1u) => 0ul
 * (0ul << 2u) => 0ul
 * (0ul << 5u) => 0ul
 * (0ul << 25u) => 0ul
 * (0ul << 31u) => 0ul
 * (3ul << 0u) => 3ul
 * (3ul << 1u) => 6ul
 * (3ul << 2u) => 12ul
 * (3ul << 5u) => 96ul
 * (3ul << 25u) => 100663296ul
 * (3ul << 31u) => 6442450944ul
 * (1192ul << 0u) => 1192ul
 * (1192ul << 1u) => 2384ul
 * (1192ul << 2u) => 4768ul
 * (1192ul << 5u) => 38144ul
 * (1192ul << 25u) => 39996882944ul
 * (1192ul << 31u) => 2559800508416ul
 * (1048576ul << 0u) => 1048576ul
 * (1048576ul << 1u) => 2097152ul
 * (1048576ul << 2u) => 4194304ul
 * (1048576ul << 5u) => 33554432ul
 * (1048576ul << 25u) => 35184372088832ul
 * (1048576ul << 31u) => 2251799813685248ul
 * (4251475ul << 0u) => 4251475ul
 * (4251475ul << 1u) => 8502950ul
 * (4251475ul << 2u) => 17005900ul
 * (4251475ul << 5u) => 136047200ul
 * (4251475ul << 25u) => 142655828787200ul
 * (4251475ul << 31u) => 9129973042380800ul
 * (29852643761ul << 0u) => 29852643761ul
 * (29852643761ul << 1u) => 59705287522ul
 * (29852643761ul << 2u) => 119410575044ul
 * (29852643761ul << 5u) => 955284600352ul
 * (29852643761ul << 25u) => 1001688505098698752ul
 * (29852643761ul << 31u) => 8767832105188065280ul
 * (4398046511104ul << 0u) => 4398046511104ul
 * (4398046511104ul << 1u) => 8796093022208ul
 * (4398046511104ul << 2u) => 17592186044416ul
 * (4398046511104ul << 5u) => 140737488355328ul
 * (4398046511104ul << 25u) => 0ul
 * (4398046511104ul << 31u) => 0ul
 * (3948976685146ul << 0u) => 3948976685146ul
 * (3948976685146ul << 1u) => 7897953370292ul
 * (3948976685146ul << 2u) => 15795906740584ul
 * (3948976685146ul << 5u) => 126367253924672ul
 * (3948976685146ul << 25u) => 3378461135350005760ul
 * (3948976685146ul << 31u) => 13307327851595300864ul
 * (135763469567146206ul << 0u) => 135763469567146206ul
 * (135763469567146206ul << 1u) => 271526939134292412ul
 * (135763469567146206ul << 2u) => 543053878268584824ul
 * (135763469567146206ul << 5u) => 4344431026148678592ul
 * (135763469567146206ul << 25u) => 5765184155612610560ul
 * (135763469567146206ul << 31u) => 36904485016043520ul
 * (11654173250180970009ul << 0u) => 11654173250180970009ul
 * (11654173250180970009ul << 1u) => 4861602426652388402ul
 * (11654173250180970009ul << 2u) => 9723204853304776804ul
 * (11654173250180970009ul << 5u) => 3998662531600007968ul
 * (11654173250180970009ul << 25u) => 11975013050001391616ul
 * (11654173250180970009ul << 31u) => 10084328177997447168ul
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[(0ul << 0u) == 0ul ? 1 : -1] array0;
  float[(0ul << 1u) == 0ul ? 1 : -1] array1;
  float[(0ul << 2u) == 0ul ? 1 : -1] array2;
  float[(0ul << 5u) == 0ul ? 1 : -1] array3;
  float[(0ul << 25u) == 0ul ? 1 : -1] array4;
  float[(0ul << 31u) == 0ul ? 1 : -1] array5;
  float[(3ul << 0u) == 3ul ? 1 : -1] array6;
  float[(3ul << 1u) == 6ul ? 1 : -1] array7;
  float[(3ul << 2u) == 12ul ? 1 : -1] array8;
  float[(3ul << 5u) == 96ul ? 1 : -1] array9;
  float[(3ul << 25u) == 100663296ul ? 1 : -1] array10;
  float[(3ul << 31u) == 6442450944ul ? 1 : -1] array11;
  float[(1192ul << 0u) == 1192ul ? 1 : -1] array12;
  float[(1192ul << 1u) == 2384ul ? 1 : -1] array13;
  float[(1192ul << 2u) == 4768ul ? 1 : -1] array14;
  float[(1192ul << 5u) == 38144ul ? 1 : -1] array15;
  float[(1192ul << 25u) == 39996882944ul ? 1 : -1] array16;
  float[(1192ul << 31u) == 2559800508416ul ? 1 : -1] array17;
  float[(1048576ul << 0u) == 1048576ul ? 1 : -1] array18;
  float[(1048576ul << 1u) == 2097152ul ? 1 : -1] array19;
  float[(1048576ul << 2u) == 4194304ul ? 1 : -1] array20;
  float[(1048576ul << 5u) == 33554432ul ? 1 : -1] array21;
  float[(1048576ul << 25u) == 35184372088832ul ? 1 : -1] array22;
  float[(1048576ul << 31u) == 2251799813685248ul ? 1 : -1] array23;
  float[(4251475ul << 0u) == 4251475ul ? 1 : -1] array24;
  float[(4251475ul << 1u) == 8502950ul ? 1 : -1] array25;
  float[(4251475ul << 2u) == 17005900ul ? 1 : -1] array26;
  float[(4251475ul << 5u) == 136047200ul ? 1 : -1] array27;
  float[(4251475ul << 25u) == 142655828787200ul ? 1 : -1] array28;
  float[(4251475ul << 31u) == 9129973042380800ul ? 1 : -1] array29;
  float[(29852643761ul << 0u) == 29852643761ul ? 1 : -1] array30;
  float[(29852643761ul << 1u) == 59705287522ul ? 1 : -1] array31;
  float[(29852643761ul << 2u) == 119410575044ul ? 1 : -1] array32;
  float[(29852643761ul << 5u) == 955284600352ul ? 1 : -1] array33;
  float[(29852643761ul << 25u) == 1001688505098698752ul ? 1 : -1] array34;
  float[(29852643761ul << 31u) == 8767832105188065280ul ? 1 : -1] array35;
  float[(4398046511104ul << 0u) == 4398046511104ul ? 1 : -1] array36;
  float[(4398046511104ul << 1u) == 8796093022208ul ? 1 : -1] array37;
  float[(4398046511104ul << 2u) == 17592186044416ul ? 1 : -1] array38;
  float[(4398046511104ul << 5u) == 140737488355328ul ? 1 : -1] array39;
  float[(4398046511104ul << 25u) == 0ul ? 1 : -1] array40;
  float[(4398046511104ul << 31u) == 0ul ? 1 : -1] array41;
  float[(3948976685146ul << 0u) == 3948976685146ul ? 1 : -1] array42;
  float[(3948976685146ul << 1u) == 7897953370292ul ? 1 : -1] array43;
  float[(3948976685146ul << 2u) == 15795906740584ul ? 1 : -1] array44;
  float[(3948976685146ul << 5u) == 126367253924672ul ? 1 : -1] array45;
  float[(3948976685146ul << 25u) == 3378461135350005760ul ? 1 : -1] array46;
  float[(3948976685146ul << 31u) == 13307327851595300864ul ? 1 : -1] array47;
  float[(135763469567146206ul << 0u) == 135763469567146206ul ? 1 : -1] array48;
  float[(135763469567146206ul << 1u) == 271526939134292412ul ? 1 : -1] array49;
  float[(135763469567146206ul << 2u) == 543053878268584824ul ? 1 : -1] array50;
  float[(135763469567146206ul << 5u) == 4344431026148678592ul ? 1 : -1] array51;
  float[(135763469567146206ul << 25u) == 5765184155612610560ul ? 1 : -1] array52;
  float[(135763469567146206ul << 31u) == 36904485016043520ul ? 1 : -1] array53;
  float[(11654173250180970009ul << 0u) == 11654173250180970009ul ? 1 : -1] array54;
  float[(11654173250180970009ul << 1u) == 4861602426652388402ul ? 1 : -1] array55;
  float[(11654173250180970009ul << 2u) == 9723204853304776804ul ? 1 : -1] array56;
  float[(11654173250180970009ul << 5u) == 3998662531600007968ul ? 1 : -1] array57;
  float[(11654173250180970009ul << 25u) == 11975013050001391616ul ? 1 : -1] array58;
  float[(11654173250180970009ul << 31u) == 10084328177997447168ul ? 1 : -1] array59;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length() + array20.length() + array21.length() + array22.length() + array23.length() + array24.length() + array25.length() + array26.length() + array27.length() + array28.length() + array29.length() + array30.length() + array31.length() + array32.length() + array33.length() + array34.length() + array35.length() + array36.length() + array37.length() + array38.length() + array39.length() + array40.length() + array41.length() + array42.length() + array43.length() + array44.length() + array45.length() + array46.length() + array47.length() + array48.length() + array49.length() + array50.length() + array51.length() + array52.length() + array53.length() + array54.length() + array55.length() + array56.length() + array57.length() + array58.length() + array59.length());
}
