/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec4(-64, 72, 88, -76) | (~ abs(12))) => ivec4(-13, -5, -5, -9)
 * (ivec4(-64, 72, 88, -76) | (~ abs(-6))) => ivec4(-7, -7, -7, -3)
 * (ivec4(-64, 72, 88, -76) | (~ abs(76))) => ivec4(-13, -5, -5, -73)
 * (ivec4(-64, 72, 88, -76) | (~ abs(-32))) => ivec4(-33, -33, -33, -1)
 * (ivec4(-64, 72, 88, -76) | (~ abs(0))) => ivec4(-1, -1, -1, -1)
 * (ivec4(64, 72, 88, 76) | (~ abs(12))) => ivec4(-13, -5, -5, -1)
 * (ivec4(64, 72, 88, 76) | (~ abs(-6))) => ivec4(-7, -7, -7, -3)
 * (ivec4(64, 72, 88, 76) | (~ abs(76))) => ivec4(-13, -5, -5, -1)
 * (ivec4(64, 72, 88, 76) | (~ abs(-32))) => ivec4(-33, -33, -33, -33)
 * (ivec4(64, 72, 88, 76) | (~ abs(0))) => ivec4(-1, -1, -1, -1)
 * (ivec4(-24, 40, -23, 64) | (~ abs(12))) => ivec4(-5, -5, -5, -13)
 * (ivec4(-24, 40, -23, 64) | (~ abs(-6))) => ivec4(-7, -7, -7, -7)
 * (ivec4(-24, 40, -23, 64) | (~ abs(76))) => ivec4(-5, -69, -5, -13)
 * (ivec4(-24, 40, -23, 64) | (~ abs(-32))) => ivec4(-1, -1, -1, -33)
 * (ivec4(-24, 40, -23, 64) | (~ abs(0))) => ivec4(-1, -1, -1, -1)
 * (ivec4(24, 40, 23, 64) | (~ abs(12))) => ivec4(-5, -5, -9, -13)
 * (ivec4(24, 40, 23, 64) | (~ abs(-6))) => ivec4(-7, -7, -1, -7)
 * (ivec4(24, 40, 23, 64) | (~ abs(76))) => ivec4(-69, -69, -73, -13)
 * (ivec4(24, 40, 23, 64) | (~ abs(-32))) => ivec4(-33, -1, -33, -33)
 * (ivec4(24, 40, 23, 64) | (~ abs(0))) => ivec4(-1, -1, -1, -1)
 */
#version 150

void main()
{
  float[all(equal((ivec4(-64, 72, 88, -76) | (~ abs(12))), ivec4(-13, -5, -5, -9))) ? 1 : -1] array0;
  float[all(equal((ivec4(-64, 72, 88, -76) | (~ abs(-6))), ivec4(-7, -7, -7, -3))) ? 1 : -1] array1;
  float[all(equal((ivec4(-64, 72, 88, -76) | (~ abs(76))), ivec4(-13, -5, -5, -73))) ? 1 : -1] array2;
  float[all(equal((ivec4(-64, 72, 88, -76) | (~ abs(-32))), ivec4(-33, -33, -33, -1))) ? 1 : -1] array3;
  float[all(equal((ivec4(-64, 72, 88, -76) | (~ abs(0))), ivec4(-1, -1, -1, -1))) ? 1 : -1] array4;
  float[all(equal((ivec4(64, 72, 88, 76) | (~ abs(12))), ivec4(-13, -5, -5, -1))) ? 1 : -1] array5;
  float[all(equal((ivec4(64, 72, 88, 76) | (~ abs(-6))), ivec4(-7, -7, -7, -3))) ? 1 : -1] array6;
  float[all(equal((ivec4(64, 72, 88, 76) | (~ abs(76))), ivec4(-13, -5, -5, -1))) ? 1 : -1] array7;
  float[all(equal((ivec4(64, 72, 88, 76) | (~ abs(-32))), ivec4(-33, -33, -33, -33))) ? 1 : -1] array8;
  float[all(equal((ivec4(64, 72, 88, 76) | (~ abs(0))), ivec4(-1, -1, -1, -1))) ? 1 : -1] array9;
  float[all(equal((ivec4(-24, 40, -23, 64) | (~ abs(12))), ivec4(-5, -5, -5, -13))) ? 1 : -1] array10;
  float[all(equal((ivec4(-24, 40, -23, 64) | (~ abs(-6))), ivec4(-7, -7, -7, -7))) ? 1 : -1] array11;
  float[all(equal((ivec4(-24, 40, -23, 64) | (~ abs(76))), ivec4(-5, -69, -5, -13))) ? 1 : -1] array12;
  float[all(equal((ivec4(-24, 40, -23, 64) | (~ abs(-32))), ivec4(-1, -1, -1, -33))) ? 1 : -1] array13;
  float[all(equal((ivec4(-24, 40, -23, 64) | (~ abs(0))), ivec4(-1, -1, -1, -1))) ? 1 : -1] array14;
  float[all(equal((ivec4(24, 40, 23, 64) | (~ abs(12))), ivec4(-5, -5, -9, -13))) ? 1 : -1] array15;
  float[all(equal((ivec4(24, 40, 23, 64) | (~ abs(-6))), ivec4(-7, -7, -1, -7))) ? 1 : -1] array16;
  float[all(equal((ivec4(24, 40, 23, 64) | (~ abs(76))), ivec4(-69, -69, -73, -13))) ? 1 : -1] array17;
  float[all(equal((ivec4(24, 40, 23, 64) | (~ abs(-32))), ivec4(-33, -1, -33, -33))) ? 1 : -1] array18;
  float[all(equal((ivec4(24, 40, 23, 64) | (~ abs(0))), ivec4(-1, -1, -1, -1))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
