# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2023 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.vmc.orgs.sddcs.
#---------------------------------------------------------------------------

"""


"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys
from warnings import warn

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class AddHostsPrecheck(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.add_hosts_precheck'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _AddHostsPrecheckStub)
        self._VAPI_OPERATION_IDS = {}


    def add_host_precheck_task(self,
                               org,
                               sddc,
                               esx_config,
                               ):
        """
        Triggers an add host precheck task

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :type  esx_config: :class:`com.vmware.vmc.model_client.EsxConfig`
        :param esx_config: esxConfig (required)
        :rtype: :class:`com.vmware.vmc.model_client.Task`
        :return: com.vmware.vmc.model.Task
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Access not allowed to the operation for the current user.
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Cannot find the SDDC with the given id.
        """
        return self._invoke('add_host_precheck_task',
                            {
                            'org': org,
                            'sddc': sddc,
                            'esx_config': esx_config,
                            })
class Clusters(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.clusters'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ClustersStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               org,
               sddc,
               cluster_config,
               ):
        """
        Creates a new cluster in customers sddcs with passed clusterConfig.

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :type  cluster_config: :class:`com.vmware.vmc.model_client.ClusterConfig`
        :param cluster_config: clusterConfig (required)
        :rtype: :class:`com.vmware.vmc.model_client.Task`
        :return: com.vmware.vmc.model.Task
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            The sddc is not in a state that's valid for updates
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Access not allowed to the operation for the current user
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Cannot find the cluster with the given identifier
        """
        return self._invoke('create',
                            {
                            'org': org,
                            'sddc': sddc,
                            'cluster_config': cluster_config,
                            })

    def delete(self,
               org,
               sddc,
               cluster,
               ):
        """
        This is a force operation which will delete the cluster even if there
        can be a data loss. Before calling this operation, all the VMs should
        be powered off.

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :type  cluster: :class:`str`
        :param cluster: cluster identifier (required)
        :rtype: :class:`com.vmware.vmc.model_client.Task`
        :return: com.vmware.vmc.model.Task
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            The sddc is not in a state that's valid for updates
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Access not allowed to the operation for the current user
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Cannot find the cluster with the given id
        """
        return self._invoke('delete',
                            {
                            'org': org,
                            'sddc': sddc,
                            'cluster': cluster,
                            })
class Convert(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.convert'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ConvertStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               org,
               sddc,
               sddc_convert_request=None,
               ):
        """
        This API converts a one host SDDC to a 3 node DEFAULT SDDC. It takes
        care of configuring and upgrading the vCenter configurations on the
        SDDC for high availability and data redundancy.

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :type  sddc_convert_request: :class:`com.vmware.vmc.model_client.SddcConvertRequest` or ``None``
        :param sddc_convert_request: convert sddc request body (optional)
        :rtype: :class:`com.vmware.vmc.model_client.Task`
        :return: com.vmware.vmc.model.Task
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            The sddc is not in a state that's valid for updates, Method not
            allowed
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Access not allowed to the operation for the current user
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Cannot find the SDDC with given identifier
        """
        return self._invoke('create',
                            {
                            'org': org,
                            'sddc': sddc,
                            'sddc_convert_request': sddc_convert_request,
                            })
class Enablements(VapiInterface):
    """
    
    """
    ENABLE_DISABLE_ADDON_ACTION_ENABLE = "enable"
    """
    Possible value for ``action`` of method
    :func:`Enablements.enable_disable_addon`.

    """
    ENABLE_DISABLE_ADDON_ACTION_DISABLE = "disable"
    """
    Possible value for ``action`` of method
    :func:`Enablements.enable_disable_addon`.

    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.enablements'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _EnablementsStub)
        self._VAPI_OPERATION_IDS = {}


    def enable_disable_addon(self,
                             org,
                             sddc,
                             enablement,
                             action,
                             ):
        """
        Enable/disable the add-on or set the the default enablement status for
        future add-ons in the SDDC.

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :type  enablement: :class:`str`
        :param enablement: Add-on name, for example \"hcx, \"draas\", \"skynet\". If it is
            \"default\", the operation is for default settings of future
            add-ons. (required)
        :type  action: :class:`str`
        :param action: Enable or disable the add-on or change default settings for future
            add-ons in the SDDC. (required)
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request / Validation error.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Add-on not found
        """
        return self._invoke('enable_disable_addon',
                            {
                            'org': org,
                            'sddc': sddc,
                            'enablement': enablement,
                            'action': action,
                            })

    def list(self,
             org,
             sddc,
             ):
        """
        Return a list of enablement status for current add-ons and the default
        settings for future add-ons in the SDDC.

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :rtype: :class:`list` of :class:`com.vmware.vmc.model_client.EnablementInfo`
        :return: 
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            Bad Request / Validation error.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        """
        return self._invoke('list',
                            {
                            'org': org,
                            'sddc': sddc,
                            })
class Esxs(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.esxs'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _EsxsStub)
        self._VAPI_OPERATION_IDS = {}


    def create(self,
               org,
               sddc,
               esx_config,
               action=None,
               ):
        """
        Add/Remove one or more ESX hosts in the target cloud

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :type  esx_config: :class:`com.vmware.vmc.model_client.EsxConfig`
        :param esx_config: esxConfig (required)
        :type  action: :class:`str` or ``None``
        :param action: If = 'add', will add the esx. If = 'remove', will delete the
            esx/esxs bound to a single cluster (Cluster Id is mandatory for non
            cluster 1 esx remove). If = 'force-remove', will delete the esx
            even if it can lead to data loss (This is an privileged operation).
            If = 'addToAll', will add esxs to all clusters in the SDDC (This is
            an privileged operation). If = 'removeFromAll', will delete the
            esxs from all clusters in the SDDC (This is an privileged
            operation). If = 'attach-diskgroup', will attach the provided
            diskgroups to a given host (privileged). If = 'detach-diskgroup',
            will detach the diskgroups of a given host (privileged). Default
            behaviour is 'add' (optional)
        :rtype: :class:`com.vmware.vmc.model_client.Task`
        :return: com.vmware.vmc.model.Task
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            The sddc is not in a state that's valid for updates
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Access not allowed to the operation for the current user
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Cannot find the SDDC with the given identifier
        """
        return self._invoke('create',
                            {
                            'org': org,
                            'sddc': sddc,
                            'esx_config': esx_config,
                            'action': action,
                            })
class Primarycluster(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.primarycluster'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _PrimaryclusterStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org,
            sddc,
            ):
        """
        Retrieves the primary cluster in provided customer sddc UUID

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :rtype: :class:`com.vmware.vmc.model_client.Cluster`
        :return: com.vmware.vmc.model.Cluster
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            The sddc is not in a state that's valid for fetching the primary
            cluster.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Access not allowed to the operation for the current user
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Cannot find the sddc with the given identifier to fetch the primary
            cluster
        """
        return self._invoke('get',
                            {
                            'org': org,
                            'sddc': sddc,
                            })
class ProvisionSpec(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.provision_spec'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ProvisionSpecStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org,
            ):
        """
        Get sddc provision spec for an org

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :rtype: :class:`com.vmware.vmc.model_client.ProvisionSpec`
        :return: com.vmware.vmc.model.ProvisionSpec
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            BadRequest
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.InternalServerError` 
            Internal server error.
        """
        return self._invoke('get',
                            {
                            'org': org,
                            })
class SddcTemplate(VapiInterface):
    """
    
    """

    _VAPI_SERVICE_ID = 'com.vmware.vmc.orgs.sddcs.sddc_template'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SddcTemplateStub)
        self._VAPI_OPERATION_IDS = {}


    def get(self,
            org,
            sddc,
            ):
        """
        Get configuration template for an SDDC

        :type  org: :class:`str`
        :param org: Organization identifier (required)
        :type  sddc: :class:`str`
        :param sddc: Sddc identifier (required)
        :rtype: :class:`com.vmware.vmc.model_client.SddcTemplate`
        :return: com.vmware.vmc.model.SddcTemplate
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            Unauthorized
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidRequest` 
            SDDC is in a state that cannot be use for generating configuration
            template
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthorized` 
            Forbidden
        :raise: :class:`com.vmware.vapi.std.errors_client.NotFound` 
            Cannot find the SDDC with given identifier
        """
        return self._invoke('get',
                            {
                            'org': org,
                            'sddc': sddc,
                            })
class _AddHostsPrecheckStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for add_host_precheck_task operation
        add_host_precheck_task_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
            'esx_config': type.ReferenceType('com.vmware.vmc.model_client', 'EsxConfig'),
        })
        add_host_precheck_task_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        add_host_precheck_task_input_value_validator_list = [
        ]
        add_host_precheck_task_output_validator_list = [
        ]
        add_host_precheck_task_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/add-hosts-precheck',
            request_body_parameter='esx_config',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'add_host_precheck_task': {
                'input_type': add_host_precheck_task_input_type,
                'output_type': type.ReferenceType('com.vmware.vmc.model_client', 'Task'),
                'errors': add_host_precheck_task_error_dict,
                'input_value_validator_list': add_host_precheck_task_input_value_validator_list,
                'output_validator_list': add_host_precheck_task_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'add_host_precheck_task': add_host_precheck_task_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.add_hosts_precheck',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ClustersStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
            'cluster_config': type.ReferenceType('com.vmware.vmc.model_client', 'ClusterConfig'),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/clusters',
            request_body_parameter='cluster_config',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        # properties for delete operation
        delete_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
            'cluster': type.StringType(),
        })
        delete_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        delete_input_value_validator_list = [
        ]
        delete_output_validator_list = [
        ]
        delete_rest_metadata = OperationRestMetadata(
            http_method='DELETE',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/clusters/{cluster}',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
                'cluster': 'cluster',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.vmc.model_client', 'Task'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'delete': {
                'input_type': delete_input_type,
                'output_type': type.ReferenceType('com.vmware.vmc.model_client', 'Task'),
                'errors': delete_error_dict,
                'input_value_validator_list': delete_input_value_validator_list,
                'output_validator_list': delete_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
            'delete': delete_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.clusters',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ConvertStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
            'sddc_convert_request': type.OptionalType(type.ReferenceType('com.vmware.vmc.model_client', 'SddcConvertRequest')),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/convert',
            request_body_parameter='sddc_convert_request',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
            },
             header_parameters={
                   },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.vmc.model_client', 'Task'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.convert',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _EnablementsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for enable_disable_addon operation
        enable_disable_addon_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
            'enablement': type.StringType(),
            'action': type.StringType(),
        })
        enable_disable_addon_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        enable_disable_addon_input_value_validator_list = [
        ]
        enable_disable_addon_output_validator_list = [
        ]
        enable_disable_addon_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/enablements/{enablement}',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
                'enablement': 'enablement',
            },
             header_parameters={
                     },
            query_parameters={
                'action': 'action',
            },
            content_type='application/json'
        )

        # properties for list operation
        list_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
        })
        list_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),

        }
        list_input_value_validator_list = [
        ]
        list_output_validator_list = [
        ]
        list_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/enablements',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'enable_disable_addon': {
                'input_type': enable_disable_addon_input_type,
                'output_type': type.VoidType(),
                'errors': enable_disable_addon_error_dict,
                'input_value_validator_list': enable_disable_addon_input_value_validator_list,
                'output_validator_list': enable_disable_addon_output_validator_list,
                'task_type': TaskType.NONE,
            },
            'list': {
                'input_type': list_input_type,
                'output_type': type.ListType(type.ReferenceType('com.vmware.vmc.model_client', 'EnablementInfo')),
                'errors': list_error_dict,
                'input_value_validator_list': list_input_value_validator_list,
                'output_validator_list': list_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'enable_disable_addon': enable_disable_addon_rest_metadata,
            'list': list_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.enablements',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _EsxsStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for create operation
        create_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
            'esx_config': type.ReferenceType('com.vmware.vmc.model_client', 'EsxConfig'),
            'action': type.OptionalType(type.StringType()),
        })
        create_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        create_input_value_validator_list = [
        ]
        create_output_validator_list = [
        ]
        create_rest_metadata = OperationRestMetadata(
            http_method='POST',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/esxs',
            request_body_parameter='esx_config',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
            },
             header_parameters={
                     },
            query_parameters={
                'action': 'action',
            },
            content_type='application/json'
        )

        operations = {
            'create': {
                'input_type': create_input_type,
                'output_type': type.ReferenceType('com.vmware.vmc.model_client', 'Task'),
                'errors': create_error_dict,
                'input_value_validator_list': create_input_value_validator_list,
                'output_validator_list': create_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'create': create_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.esxs',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _PrimaryclusterStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/primarycluster',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.vmc.model_client', 'Cluster'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.primarycluster',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _ProvisionSpecStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.internal_server_error':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InternalServerError'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vmc/api/orgs/{org}/sddcs/provision-spec',
            path_variables={
                'org': 'org',
            },
             header_parameters={
               },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.vmc.model_client', 'ProvisionSpec'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.provision_spec',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)

class _SddcTemplateStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {
            'org': type.StringType(),
            'sddc': type.StringType(),
        })
        get_error_dict = {
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),
            'com.vmware.vapi.std.errors.invalid_request':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidRequest'),
            'com.vmware.vapi.std.errors.unauthorized':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthorized'),
            'com.vmware.vapi.std.errors.not_found':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'NotFound'),

        }
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = OperationRestMetadata(
            http_method='GET',
            url_template='/vmc/api/orgs/{org}/sddcs/{sddc}/sddc-template',
            path_variables={
                'org': 'org',
                'sddc': 'sddc',
            },
             header_parameters={
                 },
            query_parameters={
            },
            content_type='application/json'
        )

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType('com.vmware.vmc.model_client', 'SddcTemplate'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.vmc.orgs.sddcs.sddc_template',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=False)


class StubFactory(StubFactoryBase):
    _attrs = {
        'AddHostsPrecheck': AddHostsPrecheck,
        'Clusters': Clusters,
        'Convert': Convert,
        'Enablements': Enablements,
        'Esxs': Esxs,
        'Primarycluster': Primarycluster,
        'ProvisionSpec': ProvisionSpec,
        'SddcTemplate': SddcTemplate,
        'addons': 'com.vmware.vmc.orgs.sddcs.addons_client.StubFactory',
        'clusters': 'com.vmware.vmc.orgs.sddcs.clusters_client.StubFactory',
        'dns': 'com.vmware.vmc.orgs.sddcs.dns_client.StubFactory',
        'management_vms': 'com.vmware.vmc.orgs.sddcs.management_vms_client.StubFactory',
        'networking': 'com.vmware.vmc.orgs.sddcs.networking_client.StubFactory',
    }

