<?php
include('./common.php');

echo "<html>\n";
echo "<!-- RTG Version $VERSION -->\n";
echo "<head>\n";

/* Connect to RTG MySQL Database */
$dbc = @mysqli_connect($host, $user, $pass, $db, $port) or 
	die ("MySQL Connection Failed, Check Configuration.");

	if (!isset($PHP_SELF) || ($PHP_SELF == ""))
	{
		$PHP_SELF = "95.php";
		$customer = isset($_GET['customer'])?$_GET['customer']:"";
		$syear = isset($_GET['syear'])?$_GET['syear']:"";
		$eyear = isset($_GET['eyear'])?$_GET['eyear']:"";
		$smonth = isset($_GET['smonth'])?$_GET['smonth']:"";
		$emonth = isset($_GET['emonth'])?$_GET['emonth']:"";
		$sday = isset($_GET['sday'])?$_GET['sday']:"";
		$eday = isset($_GET['eday'])?$_GET['eday']:"";
		$shour = isset($_GET['shour'])?$_GET['shour']:"";
		$ehour = isset($_GET['ehour'])?$_GET['ehour']:"";
		$smin = isset($_GET['smin'])?$_GET['smin']:"";
		$emin = isset($_GET['emin'])?$_GET['emin']:"";
		$debug = isset($_GET['debug'])?$_GET['debug']:"";
	}

echo "<title>RTG: ";
if ($customer != "")
	echo htmlentities($customer) . "\n";
?>

</title>
</head>
<body bgcolor="ffffff">
<a href="http://rtg.sourceforge.net"><img src="rtg.png" border="0" alt="[RTG Home Page]" /></a>
<p>

<?php
function cmp($c1, $c2)
{
	return (int)($c2 - $c1);
}

function int_stats($statement, $dbc)
{
	$counter = $total = 0;
	$sample_secs = $last_sample_secs = 0;
	$num_rate_samples =0;
	$avgrate = $maxrate = $cur_rate = 0;
	$max = $avg = $nintyfifth = 0;
	$rate = array();

	$selectResult = mysqli_query($dbc, $statement);
	while ($selectRow = mysqli_fetch_object($selectResult))
	{
		$counter = $selectRow->counter;
		$sample_secs = $selectRow->unixtime;
		$total += $counter;
		if (($last_sample_secs > $sample_secs) ||
			(($sample_secs - $last_sample_secs) <= 0) ||
			($counter < 0))
		{
			echo "*** Bad Samples\n";
			echo "*** count: $counter ss: $sample_secs lss: $last_sample_secs\n";
			echo "*** stmt: $statement\n";
		}
		if ($last_sample_secs != 0)
		{
			$num_rate_samples++;
			$cur_rate = $counter*8/($sample_secs - $last_sample_secs);
			array_push($rate, $cur_rate);
			$avgrate += $cur_rate;
			if ($cur_rate > $maxrate)
				$maxrate = $cur_rate;
		}
		$last_sample_secs = $sample_secs;
	}
	$ignore = round($num_rate_samples * 0.05);
	usort($rate, 'cmp');
	for ($i = 0; $i <= $ignore; $i++)
		$nintyfifth = $rate[$i];
	if ($num_rate_samples != 0)
		$avg = $avgrate / $num_rate_samples;

	return Array($total,$maxrate,$avg,$nintyfifth,$num_rate_samples,$ignore);
}
?>

<hr>
Report: 95th percentile<br />

<?php
echo "<form action=\"$PHP_SELF\" method=\"get\">\n";
if (($bt != "" || $smonth != ""))
{
	$dbc = @mysqli_connect($host, $user, $pass, $db) or
		die ("MySQL Connection Failed, Check Configuration.");
	/* Format into GNU date syntax */
	if ($bt == "")
	{
		$bt = strtotime("$syear-$smonth-$sday $shour:$smin:00");
		$et = strtotime("$eyear-$emonth-$eday $ehour:$emin:59");
	}
	echo "Customer: " . htmlentities($customer) . "<br />\n";
	echo strftime("Period: %m/%d/%Y %H:%M - ", $bt);
	echo strftime("%m/%d/%Y %H:%M<P>\n", $et);

	$range = "`dtime`>FROM_UNIXTIME(" . mysqli_real_escape_string($dbc, $bt) .
		") AND `dtime`<=FROM_UNIXTIME(" . mysqli_real_escape_string($dbc, $et) . ")";

	$selectQuery = "SELECT `id`,`name`,`description`,`rid` FROM `interface` WHERE " .
		"`description` LIKE \"%" . mysqli_real_escape_string($dbc, $customer) . "%\"";
	$selectResult = mysqli_query($dbc, $selectQuery);
	if (mysqli_num_rows($selectResult) <= 0) 
		echo "<br />No such customer found.<br />\n";
	else {
		while ($selectRow = mysqli_fetch_object($selectResult))
		{
			$ids[$selectRow->id] = $selectRow->name; 
			$rids[$selectRow->id] = $selectRow->rid;
			$desc[$selectRow->id] = $selectRow->description;
		}
		echo "<table border=\"1\">\n";
		echo "<tr bgcolor=\"#E0E0E0\">\n";
		echo "<th colspan=\"3\">Interface</th><th colspan=\"2\">Current Rate</th><th colspan=\"2\">Max Rate</th><th colspan=\"2\">95th %</th>\n";
		if ($debug) 
			echo "<th colspan=\"2\">Samples</th><th colspan=\"2\">Ignore Top</th>\n";
		echo "<tr bgcolor=\"#E0E0E0\">\n";
		echo "<th>Name</th><th>Description</th><th>Router</th><th>In (Mbps)</th><th>Out (Mbps)</th><th>In</th><th>Out</th><th>In</th><th>Out</th>\n";
		if ($debug) 
			echo "<th>In</th><th>Out</th><th>In</th><th>Out</th>\n";
		echo "<tr bgcolor=\"#ffffcc\">\n";
		$yellow = 1;
		foreach ($ids as $iid => $name)
		{
			$selectQuery = "SELECT `name` FROM `router` WHERE `rid`=" . mysqli_real_escape_string($dbc, $rids[$iid]);
			$selectResult = mysqli_query($dbc, $selectQuery);
			$selectRow = mysqli_fetch_object($selectResult);
			$router = $selectRow->name;

			if ($yellow)
				$yellow = 0;
			else
				$yellow = 1;

			echo "<td>" . htmlentities($name) . "</td>";
			echo "<td>" . htmlentities($desc[$iid]) . "</td>";
			echo "<td>" . htmlentities($router) . "</td>";

			$selectQuery = "SELECT `counter`,UNIX_TIMESTAMP(`dtime`) AS `unixtime`,`dtime` FROM " .
				"`ifInOctets_" . mysqli_real_escape_string($dbc, $rids[$iid]) . "` WHERE $range AND " .
				"`id`=" . mysqli_real_escape_string($dbc, $iid) . " ORDER BY `dtime`";
			list($intbytes_in, $maxin, $avgin, $nfin, $insamples, $inignore) = int_stats($selectQuery, $dbc);
			$bytesin = round($intbytes_in/1000000);

			$selectQuery = "SELECT `counter`,UNIX_TIMESTAMP(`dtime`) AS `unixtime`,`dtime` FROM " .
				"`ifOutOctets_" . mysqli_real_escape_string($dbc, $rids[$iid]) . "` WHERE $range AND " .
				"`id`=" . mysqli_real_escape_string($dbc, $iid) . " ORDER BY `dtime`";
			list ($intbytes_out, $maxout, $avgout, $nfout, $outsamples, $outignore) = int_stats($selectQuery, $dbc);
			$bytesout = round($intbytes_in/1000000);

			printf("<td align=\"right\">%2.2f</td>", $avgin/1000000);
			printf("<td align=\"right\">%2.2f</td>", $avgout/1000000);
			printf("<td align=\"right\">%2.2f</td>", $maxin/1000000);
			printf("<td align=\"right\">%2.2f</td>", $maxout/1000000);
			printf("<td align=\"right\">%2.2f</td>", $nfin/1000000);
			printf("<td align=\"right\">%2.2f</td>", $nfout/1000000);
			if ($debug)
				echo "<td align=\"right\">$insamples</td><td align=\"right\">$outsamples</td><td align=\"right\">$inignore</td><td align=\"right\">$outignore</td>";
			echo "</tr>\n";
			if ($yellow)
				echo "<tr bgcolor=\"#ffffcc\">\n";
			else
				echo "<tr bgcolor=\"#94D6E7\">\n";
		}
		echo "</table>\n";
	}
} else {
	echo "Customer Name: <input type=\"text\" name=\"customer\"><br />\n";
	echo "<p><table>\n";
	echo "<tr><td>From: </td>\n";
	echo "<td><input type=\"text\" name=\"smonth\" size=3 maxlength=2 value=\"";
	printf("%02d", date("m"));
	echo "\" /> / \n";
	echo "<input type=\"text\" name=\"sday\" size=3 maxlength=2 value=\"";
	printf("%02d", (date("d") - 1));
	echo "\" /> / \n";
	echo "<input type=\"text\" name=\"syear\" size=5 maxlength=4 value=\"";
	printf("%04d", date("Y"));
	echo "\" /></td>\n";
	echo "<td><input type=\"text\" name=\"shour\" size=3 maxlength=2 value=\"";
	printf("%02d", date("H"));
	echo "\" />:\n";
	echo "<input type=\"text\" name=\"smin\" size=3 maxlength=2 value=\"";
	printf("%02d", date("i"));
	echo "\" /></td></tr>\n";

	echo "<tr><td>To: </td>\n";
	echo "<td><input type=\"text\" name=\"emonth\" size=3 maxlength=2 value=\"";
	printf("%02d", date("m"));
	echo "\" /> / \n";
	echo "<input type=\"text\" name=\"eday\" size=3 maxlength=2 value=\"";
	printf("%02d", date("d"));
	echo "\"> / \n";
	echo "<input type=\"text\" name=\"eyear\" size=5 maxlength=4 value=\"";
	printf("%04d", date("Y"));
	echo "\" /></td>\n";
	echo "<td><input type=\"text\" name=\"ehour\" size=3 maxlength=2 value=\"";
	printf("%02d", date("H"));
	echo "\" />:\n";
	echo "<input type=\"text\" name=\"emin\" size=3 maxlength=2 value=\"";
	printf("%02d", date("i"));
	echo "\" /></td></tr>\n";
	echo "<tr><td>Debug: </td>\n";
	echo "<td><input type=\"checkbox\" name=\"debug\" /></td></tr>\n";
	echo "</table>\n";

	echo "<p><input type=\"submit\" value=\"Ok\" />";
}

if ($dbc)
	mysqli_close($dbc);
echo "</form>\n";
?>
<br />
<hr />
<font face="Arial" size="2">
<?php
 print "<a href=\"http://rtg.sourceforge.net\">RTG</a> Version $VERSION</font>";
?>
</body>
</html>
