/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.Callable;
import scala.Console$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import xsbt.boot.Using$;

public final class Locks {

    public static class GlobalLock {
        private final File file;
        private boolean fileLocked;

        /*
         * WARNING - void declaration
         */
        public GlobalLock(File file) {
            void var1_1;
            this.file = var1_1;
            this.fileLocked = false;
        }

        public <T> T withLock(Callable<T> run) {
            GlobalLock globalLock = this;
            synchronized (globalLock) {
                T t;
                T t2;
                if (this.fileLocked) {
                    t2 = run.call();
                } else {
                    this.fileLocked = true;
                    try {
                        t2 = this.ignoringDeadlockAvoided((Callable<T>)t);
                    }
                    finally {
                        this.fileLocked = false;
                    }
                }
                t = t2;
                return t;
            }
        }

        private <T> T ignoringDeadlockAvoided(Callable<T> run) {
            Serializable serializable;
            do {
                Option option;
                try {
                    option = Some$.MODULE$.apply(this.withFileLock(run));
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    Throwable throwable2 = throwable;
                    if (throwable instanceof IOException) {
                        IOException i = (IOException)throwable2;
                        if (this.isDeadlockAvoided((IOException)throwable2)) {
                            Thread.sleep(200L);
                            option = None$.MODULE$;
                        }
                    }
                    throw serializable;
                }
                serializable = option;
                serializable = option;
                if (!(option instanceof Some)) continue;
                run = ((Some)serializable).value();
                return (T)run;
            } while (None$.MODULE$.equals(serializable));
            throw new MatchError(serializable);
        }

        private boolean isDeadlockAvoided(IOException i) {
            String string = i.getMessage();
            String string2 = "Resource deadlock avoided";
            return string != null && string.equals(string2);
        }

        /*
         * WARNING - void declaration
         */
        private <T> T withFileLock(Callable<T> run) {
            void var1_1;
            return Using$.MODULE$.apply(new FileOutputStream(this.file).getChannel(), arg_0 -> this.withFileLock$$anonfun$1((Callable)var1_1, arg_0));
        }

        private final Object withChannelRetries$1(Callable run$2, int retries, FileChannel channel) {
            while (true) {
                try {
                    return this.withChannel$1(run$2, channel);
                }
                catch (InternalLockNPE i) {
                    if (retries > 0) {
                        --retries;
                        continue;
                    }
                    throw i;
                }
                break;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Object withChannel$1(Callable run$1, FileChannel channel) {
            void var3_7;
            Object v;
            void var1_1;
            FileLock fileLock;
            try {
                fileLock = channel.tryLock();
            }
            catch (NullPointerException e) {
                throw new InternalLockNPE(e);
            }
            FileLock freeLock = fileLock;
            if (fileLock == null) {
                void var2_6;
                Object v2;
                FileLock fileLock2;
                Console$.MODULE$.err().println(new StringBuilder(46).append("[info] waiting for lock on ").append(this.file).append(" to be available...").toString());
                try {
                    fileLock2 = channel.lock();
                }
                catch (NullPointerException e) {
                    void var1_3;
                    throw new InternalLockNPE((Exception)var1_3);
                }
                FileLock lock = fileLock2;
                try {
                    v2 = var1_1.call();
                }
                catch (Throwable throwable) {
                    lock.release();
                    throw throwable;
                }
                var2_6.release();
                return v2;
            }
            try {
                v = var1_1.call();
            }
            catch (Throwable throwable) {
                freeLock.release();
                throw throwable;
            }
            var3_7.release();
            return v;
        }

        /*
         * WARNING - void declaration
         */
        private final /* synthetic */ Object withFileLock$$anonfun$1(Callable run$3, FileChannel channel) {
            void var2_2;
            void var1_1;
            return this.withChannelRetries$1((Callable)var1_1, 5, (FileChannel)var2_2);
        }
    }

    public static final class InternalLockNPE
    extends RuntimeException {
        /*
         * WARNING - void declaration
         */
        public InternalLockNPE(Exception cause) {
            super((Throwable)var1_1);
            void var1_1;
        }
    }
}

