'\"
'\" Generated from file 'changepoint\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2020 by Arjen Markus
'\"
.TH "math::changepoint" n 0\&.2 tcllib "Tcl Math Library"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
math::changepoint \- Change point detection methods
.SH SYNOPSIS
package require \fBTcl 8\&.6 9\fR
.sp
package require \fBTclOO\fR
.sp
package require \fBmath::statistics\fR
.sp
package require \fBmath::changepoint ?0\&.2?\fR
.sp
\fB::math::changepoint::cusum-detect\fR \fIdata\fR ?args?
.sp
\fB::math::changepoint::cusum-online\fR ?args?
.sp
\fB$cusumObj\fR examine \fIvalue\fR
.sp
\fB$cusumObj\fR reset
.sp
\fB::math::changepoint::binary-segmentation\fR \fIdata\fR ?args?
.sp
.BE
.SH DESCRIPTION
.PP
The \fBmath::changepoint\fR package implements a number of well-known methods
to determine if a series of data contains a shift in the mean or not\&. Note that
these methods only indicate if a shift in the mean is probably\&. Due to the stochastic
nature of the data that will be analysed, false positives are possible\&.
The CUSUM method is implemented in both an "offline" and an "online" version, so that
it can be used either for a complete data series or for detecting changes in data that
come in one by one\&. The implementation has been based on these websites mostly:
.IP \(bu
\fIhttps://www\&.itl\&.nist\&.gov/div898/handbook/pmc/section3/pmc323\&.htm\fR
.IP \(bu
\fIhttps://en\&.wikipedia\&.org/wiki/CUSUM\fR
.PP
Basically, the deviation of the data from a given target value is accumulated and when
the total deviation becomes too large, a change point is reported\&.
A second method, binary segmentation, is implemented only as an "offline" method, as it
needs to examine the data series as a whole\&. In the variant contained here the following
ideas have been used:
.IP \(bu
The segments in which the data series may be separated shold not be too short, otherwise
the ultimate result could be segments of only one data point long\&. So a minimum length is
used\&.
.IP \(bu
To make the segmentation worthwhile there should be a minimum gain in reducing the cost
function (the sum of the squared deviations from the mean for each segment)\&.
.PP
This may not be in agreement with the descriptions of the method found in various
publications, but it is simple to understand and intuitive\&.
One publication that provides more information on the method in general is
"Selective review of offline change point detection methods" by Truong et al\&. \fIhttps://arxiv\&.org/abs/1801\&.00718\fR\&.
.SH PROCEDURES
The package defines the following public procedures:
.TP
\fB::math::changepoint::cusum-detect\fR \fIdata\fR ?args?
Examine a given data series and return the location of the first change (if any)
.RS
.TP
double \fIdata\fR
Series of data to be examined
.TP
list \fIargs\fR
Optional list of key-value pairs:
.RS
.TP
\fB-target\fR \fIvalue\fR
The target (or mean) for the time series
.TP
\fB-tolerance\fR \fIvalue\fR
The tolerated standard deviation
.TP
\fB-kfactor\fR \fIvalue\fR
The factor by which to multiply the standard deviation (defaults to 0\&.5, typically between 0\&.5 and 1\&.0)
.TP
\fB-hfactor\fR \fIvalue\fR
The factor determining the limits betweem which the "cusum" statistic is accepted (typicaly 3\&.0-5\&.0, default 4\&.0)
.RE
.RE
.TP
\fB::math::changepoint::cusum-online\fR ?args?
Class to examine data passed in against expected properties\&. At least the keywords \fI-target\fR and \fI-tolerance\fR must be given\&.
.RS
.TP
list \fIargs\fR
List of key-value pairs:
.RS
.TP
\fB-target\fR \fIvalue\fR
The target (or mean) for the time series
.TP
\fB-tolerance\fR \fIvalue\fR
The tolerated standard deviation
.TP
\fB-kfactor\fR \fIvalue\fR
The factor by which to multiply the standard deviation (defaults to 0\&.5, typically between 0\&.5 and 1\&.0)
.TP
\fB-hfactor\fR \fIvalue\fR
The factor determining the limits betweem which the "cusum" statistic is accepted (typicaly 3\&.0-5\&.0, default 4\&.0)
.RE
.RE
.TP
\fB$cusumObj\fR examine \fIvalue\fR
Pass a value to the \fIcusum-online\fR object and examine it\&. If, with this new value, the cumulative sum remains within the bounds,
zero (0) is returned, otherwise one (1) is returned\&.
.RS
.TP
double \fIvalue\fR
The new value
.RE
.TP
\fB$cusumObj\fR reset
Reset the cumulative sum, so that the examination can start afresh\&.
.TP
\fB::math::changepoint::binary-segmentation\fR \fIdata\fR ?args?
Apply the binary segmentation method recursively to find change points\&. Returns a list of indices of potential change points
.RS
.TP
list \fIdata\fR
Data to be examined
.TP
list \fIargs\fR
Optional key-value pairs:
.RS
.TP
\fB-minlength\fR \fInumber\fR
Minimum number of points in each segment (default: 5)
.TP
\fB-threshold\fR \fIvalue\fR
Factor applied to the standard deviation functioning as a threshold for accepting the change in cost function as an improvement (default: 1\&.0)
.RE
.RE
.PP
.SH KEYWORDS
control, statistics
.SH CATEGORY
Mathematics
.SH COPYRIGHT
.nf
Copyright (c) 2020 by Arjen Markus

.fi
