/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class SeparatorWidget
extends Widget {
    private Orientation orientation;
    private int thickness;

    public SeparatorWidget(Scene scene, Orientation orientation) {
        super(scene);
        assert (orientation != null);
        this.orientation = orientation;
        this.thickness = 1;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        assert (orientation != null);
        this.orientation = orientation;
        this.revalidate();
    }

    public int getThickness() {
        return this.thickness;
    }

    public void setThickness(int n) {
        assert (n >= 0);
        this.thickness = n;
        this.revalidate();
    }

    protected Rectangle calculateClientArea() {
        if (this.orientation == Orientation.HORIZONTAL) {
            return new Rectangle(0, 0, 0, this.thickness);
        }
        return new Rectangle(0, 0, this.thickness, 0);
    }

    protected void paintWidget() {
        Graphics2D graphics2D = this.getGraphics();
        graphics2D.setColor(this.getForeground());
        Rectangle rectangle = this.getBounds();
        Insets insets = this.getBorder().getInsets();
        if (this.orientation == Orientation.HORIZONTAL) {
            graphics2D.fillRect(0, 0, rectangle.width - insets.left - insets.right, this.thickness);
        } else {
            graphics2D.fillRect(0, 0, this.thickness, rectangle.height - insets.top - insets.bottom);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

