/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.xmp;

import java.util.Stack;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.XMPArray;
import org.apache.xmlgraphics.xmp.XMPArrayType;
import org.apache.xmlgraphics.xmp.XMPComplexValue;
import org.apache.xmlgraphics.xmp.XMPProperty;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMPHandler
extends DefaultHandler {
    private Metadata meta;
    private StringBuffer content = new StringBuffer();
    private Stack attributesStack = new Stack();
    private QName currentPropertyName;
    private XMPProperty currentProperty;
    private XMPComplexValue currentComplexValue;

    public Metadata getMetadata() {
        return this.meta;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, qName, attributes);
        this.content.setLength(0);
        this.attributesStack.push(new AttributesImpl(attributes));
        if ("adobe:ns:meta/".equals(uri)) {
            if (!"xmpmeta".equals(localName)) {
                throw new SAXException("Expected x:xmpmeta element, not " + qName);
            }
            if (this.meta != null) {
                throw new SAXException("Invalid XMP document. Root already received earlier.");
            }
            this.meta = new Metadata();
        } else if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(uri)) {
            if ("RDF".equals(localName)) {
                if (this.meta == null) {
                    this.meta = new Metadata();
                }
            } else if ("Description".equals(localName)) {
                if (this.currentPropertyName == null) {
                    String about = attributes.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "about");
                }
            } else if ("Seq".equals(localName)) {
                this.currentComplexValue = new XMPArray(XMPArrayType.SEQ);
            } else if ("Bag".equals(localName)) {
                this.currentComplexValue = new XMPArray(XMPArrayType.BAG);
            } else if ("Alt".equals(localName)) {
                this.currentComplexValue = new XMPArray(XMPArrayType.ALT);
            } else if ("li".equals(localName)) {
                // empty if block
            }
        } else {
            this.currentPropertyName = new QName(uri, qName);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        Attributes atts = (Attributes)this.attributesStack.pop();
        if (!"adobe:ns:meta/".equals(uri)) {
            if ("http://www.w3.org/1999/02/22-rdf-syntax-ns#".equals(uri)) {
                String s;
                if ("li".equals(localName) && (s = this.content.toString().trim()).length() > 0) {
                    this.getCurrentArray().add(s);
                }
            } else {
                if (this.currentComplexValue != null) {
                    this.currentProperty = new XMPProperty(this.currentPropertyName, this.currentComplexValue);
                    this.currentComplexValue = null;
                } else {
                    String s = this.content.toString().trim();
                    this.currentProperty = new XMPProperty(this.currentPropertyName, s);
                    String lang = atts.getValue("http://www.w3.org/XML/1998/namespace", "lang");
                    if (lang != null) {
                        this.currentProperty.setXMLLang(lang);
                    }
                }
                this.meta.setProperty(this.currentProperty);
                this.currentProperty = null;
                this.currentPropertyName = null;
            }
        }
        this.content.setLength(0);
        super.endElement(uri, localName, qName);
    }

    private XMPArray getCurrentArray() {
        return (XMPArray)this.currentComplexValue;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.content.append(ch, start, length);
    }
}

