/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOPropertyMapping;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.flow.Marker;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public abstract class FObj
extends FONode
implements Constants {
    private static PropertyMaker[] propertyListTable = FOPropertyMapping.getGenericMappings();
    protected List childNodes = null;
    private List extensionAttachments = null;
    private Map foreignAttributes = null;
    private boolean isOutOfLineFODescendant = false;
    private Map markers = null;

    public FObj(FONode parent) {
        super(parent);
        if (parent != null && parent instanceof FObj) {
            if (((FObj)parent).getIsOutOfLineFODescendant()) {
                this.isOutOfLineFODescendant = true;
            } else {
                int foID = this.getNameId();
                if (foID == 10 || foID == 12 || foID == 13) {
                    this.isOutOfLineFODescendant = true;
                }
            }
        }
    }

    public FONode clone(FONode parent, boolean removeChildren) throws FOPException {
        FObj fobj = (FObj)super.clone(parent, removeChildren);
        if (removeChildren) {
            fobj.childNodes = null;
        }
        return fobj;
    }

    public static PropertyMaker getPropertyMakerFor(int propId) {
        return propertyListTable[propId];
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList pList) throws FOPException {
        this.setLocator(locator);
        pList.addAttributesToList(attlist);
        if (!this.inMarker() || "marker".equals(elementName)) {
            pList.setWritingMode();
            this.bind(pList);
        }
    }

    protected PropertyList createPropertyList(PropertyList parent, FOEventHandler foEventHandler) throws FOPException {
        return foEventHandler.getPropertyListMaker().make(this, parent);
    }

    public void bind(PropertyList pList) throws FOPException {
    }

    protected void checkId(String id) throws ValidationException {
        if (!this.inMarker() && !id.equals("")) {
            Set idrefs = this.getFOEventHandler().getIDReferences();
            if (!idrefs.contains(id)) {
                idrefs.add(id);
            } else {
                if (this.getUserAgent().validateStrictly()) {
                    throw new ValidationException("Property id \"" + id + "\" previously used; id values must be unique" + " in document.", this.locator);
                }
                if (log.isWarnEnabled()) {
                    StringBuffer msg = new StringBuffer();
                    msg.append("Found non-unique id on ").append(this.getName());
                    if (this.locator.getLineNumber() != -1) {
                        msg.append(" (at ").append(this.locator.getLineNumber()).append("/").append(this.locator.getColumnNumber()).append(")");
                    }
                    msg.append("\nAny reference to it will be considered a reference to the first occurrence in the document.");
                    log.warn((Object)msg);
                }
            }
        }
    }

    public boolean getIsOutOfLineFODescendant() {
        return this.isOutOfLineFODescendant;
    }

    protected void addChildNode(FONode child) throws FOPException {
        if (this.canHaveMarkers() && child.getNameId() == 24) {
            this.addMarker((Marker)child);
        } else {
            ExtensionAttachment attachment = child.getExtensionAttachment();
            if (attachment != null) {
                this.addExtensionAttachment(attachment);
            } else {
                if (this.childNodes == null) {
                    this.childNodes = new ArrayList();
                }
                this.childNodes.add(child);
            }
        }
    }

    protected static void addChildTo(FONode child, FObj parent) throws FOPException {
        parent.addChildNode(child);
    }

    public void removeChild(FONode child) {
        if (this.childNodes != null) {
            this.childNodes.remove(child);
        }
    }

    public FObj findNearestAncestorFObj() {
        FONode par = this.parent;
        while (par != null && !(par instanceof FObj)) {
            par = par.parent;
        }
        return (FObj)par;
    }

    public boolean generatesReferenceAreas() {
        return false;
    }

    public ListIterator getChildNodes() {
        if (this.childNodes != null) {
            return this.childNodes.listIterator();
        }
        return null;
    }

    public ListIterator getChildNodes(FONode childNode) {
        int i;
        if (this.childNodes != null && (i = this.childNodes.indexOf(childNode)) >= 0) {
            return this.childNodes.listIterator(i);
        }
        return null;
    }

    public FONode getChildNodeAt(int nodeIndex) {
        if (this.childNodes != null && nodeIndex >= 0 && nodeIndex < this.childNodes.size()) {
            return (FONode)this.childNodes.get(nodeIndex);
        }
        return null;
    }

    protected void notifyChildRemoval(FONode node) {
    }

    protected void addMarker(Marker marker) {
        String mcname = marker.getMarkerClassName();
        if (this.childNodes != null) {
            Iterator iter = this.childNodes.iterator();
            while (iter.hasNext()) {
                FONode node = (FONode)iter.next();
                if (node instanceof FObj || node instanceof FOText && ((FOText)node).willCreateArea()) {
                    this.getLogger().error((Object)("fo:marker must be an initial child: " + mcname));
                    return;
                }
                if (!(node instanceof FOText)) continue;
                iter.remove();
                this.notifyChildRemoval(node);
            }
        }
        if (this.markers == null) {
            this.markers = new HashMap();
        }
        if (!this.markers.containsKey(mcname)) {
            this.markers.put(mcname, marker);
        } else {
            this.getLogger().error((Object)("fo:marker 'marker-class-name' must be unique for same parent: " + mcname));
        }
    }

    public boolean hasMarkers() {
        return this.markers != null && !this.markers.isEmpty();
    }

    public Map getMarkers() {
        return this.markers;
    }

    protected String gatherContextInfo() {
        if (this.getLocator() != null) {
            return super.gatherContextInfo();
        }
        ListIterator iter = this.getChildNodes();
        if (iter == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        while (iter.hasNext()) {
            FONode node = (FONode)iter.next();
            String s = node.gatherContextInfo();
            if (s == null) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(s);
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    protected boolean isBlockItem(String nsURI, String lName) {
        return "http://www.w3.org/1999/XSL/Format".equals(nsURI) && (lName.equals("block") || lName.equals("table") || lName.equals("table-and-caption") || lName.equals("block-container") || lName.equals("list-block") || lName.equals("float") || this.isNeutralItem(nsURI, lName));
    }

    protected boolean isInlineItem(String nsURI, String lName) {
        return "http://www.w3.org/1999/XSL/Format".equals(nsURI) && (lName.equals("bidi-override") || lName.equals("character") || lName.equals("external-graphic") || lName.equals("instream-foreign-object") || lName.equals("inline") || lName.equals("inline-container") || lName.equals("leader") || lName.equals("page-number") || lName.equals("page-number-citation") || lName.equals("page-number-citation-last") || lName.equals("basic-link") || lName.equals("multi-toggle") && (this.getNameId() == 25 || this.findAncestor(25) > 0) || lName.equals("footnote") && !this.isOutOfLineFODescendant || this.isNeutralItem(nsURI, lName));
    }

    protected boolean isBlockOrInlineItem(String nsURI, String lName) {
        return this.isBlockItem(nsURI, lName) || this.isInlineItem(nsURI, lName);
    }

    protected boolean isNeutralItem(String nsURI, String lName) {
        return "http://www.w3.org/1999/XSL/Format".equals(nsURI) && (lName.equals("multi-switch") || lName.equals("multi-properties") || lName.equals("wrapper") || !this.isOutOfLineFODescendant && lName.equals("float") || lName.equals("retrieve-marker"));
    }

    protected int findAncestor(int ancestorID) {
        int found = 1;
        for (FONode temp = this.getParent(); temp != null; temp = temp.getParent()) {
            if (temp.getNameId() == ancestorID) {
                return found;
            }
            ++found;
        }
        return -1;
    }

    public String getNamespaceURI() {
        return "http://www.w3.org/1999/XSL/Format";
    }

    public String getNormalNamespacePrefix() {
        return "fo";
    }

    public void addExtensionAttachment(ExtensionAttachment attachment) {
        if (attachment == null) {
            throw new NullPointerException("Parameter attachment must not be null");
        }
        if (this.extensionAttachments == null) {
            this.extensionAttachments = new ArrayList();
        }
        if (log.isDebugEnabled()) {
            this.getLogger().debug((Object)("ExtensionAttachment of category " + attachment.getCategory() + " added to " + this.getName() + ": " + attachment));
        }
        this.extensionAttachments.add(attachment);
    }

    public List getExtensionAttachments() {
        if (this.extensionAttachments == null) {
            return Collections.EMPTY_LIST;
        }
        return this.extensionAttachments;
    }

    public void addForeignAttribute(QName attributeName, String value) {
        if (attributeName == null) {
            throw new NullPointerException("Parameter attributeName must not be null");
        }
        if (this.foreignAttributes == null) {
            this.foreignAttributes = new HashMap();
        }
        this.foreignAttributes.put(attributeName, value);
    }

    public Map getForeignAttributes() {
        if (this.foreignAttributes == null) {
            return Collections.EMPTY_MAP;
        }
        return this.foreignAttributes;
    }
}

