/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import com.sun.jimi.core.Jimi;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageConsumer;

public class JimiImage
extends AbstractFopImage {
    public JimiImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
    }

    protected boolean loadDimensions() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.bitmaps != null;
    }

    protected boolean loadBitmap() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.bitmaps != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage() {
        int[] tmpMap;
        block16: {
            tmpMap = null;
            try {
                ImageProducer ip = Jimi.getImageProducer((InputStream)this.inputStream, (int)6);
                FopImageConsumer consumer = new FopImageConsumer(ip);
                ip.startProduction(consumer);
                while (!consumer.isImageReady()) {
                    Thread.sleep(500L);
                }
                this.height = consumer.getHeight();
                this.width = consumer.getWidth();
                try {
                    tmpMap = consumer.getImage();
                }
                catch (Exception ex) {
                    log.error((Object)"Image grabbing interrupted", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)this.inputStream);
                    this.inputStream = null;
                    return;
                }
                ColorModel cm = consumer.getColorModel();
                this.bitsPerPixel = 8;
                this.colorSpace = ColorSpace.getInstance(1004);
                if (cm.hasAlpha()) {
                    int transparencyType = cm.getTransparency();
                    if (transparencyType == 1) {
                        this.isTransparent = false;
                        break block16;
                    }
                    if (transparencyType == 2) {
                        if (cm instanceof IndexColorModel) {
                            this.isTransparent = false;
                            byte[] alphas = new byte[((IndexColorModel)cm).getMapSize()];
                            byte[] reds = new byte[((IndexColorModel)cm).getMapSize()];
                            byte[] greens = new byte[((IndexColorModel)cm).getMapSize()];
                            byte[] blues = new byte[((IndexColorModel)cm).getMapSize()];
                            ((IndexColorModel)cm).getAlphas(alphas);
                            ((IndexColorModel)cm).getReds(reds);
                            ((IndexColorModel)cm).getGreens(greens);
                            ((IndexColorModel)cm).getBlues(blues);
                            for (int i = 0; i < ((IndexColorModel)cm).getMapSize(); ++i) {
                                if ((alphas[i] & 0xFF) != 0) continue;
                                this.isTransparent = true;
                                this.transparentColor = new Color(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                                break block16;
                            }
                            break block16;
                        }
                        this.isTransparent = false;
                        break block16;
                    }
                    this.isTransparent = false;
                    break block16;
                }
                this.isTransparent = false;
            }
            catch (Throwable ex) {
                log.error((Object)("Error while loading image (Jimi): " + ex.getMessage()), ex);
                return;
            }
            finally {
                IOUtils.closeQuietly((InputStream)this.inputStream);
                this.inputStream = null;
            }
        }
        this.bitmaps = new byte[this.width * this.height * 3];
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int p = tmpMap[i * this.width + j];
                int r = p >> 16 & 0xFF;
                int g = p >> 8 & 0xFF;
                int b = p & 0xFF;
                this.bitmaps[3 * (i * this.width + j)] = (byte)(r & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 1] = (byte)(g & 0xFF);
                this.bitmaps[3 * (i * this.width + j) + 2] = (byte)(b & 0xFF);
            }
        }
    }

    protected boolean loadOriginalData() {
        return this.loadDefaultOriginalData();
    }
}

