/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.render.java2d.FontMetricsMapper;

public class FontSetup {
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$render$java2d$FontSetup == null ? (class$org$apache$fop$render$java2d$FontSetup = FontSetup.class$("org.apache.fop.render.java2d.FontSetup")) : class$org$apache$fop$render$java2d$FontSetup));
    private static final int LAST_PREDEFINED_FONT_NUMBER = 14;
    private static final Set HARDCODED_FONT_NAMES = new HashSet();
    static /* synthetic */ Class class$org$apache$fop$render$java2d$FontSetup;

    public static void setup(FontInfo fontInfo, Graphics2D graphics) {
        int normal = 0;
        int bold = 1;
        int italic = 2;
        int bolditalic = 3;
        FontMetricsMapper metric = new FontMetricsMapper("SansSerif", normal, graphics);
        fontInfo.addMetrics("F1", metric);
        metric = new FontMetricsMapper("SansSerif", italic, graphics);
        fontInfo.addMetrics("F2", metric);
        metric = new FontMetricsMapper("SansSerif", bold, graphics);
        fontInfo.addMetrics("F3", metric);
        metric = new FontMetricsMapper("SansSerif", bolditalic, graphics);
        fontInfo.addMetrics("F4", metric);
        metric = new FontMetricsMapper("Serif", normal, graphics);
        fontInfo.addMetrics("F5", metric);
        metric = new FontMetricsMapper("Serif", italic, graphics);
        fontInfo.addMetrics("F6", metric);
        metric = new FontMetricsMapper("Serif", bold, graphics);
        fontInfo.addMetrics("F7", metric);
        metric = new FontMetricsMapper("Serif", bolditalic, graphics);
        fontInfo.addMetrics("F8", metric);
        metric = new FontMetricsMapper("MonoSpaced", normal, graphics);
        fontInfo.addMetrics("F9", metric);
        metric = new FontMetricsMapper("MonoSpaced", italic, graphics);
        fontInfo.addMetrics("F10", metric);
        metric = new FontMetricsMapper("MonoSpaced", bold, graphics);
        fontInfo.addMetrics("F11", metric);
        metric = new FontMetricsMapper("MonoSpaced", bolditalic, graphics);
        fontInfo.addMetrics("F12", metric);
        metric = new FontMetricsMapper("Serif", normal, graphics);
        fontInfo.addMetrics("F13", metric);
        fontInfo.addMetrics("F14", metric);
        fontInfo.addFontProperties("F5", "any", "normal", 400);
        fontInfo.addFontProperties("F6", "any", "italic", 400);
        fontInfo.addFontProperties("F6", "any", "oblique", 400);
        fontInfo.addFontProperties("F7", "any", "normal", 700);
        fontInfo.addFontProperties("F8", "any", "italic", 700);
        fontInfo.addFontProperties("F8", "any", "oblique", 700);
        fontInfo.addFontProperties("F1", "sans-serif", "normal", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "oblique", 400);
        fontInfo.addFontProperties("F2", "sans-serif", "italic", 400);
        fontInfo.addFontProperties("F3", "sans-serif", "normal", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "oblique", 700);
        fontInfo.addFontProperties("F4", "sans-serif", "italic", 700);
        fontInfo.addFontProperties("F5", "serif", "normal", 400);
        fontInfo.addFontProperties("F6", "serif", "oblique", 400);
        fontInfo.addFontProperties("F6", "serif", "italic", 400);
        fontInfo.addFontProperties("F7", "serif", "normal", 700);
        fontInfo.addFontProperties("F8", "serif", "oblique", 700);
        fontInfo.addFontProperties("F8", "serif", "italic", 700);
        fontInfo.addFontProperties("F9", "monospace", "normal", 400);
        fontInfo.addFontProperties("F10", "monospace", "oblique", 400);
        fontInfo.addFontProperties("F10", "monospace", "italic", 400);
        fontInfo.addFontProperties("F11", "monospace", "normal", 700);
        fontInfo.addFontProperties("F12", "monospace", "oblique", 700);
        fontInfo.addFontProperties("F12", "monospace", "italic", 700);
        fontInfo.addFontProperties("F1", "Helvetica", "normal", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "oblique", 400);
        fontInfo.addFontProperties("F2", "Helvetica", "italic", 400);
        fontInfo.addFontProperties("F3", "Helvetica", "normal", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "oblique", 700);
        fontInfo.addFontProperties("F4", "Helvetica", "italic", 700);
        fontInfo.addFontProperties("F5", "Times", "normal", 400);
        fontInfo.addFontProperties("F6", "Times", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times", "italic", 400);
        fontInfo.addFontProperties("F7", "Times", "normal", 700);
        fontInfo.addFontProperties("F8", "Times", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times", "italic", 700);
        fontInfo.addFontProperties("F9", "Courier", "normal", 400);
        fontInfo.addFontProperties("F10", "Courier", "oblique", 400);
        fontInfo.addFontProperties("F10", "Courier", "italic", 400);
        fontInfo.addFontProperties("F11", "Courier", "normal", 700);
        fontInfo.addFontProperties("F12", "Courier", "oblique", 700);
        fontInfo.addFontProperties("F12", "Courier", "italic", 700);
        fontInfo.addFontProperties("F13", "Symbol", "normal", 400);
        fontInfo.addFontProperties("F14", "ZapfDingbats", "normal", 400);
        fontInfo.addFontProperties("F5", "Times-Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times-Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times-Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times-Roman", "italic", 700);
        fontInfo.addFontProperties("F5", "Times Roman", "normal", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "oblique", 400);
        fontInfo.addFontProperties("F6", "Times Roman", "italic", 400);
        fontInfo.addFontProperties("F7", "Times Roman", "normal", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "oblique", 700);
        fontInfo.addFontProperties("F8", "Times Roman", "italic", 700);
        fontInfo.addFontProperties("F9", "Computer-Modern-Typewriter", "normal", 400);
        FontSetup.configureInstalledAWTFonts(fontInfo, graphics, 15);
    }

    private static void configureInstalledAWTFonts(FontInfo fontInfo, Graphics2D graphics, int startNumber) {
        int num = startNumber;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] allFontFamilies = env.getAvailableFontFamilyNames();
        for (int i = 0; i < allFontFamilies.length; ++i) {
            String family = allFontFamilies[i];
            if (HARDCODED_FONT_NAMES.contains(family)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Registering: " + family));
            }
            int fontStyle = 0;
            FontSetup.registerFontTriplet(fontInfo, family, fontStyle, "F" + num, graphics);
            fontStyle = 2;
            FontSetup.registerFontTriplet(fontInfo, family, fontStyle, "F" + ++num, graphics);
            fontStyle = 1;
            FontSetup.registerFontTriplet(fontInfo, family, fontStyle, "F" + ++num, graphics);
            fontStyle = 3;
            FontSetup.registerFontTriplet(fontInfo, family, fontStyle, "F" + ++num, graphics);
            ++num;
        }
    }

    private static void registerFontTriplet(FontInfo fontInfo, String family, int fontStyle, String fontKey, Graphics2D graphics) {
        FontMetricsMapper metric = new FontMetricsMapper(family, fontStyle, graphics);
        fontInfo.addMetrics(fontKey, metric);
        int weight = 400;
        if ((fontStyle & 1) != 0) {
            weight = 700;
        }
        String style = "normal";
        if ((fontStyle & 2) != 0) {
            style = "italic";
        }
        FontTriplet triplet = FontInfo.createFontKey(family, style, weight);
        fontInfo.addFontProperties(fontKey, triplet);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        HARDCODED_FONT_NAMES.add("any");
        HARDCODED_FONT_NAMES.add("sans-serif");
        HARDCODED_FONT_NAMES.add("serif");
        HARDCODED_FONT_NAMES.add("monospace");
        HARDCODED_FONT_NAMES.add("Helvetica");
        HARDCODED_FONT_NAMES.add("Times");
        HARDCODED_FONT_NAMES.add("Courier");
        HARDCODED_FONT_NAMES.add("Symbol");
        HARDCODED_FONT_NAMES.add("ZapfDingbats");
        HARDCODED_FONT_NAMES.add("Times Roman");
        HARDCODED_FONT_NAMES.add("Times-Roman");
        HARDCODED_FONT_NAMES.add("Computer-Modern-Typewriter");
    }
}

