/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.netbeans.modules.options.keymap.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeymapViewModel
implements TreeModel,
ShortcutsFinder {
    private Vector<TreeModelListener> listeners = new Vector();
    private String currentProfile;
    private KeymapModel model = new KeymapModel();
    private Map<String, List<Object>> categoryToActionsCache = new HashMap<String, List<Object>>();
    private Map<String, Map<ShortcutAction, Set<String>>> modifiedProfiles = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Set<String> deletedProfiles = new HashSet<String>();
    private Map<String, Map<ShortcutAction, Set<String>>> shortcutsCache = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    static final ActionsComparator actionsComparator = new ActionsComparator();
    private Map<String, List<String>> categories;

    public KeymapViewModel() {
        this.currentProfile = this.model.getCurrentProfile();
    }

    @Override
    public Object getRoot() {
        return "";
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getItems((String)object).get(n);
    }

    @Override
    public int getChildCount(Object object) {
        if (object instanceof String) {
            return this.getItems((String)object).size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object object) {
        return !(object instanceof String);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return this.getItems((String)object).indexOf(object2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.add(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listeners.remove(treeModelListener);
    }

    private void treeChanged() {
        final Vector vector = (Vector)this.listeners.clone();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, new TreePath(KeymapViewModel.this.getRoot()));
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    ((TreeModelListener)vector.get(i)).treeStructureChanged(treeModelEvent);
                }
            }
        });
    }

    private void nodeChanged(final TreePath treePath) {
        final Vector vector = (Vector)this.listeners.clone();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    ((TreeModelListener)vector.get(i)).treeNodesChanged(treeModelEvent);
                }
            }
        });
    }

    public Map<String, List<String>> getCategories() {
        if (this.categories == null) {
            this.categories = new TreeMap<String, List<String>>();
            ArrayList<String> arrayList = new ArrayList<String>(this.model.getActionCategories());
            Collections.sort(arrayList);
            for (String string : arrayList) {
                String string2 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    List<String> list = this.categories.get(string2);
                    if (list == null) {
                        list = new ArrayList<String>();
                        this.categories.put(string2, list);
                    }
                    String string4 = string2 = string2.length() == 0 ? string3 : string2 + '/' + string3;
                    if (!list.isEmpty() && list.get(list.size() - 1).equals(string2)) continue;
                    list.add(string2);
                }
            }
        }
        return this.categories;
    }

    public List<Object> getItems(String string) {
        List<Object> list = this.categoryToActionsCache.get(string);
        if (list == null) {
            list = new ArrayList<Object>();
            List<String> list2 = this.getCategories().get(string);
            if (list2 != null) {
                list.addAll(list2);
            }
            ArrayList<ShortcutAction> arrayList = new ArrayList<ShortcutAction>(this.model.getActions(string));
            Collections.sort(arrayList, new ActionsComparator());
            list.addAll(arrayList);
            this.categoryToActionsCache.put(string, list);
        }
        return list;
    }

    List getProfiles() {
        HashSet<String> hashSet = new HashSet<String>(this.model.getProfiles());
        hashSet.addAll(this.modifiedProfiles.keySet());
        ArrayList<String> arrayList = new ArrayList<String>(hashSet);
        Collections.sort(arrayList);
        return arrayList;
    }

    boolean isCustomProfile(String string) {
        return this.model.isCustomProfile(string);
    }

    void deleteProfile(String string) {
        if (this.model.isCustomProfile(string)) {
            this.deletedProfiles.add(string);
            this.modifiedProfiles.remove(string);
        } else {
            Map<ShortcutAction, Set<String>> map = this.model.getKeymapDefaults(string);
            map = KeymapViewModel.convertFromEmacs(map);
            this.modifiedProfiles.put(string, map);
            this.treeChanged();
        }
    }

    String getCurrentProfile() {
        return this.currentProfile;
    }

    void setCurrentProfile(String string) {
        this.currentProfile = string;
        this.treeChanged();
    }

    void cloneProfile(String string) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        this.cloneProfile("", hashMap);
        this.modifiedProfiles.put(string, hashMap);
    }

    private void cloneProfile(String string, Map<ShortcutAction, Set<String>> map) {
        for (Object object : this.getItems(string)) {
            if (object instanceof String) {
                this.cloneProfile((String)object, map);
                continue;
            }
            String[] stringArray = this.getShortcuts((ShortcutAction)object);
            map.put((ShortcutAction)object, new HashSet<String>(Arrays.asList(stringArray)));
        }
    }

    @Override
    public ShortcutAction findActionForShortcut(String string) {
        return this.findActionForShortcut(string, "");
    }

    private ShortcutAction findActionForShortcut(String string, String string2) {
        for (Object object : this.getItems(string2)) {
            ShortcutAction shortcutAction;
            if (object instanceof String) {
                shortcutAction = this.findActionForShortcut(string, (String)object);
                if (shortcutAction == null) continue;
                return shortcutAction;
            }
            shortcutAction = (ShortcutAction)object;
            String[] stringArray = this.getShortcuts(shortcutAction);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (stringArray[i].equals(string)) {
                    return shortcutAction;
                }
                if (!stringArray[i].equals(string + " ")) continue;
                return shortcutAction;
            }
        }
        return null;
    }

    @Override
    public ShortcutAction findActionForId(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.findActionForId(string, "");
        }
        final ShortcutAction[] shortcutActionArray = new ShortcutAction[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    shortcutActionArray[0] = KeymapViewModel.this.findActionForId(string, "");
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return shortcutActionArray[0];
    }

    private ShortcutAction findActionForId(String string, String string2) {
        for (Object object : this.getItems(string2)) {
            Object object2;
            if (object instanceof String) {
                object2 = this.findActionForId(string, (String)object);
                if (object2 == null) continue;
                return object2;
            }
            object2 = ((ShortcutAction)object).getId();
            if (!string.equals(object2)) continue;
            return (ShortcutAction)object;
        }
        return null;
    }

    @Override
    public String[] getShortcuts(ShortcutAction shortcutAction) {
        Set<String> set;
        Map<ShortcutAction, Set<String>> map;
        if (this.modifiedProfiles.containsKey(this.currentProfile) && (map = this.modifiedProfiles.get(this.currentProfile)).containsKey(shortcutAction)) {
            Set<String> set2 = map.get(shortcutAction);
            return set2.toArray(new String[set2.size()]);
        }
        if (!this.shortcutsCache.containsKey(this.currentProfile)) {
            map = KeymapViewModel.convertFromEmacs(this.model.getKeymap(this.currentProfile));
            this.shortcutsCache.put(this.currentProfile, map);
        }
        if ((set = (map = this.shortcutsCache.get(this.currentProfile)).get(shortcutAction)) == null) {
            return new String[0];
        }
        return set.toArray(new String[set.size()]);
    }

    void addShortcut(TreePath treePath, String string) {
        ShortcutAction shortcutAction = this.findActionForShortcut(string);
        if (shortcutAction != null) {
            this.removeShortcut(shortcutAction, string);
        }
        shortcutAction = (ShortcutAction)treePath.getLastPathComponent();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        hashSet.addAll(Arrays.asList(this.getShortcuts(shortcutAction)));
        this.setShortcuts(shortcutAction, hashSet);
        this.nodeChanged(treePath);
    }

    @Override
    public void setShortcuts(ShortcutAction shortcutAction, Set<String> set) {
        Map<ShortcutAction, Set<String>> map = this.modifiedProfiles.get(this.currentProfile);
        if (map == null) {
            map = new HashMap<ShortcutAction, Set<String>>();
            this.modifiedProfiles.put(this.currentProfile, map);
        }
        map.put(shortcutAction, set);
    }

    void removeShortcut(TreePath treePath, String string) {
        ShortcutAction shortcutAction = (ShortcutAction)treePath.getLastPathComponent();
        this.removeShortcut(shortcutAction, string);
        this.nodeChanged(treePath);
    }

    private void removeShortcut(ShortcutAction shortcutAction, String string) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(this.getShortcuts(shortcutAction)));
        hashSet.remove(string);
        this.setShortcuts(shortcutAction, hashSet);
    }

    @Override
    public void refreshActions() {
        this.categoryToActionsCache = new HashMap<String, List<Object>>();
        this.model.refreshActions();
    }

    @Override
    public void apply() {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                for (String string : KeymapViewModel.this.modifiedProfiles.keySet()) {
                    Map map = (Map)KeymapViewModel.this.modifiedProfiles.get(string);
                    map = KeymapViewModel.convertToEmacs(map);
                    KeymapViewModel.this.model.changeKeymap(string, map);
                }
                for (String string : KeymapViewModel.this.deletedProfiles) {
                    KeymapViewModel.this.model.deleteProfile(string);
                }
                KeymapViewModel.this.model.setCurrentProfile(KeymapViewModel.this.currentProfile);
                KeymapViewModel.this.modifiedProfiles = new HashMap();
                KeymapViewModel.this.deletedProfiles = new HashSet();
                KeymapViewModel.this.shortcutsCache = new HashMap();
                KeymapViewModel.this.model = new KeymapModel();
            }
        });
    }

    public boolean isChanged() {
        return !this.modifiedProfiles.isEmpty() || !this.deletedProfiles.isEmpty();
    }

    public void cancel() {
        this.modifiedProfiles = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.deletedProfiles = new HashSet<String>();
        this.shortcutsCache = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.setCurrentProfile(this.model.getCurrentProfile());
        this.model = new KeymapModel();
    }

    @Override
    public String showShortcutsDialog() {
        final ShortcutsDialog shortcutsDialog = new ShortcutsDialog();
        shortcutsDialog.init(this);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)shortcutsDialog, KeymapViewModel.loc("Add_Shortcut_Dialog"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, (ActionListener)shortcutsDialog.getListener());
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        dialogDescriptor.setAdditionalOptions(new Object[]{shortcutsDialog.getBClear(), shortcutsDialog.getBTab()});
        dialogDescriptor.setValid(shortcutsDialog.isShortcutValid());
        shortcutsDialog.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == null || "ShortcutsDialog.PROP_SHORTCUT_VALID".equals(propertyChangeEvent.getPropertyName())) {
                    dialogDescriptor.setValid(shortcutsDialog.isShortcutValid());
                }
            }
        });
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return shortcutsDialog.getTfShortcut().getText();
        }
        return null;
    }

    private static Map<ShortcutAction, Set<String>> convertToEmacs(Map<ShortcutAction, Set<String>> map) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
            ShortcutAction shortcutAction = entry.getKey();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : entry.getValue()) {
                KeyStroke[] keyStrokeArray;
                if (string.length() == 0 || (keyStrokeArray = KeymapViewModel.getKeyStrokes(string, " ")) == null) continue;
                StringBuffer stringBuffer = new StringBuffer(Utilities.keyToString((KeyStroke)keyStrokeArray[0]));
                int n = keyStrokeArray.length;
                for (int i = 1; i < n; ++i) {
                    stringBuffer.append(' ').append(Utilities.keyToString((KeyStroke)keyStrokeArray[i]));
                }
                hashSet.add(stringBuffer.toString());
            }
            hashMap.put(shortcutAction, hashSet);
        }
        return hashMap;
    }

    private static Map<ShortcutAction, Set<String>> convertFromEmacs(Map<ShortcutAction, Set<String>> map) {
        HashMap<ShortcutAction, Set<String>> hashMap = new HashMap<ShortcutAction, Set<String>>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
            ShortcutAction shortcutAction = entry.getKey();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : entry.getValue()) {
                KeyStroke[] keyStrokeArray = Utilities.stringToKeys((String)string);
                hashSet.add(Utils.getKeyStrokesAsText(keyStrokeArray, " "));
            }
            hashMap.put(shortcutAction, hashSet);
        }
        return hashMap;
    }

    private static KeyStroke[] getKeyStrokes(String string, String string2) {
        if (string.length() == 0) {
            return new KeyStroke[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = Utils.getKeyStroke(string3);
            if (keyStroke == null) {
                return null;
            }
            arrayList.add(keyStroke);
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(KeymapPanel.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)KeymapViewModel.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)KeymapViewModel.loc(string));
        }
    }

    static class ActionsComparator
    implements Comparator {
        ActionsComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String) {
                if (object2 instanceof String) {
                    return ((String)object).compareTo((String)object2);
                }
                return 1;
            }
            if (object2 instanceof String) {
                return -1;
            }
            return ((ShortcutAction)object).getDisplayName().compareTo(((ShortcutAction)object2).getDisplayName());
        }
    }
}

