/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.openide.loaders.DataObjectAccessor;
import org.netbeans.modules.openide.loaders.UIException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.OpenSupport;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.text.SimpleES;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.CloneableOpenSupport;

public class DataEditorSupport
extends CloneableEditorSupport {
    static final Logger ERR = Logger.getLogger("org.openide.text.DataEditorSupport");
    private final DataObject obj;
    private NodeListener nodeL;
    private static Map<DataObject, Charset> charsets = Collections.synchronizedMap(new HashMap());

    public DataEditorSupport(DataObject dataObject, CloneableEditorSupport.Env env) {
        super(env, (Lookup)new DOEnvLookup(dataObject));
        this.obj = dataObject;
    }

    final CloneableEditorSupport.Env desEnv() {
        return (CloneableEditorSupport.Env)this.env;
    }

    public static CloneableEditorSupport create(DataObject dataObject, MultiDataObject.Entry entry, CookieSet cookieSet) {
        return new SimpleES(dataObject, entry, cookieSet);
    }

    public final DataObject getDataObject() {
        return this.obj;
    }

    protected String messageOpening() {
        return NbBundle.getMessage(DataObject.class, (String)"CTL_ObjectOpen", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
    }

    protected String messageOpened() {
        return null;
    }

    protected String messageSave() {
        return NbBundle.getMessage(DataObject.class, (String)"MSG_SaveFile", (Object)this.obj.getPrimaryFile().getNameExt());
    }

    protected String messageName() {
        if (!this.obj.isValid()) {
            return "";
        }
        return this.addFlagsToName(this.obj.getNodeDelegate().getDisplayName());
    }

    protected String messageHtmlName() {
        if (!this.obj.isValid()) {
            return null;
        }
        String string = this.obj.getNodeDelegate().getHtmlDisplayName();
        if (string != null) {
            if (!string.startsWith("<html>")) {
                string = "<html>" + string;
            }
            string = this.addFlagsToName(string);
        }
        return string;
    }

    private String addFlagsToName(String string) {
        int n = 3;
        if (this.isModified()) {
            n = !this.obj.getPrimaryFile().canWrite() ? 2 : 1;
        } else if (!this.obj.getPrimaryFile().canWrite()) {
            n = 0;
        }
        return NbBundle.getMessage(DataObject.class, (String)"LAB_EditorName", (Object)new Integer(n), (Object)string);
    }

    protected String documentID() {
        if (!this.obj.isValid()) {
            return "";
        }
        return this.obj.getPrimaryFile().getName();
    }

    protected String messageToolTip() {
        return FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile());
    }

    protected String messageLine(Line line) {
        return NbBundle.getMessage(DataObject.class, (String)"FMT_LineDisplayName2", (Object)this.obj.getPrimaryFile().getNameExt(), (Object)FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()), (Object)new Integer(line.getLineNumber() + 1));
    }

    protected void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        if (this.obj.isValid()) {
            Node node = this.obj.getNodeDelegate();
            cloneableEditor.setActivatedNodes(new Node[]{node});
            cloneableEditor.setIcon(node.getIcon(1));
            DataNodeListener dataNodeListener = new DataNodeListener(cloneableEditor);
            node.addNodeListener(NodeOp.weakNodeListener((NodeListener)dataNodeListener, (Object)node));
            this.nodeL = dataNodeListener;
        }
    }

    protected void notifyClosed() {
        this.nodeL = null;
        super.notifyClosed();
    }

    protected StyledDocument createStyledDocument(EditorKit editorKit) {
        StyledDocument styledDocument = super.createStyledDocument(editorKit);
        styledDocument.putProperty("title", FileUtil.getFileDisplayName((FileObject)this.obj.getPrimaryFile()));
        styledDocument.putProperty("stream", this.obj);
        Logger.getLogger("TIMER").log(Level.FINE, "Document", new Object[]{this.obj.getPrimaryFile(), styledDocument});
        return styledDocument;
    }

    protected boolean canClose() {
        if (this.desEnv().isModified() && this.isEnvReadOnly()) {
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DataObject.class, (String)"MSG_FileReadOnlyClosing", (Object[])new Object[]{((Env)this.env).getFileImpl().getNameExt()}), 2, 2));
            return object == NotifyDescriptor.OK_OPTION;
        }
        return super.canClose();
    }

    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        Charset charset = charsets.get(this.getDataObject());
        if (charset == null) {
            charset = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        editorKit.read(inputStreamReader, (Document)styledDocument, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        if (styledDocument == null) {
            throw new NullPointerException("Document is null");
        }
        if (editorKit == null) {
            throw new NullPointerException("Kit is null");
        }
        Charset charset = charsets.get(this.getDataObject());
        if (charset == null) {
            charset = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
        }
        FilterOutputStream filterOutputStream = new FilterOutputStream(outputStream){

            public void close() throws IOException {
                this.flush();
            }
        };
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)filterOutputStream, charset);
        try {
            editorKit.write(outputStreamWriter, (Document)styledDocument, 0, styledDocument.getLength());
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ((Writer)outputStreamWriter).close();
            throw throwable;
        }
        ((Writer)outputStreamWriter).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StyledDocument openDocument() throws IOException {
        StyledDocument styledDocument;
        Charset charset = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
        DataObject dataObject = this.getDataObject();
        try {
            charsets.put(dataObject, charset);
            styledDocument = super.openDocument();
            Object var5_4 = null;
            charsets.remove(dataObject);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            charsets.remove(dataObject);
            throw throwable;
        }
        return styledDocument;
    }

    public void saveDocument() throws IOException {
        SaveImpl saveImpl = new SaveImpl(this);
        FileUtil.runAtomicAction((FileSystem.AtomicAction)saveImpl);
    }

    final void superSaveDoc() throws IOException {
        super.saveDocument();
    }

    boolean isEnvReadOnly() {
        CloneableEditorSupport.Env env = this.desEnv();
        return env instanceof Env && !((Env)env).getFileImpl().canWrite();
    }

    final DataObject getDataObjectHack2() {
        return this.obj;
    }

    final void callUpdateTitles() {
        this.updateTitles();
    }

    public static DataObject findDataObject(Line line) {
        if (line == null) {
            throw new NullPointerException();
        }
        return (DataObject)line.getLookup().lookup(DataObject.class);
    }

    public void saveAs(FileObject fileObject, String string) throws IOException {
        if (this.env instanceof Env) {
            DataFolder dataFolder;
            String string2 = FileUtil.getExtension((String)string);
            DataObject dataObject = null;
            DataObject dataObject2 = this.getDataObject();
            if (!dataObject2.isModified() || null == this.getDocument()) {
                dataFolder = DataFolder.findFolder(fileObject);
                FileObject fileObject2 = fileObject.getFileObject(string);
                if (null != fileObject2) {
                    fileObject2.delete();
                }
                dataObject = DataObjectAccessor.DEFAULT.copyRename(dataObject2, dataFolder, this.getFileNameNoExtension(string), string2);
            } else {
                dataFolder = FileUtil.createData((FileObject)fileObject, (String)string);
                this.saveDocumentAs(dataFolder.getOutputStream());
                dataObject2.setModified(false);
                dataObject = DataObject.find((FileObject)dataFolder);
            }
            if (null != dataObject && null != (dataFolder = dataObject.getCookie(OpenCookie.class))) {
                this.close(false);
                dataFolder.open();
            }
        }
    }

    private String getFileNameNoExtension(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private void saveDocumentAs(final OutputStream outputStream) throws IOException {
        final StyledDocument styledDocument = this.getDocument();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class SaveAsWriter
        implements Runnable {
            private IOException ex;

            SaveAsWriter() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    BufferedOutputStream bufferedOutputStream = null;
                    try {
                        try {
                            bufferedOutputStream = new BufferedOutputStream(outputStream);
                            DataEditorSupport.this.saveFromKitToStream(styledDocument, bufferedOutputStream);
                            ((OutputStream)bufferedOutputStream).close();
                            return;
                        }
                        catch (BadLocationException badLocationException) {
                            ERR.log(Level.INFO, null, badLocationException);
                            Object var4_4 = null;
                            if (bufferedOutputStream == null) return;
                            ((OutputStream)bufferedOutputStream).close();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (bufferedOutputStream == null) throw throwable;
                        ((OutputStream)bufferedOutputStream).close();
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    this.ex = iOException;
                }
            }

            public void after() throws IOException {
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        SaveAsWriter saveAsWriter = new SaveAsWriter();
        styledDocument.render(saveAsWriter);
        saveAsWriter.after();
    }

    private void saveFromKitToStream(StyledDocument styledDocument, OutputStream outputStream) throws IOException, BadLocationException {
        EditorKit editorKit = this.createEditorKit();
        this.saveFromKitToStream(styledDocument, editorKit, outputStream);
    }

    private static class SaveImpl
    implements FileSystem.AtomicAction {
        private static final SaveImpl DEFAULT = new SaveImpl(null);
        private final DataEditorSupport des;

        public SaveImpl(DataEditorSupport dataEditorSupport) {
            this.des = dataEditorSupport;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            if (this.des.desEnv().isModified() && this.des.isEnvReadOnly()) {
                IOException iOException = new IOException("File is read-only: " + ((Env)this.des.env).getFileImpl());
                UIException.annotateUser(iOException, null, NbBundle.getMessage(DataObject.class, (String)"MSG_FileReadOnlySaving", (Object[])new Object[]{((Env)this.des.env).getFileImpl().getNameExt()}), null, null);
                throw iOException;
            }
            DataObject dataObject = this.des.getDataObject();
            Charset charset = FileEncodingQuery.getEncoding((FileObject)dataObject.getPrimaryFile());
            try {
                charsets.put(dataObject, charset);
                this.des.superSaveDoc();
                Object var4_4 = null;
                charsets.remove(dataObject);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                charsets.remove(dataObject);
                throw throwable;
            }
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass();
        }
    }

    private static class DOEnvLookup
    extends AbstractLookup
    implements PropertyChangeListener {
        static final long serialVersionUID = 333L;
        private DataObject dobj;
        private InstanceContent ic;

        public DOEnvLookup(DataObject dataObject) {
            this(dataObject, new InstanceContent());
        }

        private DOEnvLookup(DataObject dataObject, InstanceContent instanceContent) {
            super((AbstractLookup.Content)instanceContent);
            this.ic = instanceContent;
            this.dobj = dataObject;
            dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataObject));
            this.updateLookup();
        }

        private void updateLookup() {
            this.ic.set(Arrays.asList(this.dobj, this.dobj.getPrimaryFile()), null);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("primaryFile")) {
                this.updateLookup();
            }
        }
    }

    private final class DataNodeListener
    extends NodeAdapter {
        CloneableEditor editor;

        DataNodeListener(CloneableEditor cloneableEditor) {
            this.editor = cloneableEditor;
        }

        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    if ("displayName".equals(propertyChangeEvent.getPropertyName())) {
                        DataEditorSupport.this.callUpdateTitles();
                    }
                    if ("icon".equals(propertyChangeEvent.getPropertyName()) && DataEditorSupport.this.obj.isValid()) {
                        DataNodeListener.this.editor.setIcon(DataEditorSupport.this.obj.getNodeDelegate().getIcon(1));
                    }
                }
            });
        }
    }

    private static final class EnvListener
    extends FileChangeAdapter {
        private Reference<Env> env;

        public EnvListener(Env env) {
            this.env = new WeakReference<Env>(env);
        }

        public void fileDeleted(FileEvent fileEvent) {
            Env env = this.env.get();
            FileObject fileObject = fileEvent.getFile();
            if (env == null || env.getFileImpl() != fileObject) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
                return;
            }
            fileObject.removeFileChangeListener((FileChangeListener)this);
            env.fileRemoved(true);
            fileObject.addFileChangeListener((FileChangeListener)this);
        }

        public void fileChanged(FileEvent fileEvent) {
            if (fileEvent.firedFrom((FileSystem.AtomicAction)SaveImpl.DEFAULT)) {
                return;
            }
            Env env = this.env.get();
            if (env == null || env.getFileImpl() != fileEvent.getFile()) {
                fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                return;
            }
            if (fileEvent.getFile().isVirtual()) {
                fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
                env.fileRemoved(true);
                fileEvent.getFile().addFileChangeListener((FileChangeListener)this);
            } else {
                env.fileChanged(fileEvent.isExpected(), fileEvent.getTime());
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            Env env = this.env.get();
            if (env != null) {
                env.fileRenamed();
            }
        }
    }

    public static abstract class Env
    extends OpenSupport.Env
    implements CloneableEditorSupport.Env {
        private static final long serialVersionUID = -2945098431098324441L;
        private transient FileObject fileObject;
        transient FileLock fileLock;
        private transient boolean warned;

        public Env(DataObject dataObject) {
            super(dataObject);
        }

        private FileObject getFileImpl() {
            this.changeFile();
            return this.fileObject;
        }

        protected abstract FileObject getFile();

        protected abstract FileLock takeLock() throws IOException;

        protected final void changeFile() {
            boolean bl;
            FileObject fileObject = this.getFile();
            if (fileObject.equals(this.fileObject)) {
                return;
            }
            if (this.fileLock != null) {
                if (this.fileLock.isValid()) {
                    ERR.fine("changeFile releaseLock: " + this.fileLock + " for " + this.fileObject);
                    this.fileLock.releaseLock();
                    bl = true;
                } else {
                    this.fileLock = null;
                    bl = false;
                }
            } else {
                bl = false;
            }
            boolean bl2 = this.fileObject == null;
            this.fileObject = fileObject;
            ERR.fine("changeFile: " + fileObject + " for " + this.fileObject);
            this.fileObject.addFileChangeListener((FileChangeListener)new EnvListener(this));
            if (bl) {
                try {
                    this.fileLock = this.takeLock();
                    ERR.fine("changeFile takeLock: " + this.fileLock + " for " + this.fileObject);
                }
                catch (IOException iOException) {
                    Logger.getLogger(DataEditorSupport.class.getName()).log(Level.WARNING, null, iOException);
                }
            }
            if (!bl2) {
                this.firePropertyChange("expectedTime", null, this.getTime());
            }
        }

        public InputStream inputStream() throws IOException {
            FileObject fileObject = this.getFileImpl();
            if (!this.warned && fileObject.getSize() > 0x100000L) {
                throw new ME(fileObject.getSize());
            }
            InputStream inputStream = this.getFileImpl().getInputStream();
            return inputStream;
        }

        public OutputStream outputStream() throws IOException {
            ERR.fine("outputStream: " + this.fileLock + " for " + this.fileObject);
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            ERR.fine("outputStream after takeLock: " + this.fileLock + " for " + this.fileObject);
            try {
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
            catch (IOException iOException) {
                if (this.fileLock == null || !this.fileLock.isValid()) {
                    this.fileLock = this.takeLock();
                }
                ERR.fine("ugly workaround for #40552: " + this.fileLock + " for " + this.fileObject);
                return this.getFileImpl().getOutputStream(this.fileLock);
            }
        }

        public Date getTime() {
            this.getFileImpl().refresh(false);
            return this.getFileImpl().lastModified();
        }

        public String getMimeType() {
            return this.getFileImpl().getMIMEType();
        }

        public void markModified() throws IOException {
            if (this.fileLock == null || !this.fileLock.isValid()) {
                this.fileLock = this.takeLock();
            }
            ERR.fine("markModified: " + this.fileLock + " for " + this.fileObject);
            if (!this.getFileImpl().canWrite()) {
                if (this.fileLock != null && this.fileLock.isValid()) {
                    this.fileLock.releaseLock();
                }
                throw new IOException("File " + this.getFileImpl().getNameExt() + " is read-only!");
            }
            this.getDataObject().setModified(true);
        }

        public void unmarkModified() {
            ERR.fine("unmarkModified: " + this.fileLock + " for " + this.fileObject);
            if (this.fileLock != null && this.fileLock.isValid()) {
                this.fileLock.releaseLock();
                ERR.fine("releaseLock: " + this.fileLock + " for " + this.fileObject);
            }
            this.getDataObject().setModified(false);
        }

        final void fileChanged(boolean bl, long l) {
            ERR.fine("fileChanged: " + bl + " for " + this.fileObject);
            if (bl) {
                this.firePropertyChange("time", null, null);
            } else {
                this.firePropertyChange("time", null, new Date(l));
            }
        }

        final void fileRemoved(boolean bl) {
        }

        final void fileRenamed() {
            this.firePropertyChange("expectedTime", null, this.getTime());
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            CloneableOpenSupport.Env env;
            CloneableOpenSupport cloneableOpenSupport = super.findCloneableOpenSupport();
            if (cloneableOpenSupport instanceof DataEditorSupport && (env = ((DataEditorSupport)cloneableOpenSupport).env) != this && env instanceof Env) {
                ((Env)env).warned = this.warned;
            }
            return cloneableOpenSupport;
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this.warned = true;
        }

        class ME
        extends UserQuestionException {
            static final long serialVersionUID = 1L;
            private long size;

            public ME(long l) {
                super("The file is too big. " + l + " bytes.");
                this.size = l;
            }

            public String getLocalizedMessage() {
                Object[] objectArray = new Object[]{Env.this.getFileImpl().getPath(), Env.this.getFileImpl().getNameExt(), new Long(this.size), new Long(this.size / 1024L + 1L), new Long(this.size / 0x100000L), new Long(this.size / 0x40000000L)};
                return NbBundle.getMessage(DataObject.class, (String)"MSG_ObjectIsTooBig", (Object[])objectArray);
            }

            public void confirmed() {
                Env.this.warned = true;
            }
        }

        private class SaveAsCapableImpl
        implements SaveAsCapable {
            private SaveAsCapableImpl() {
            }

            public void saveAs(FileObject fileObject, String string) throws IOException {
                CloneableOpenSupport cloneableOpenSupport = Env.super.findCloneableOpenSupport();
                if (cloneableOpenSupport instanceof DataEditorSupport) {
                    ((DataEditorSupport)cloneableOpenSupport).saveAs(fileObject, string);
                }
            }
        }
    }
}

